/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.recipe.crafting;

import dev.aaronhowser.mods.aaron.AaronExtensions;
import dev.aaronhowser.mods.irregular_implements.registry.ModDataComponents;
import dev.aaronhowser.mods.irregular_implements.registry.ModItems;
import dev.aaronhowser.mods.irregular_implements.registry.ModRecipeSerializers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.Unit;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0016J\f\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u001d"}, d2={"Ldev/aaronhowser/mods/irregular_implements/recipe/crafting/LubricateBootRecipe;", "Lnet/minecraft/world/item/crafting/CustomRecipe;", "craftingCategory", "Lnet/minecraft/world/item/crafting/CraftingBookCategory;", "<init>", "(Lnet/minecraft/world/item/crafting/CraftingBookCategory;)V", "bootIngredient", "Lnet/minecraft/world/item/crafting/Ingredient;", "getBootIngredient", "()Lnet/minecraft/world/item/crafting/Ingredient;", "lubeIngredient", "getLubeIngredient", "matches", "", "input", "Lnet/minecraft/world/item/crafting/CraftingInput;", "level", "Lnet/minecraft/world/level/Level;", "assemble", "Lnet/minecraft/world/item/ItemStack;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "canCraftInDimensions", "width", "", "height", "getSerializer", "Lnet/minecraft/world/item/crafting/RecipeSerializer;", "Companion", "irregular-implements-1.21.1"})
@SourceDebugExtension(value={"SMAP\nLubricateBootRecipe.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LubricateBootRecipe.kt\ndev/aaronhowser/mods/irregular_implements/recipe/crafting/LubricateBootRecipe\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n37#2,2:83\n774#3:85\n865#3,2:86\n1563#3:88\n1634#3,3:89\n*S KotlinDebug\n*F\n+ 1 LubricateBootRecipe.kt\ndev/aaronhowser/mods/irregular_implements/recipe/crafting/LubricateBootRecipe\n*L\n19#1:83,2\n79#1:85\n79#1:86,2\n80#1:88\n80#1:89,3\n*E\n"})
public final class LubricateBootRecipe
extends CustomRecipe {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Ingredient bootIngredient;
    @NotNull
    private final Ingredient lubeIngredient;
    @NotNull
    private static final List<ItemStack> ALL_BOOTS;

    public LubricateBootRecipe(@NotNull CraftingBookCategory craftingCategory) {
        Intrinsics.checkNotNullParameter((Object)craftingCategory, (String)"craftingCategory");
        super(craftingCategory);
        Collection $this$toTypedArray$iv = ALL_BOOTS;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        ItemStack[] itemStackArray = thisCollection$iv.toArray(new ItemStack[0]);
        Ingredient ingredient = Ingredient.of((ItemStack[])Arrays.copyOf(itemStackArray, itemStackArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)ingredient, (String)"of(...)");
        this.bootIngredient = ingredient;
        this.lubeIngredient = AaronExtensions.INSTANCE.asIngredient((ItemLike)ModItems.INSTANCE.getSUPER_LUBRICANT_TINCTURE());
    }

    public /* synthetic */ LubricateBootRecipe(CraftingBookCategory craftingBookCategory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            craftingBookCategory = CraftingBookCategory.MISC;
        }
        this(craftingBookCategory);
    }

    @NotNull
    public final Ingredient getBootIngredient() {
        return this.bootIngredient;
    }

    @NotNull
    public final Ingredient getLubeIngredient() {
        return this.lubeIngredient;
    }

    public boolean matches(@NotNull CraftingInput input, @NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        ItemStack bootStack = null;
        ItemStack lubeStack = null;
        for (ItemStack stack : input.items()) {
            if (this.bootIngredient.test(stack)) {
                if (bootStack != null) {
                    return false;
                }
                bootStack = stack;
            }
            if (this.lubeIngredient.test(stack)) {
                if (lubeStack != null) {
                    return false;
                }
                lubeStack = stack;
            }
            if (bootStack == null || lubeStack == null) continue;
        }
        return bootStack != null && lubeStack != null && !bootStack.has((Supplier)ModDataComponents.LUBRICATED);
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingInput input, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        ItemStack bootStack = null;
        ItemStack lubeStack = null;
        for (ItemStack stack : input.items()) {
            if (this.bootIngredient.test(stack)) {
                if (bootStack != null) {
                    ItemStack itemStack = ItemStack.EMPTY;
                    Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                    return itemStack;
                }
                bootStack = stack;
            }
            if (this.lubeIngredient.test(stack)) {
                if (lubeStack != null) {
                    ItemStack itemStack = ItemStack.EMPTY;
                    Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                    return itemStack;
                }
                lubeStack = stack;
            }
            if (bootStack == null || lubeStack == null) continue;
        }
        if (bootStack == null || lubeStack == null) {
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }
        ItemStack newBootStack = bootStack.copy();
        newBootStack.set((Supplier)ModDataComponents.LUBRICATED, (Object)Unit.INSTANCE);
        Intrinsics.checkNotNull((Object)newBootStack);
        return newBootStack;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        Object object = ModRecipeSerializers.INSTANCE.getLUBRICATE_BOOT().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (RecipeSerializer)object;
    }

    public LubricateBootRecipe() {
        this(null, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        Item it;
        Iterable $this$filterTo$iv$iv;
        Companion = new Companion(null);
        DefaultedRegistry defaultedRegistry = BuiltInRegistries.ITEM;
        Intrinsics.checkNotNullExpressionValue((Object)defaultedRegistry, (String)"ITEM");
        Iterable $this$filter$iv = (Iterable)defaultedRegistry;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Item)element$iv$iv;
            boolean bl = false;
            if (!(it instanceof ArmorItem && ((ArmorItem)it).getType() == ArmorItem.Type.BOOTS)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Item)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getDefaultInstance());
        }
        ALL_BOOTS = (List)var3_3;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001f\u0010\u0004\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Ldev/aaronhowser/mods/irregular_implements/recipe/crafting/LubricateBootRecipe$Companion;", "", "<init>", "()V", "ALL_BOOTS", "", "Lnet/minecraft/world/item/ItemStack;", "kotlin.jvm.PlatformType", "getALL_BOOTS", "()Ljava/util/List;", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<ItemStack> getALL_BOOTS() {
            return ALL_BOOTS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

