/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.menu.item_filter;

import dev.aaronhowser.mods.irregular_implements.item.component.ItemFilterDataComponent;
import dev.aaronhowser.mods.irregular_implements.registry.ModDataComponents;
import dev.aaronhowser.mods.irregular_implements.util.FilterEntry;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.NonInteractiveResultSlot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B-\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004H\u0016J\b\u0010\u001e\u001a\u00020\u0004H\u0016J\u0010\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\bH\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u001d\u001a\u00020\u0004H\u0016J\b\u0010#\u001a\u00020\u0019H\u0016J\b\u0010$\u001a\u00020\bH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\u0004\u0018\u00010\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006%"}, d2={"Ldev/aaronhowser/mods/irregular_implements/menu/item_filter/ItemFilterSlot;", "Lnet/minecraft/world/inventory/NonInteractiveResultSlot;", "filterStack", "Ljava/util/function/Supplier;", "Lnet/minecraft/world/item/ItemStack;", "lookupProvider", "Lnet/minecraft/core/HolderLookup$Provider;", "x", "", "y", "<init>", "(Ljava/util/function/Supplier;Lnet/minecraft/core/HolderLookup$Provider;II)V", "stackComponent", "Ldev/aaronhowser/mods/irregular_implements/item/component/ItemFilterDataComponent;", "getStackComponent", "()Ldev/aaronhowser/mods/irregular_implements/item/component/ItemFilterDataComponent;", "stackFilter", "Lnet/minecraft/core/NonNullList;", "Ldev/aaronhowser/mods/irregular_implements/util/FilterEntry;", "getStackFilter", "()Lnet/minecraft/core/NonNullList;", "entryInThisSlot", "getEntryInThisSlot", "()Ldev/aaronhowser/mods/irregular_implements/util/FilterEntry;", "mayPickup", "", "player", "Lnet/minecraft/world/entity/player/Player;", "safeInsert", "stack", "getItem", "remove", "amount", "set", "", "isHighlightable", "getSlotIndex", "irregular-implements-1.21.1"})
public final class ItemFilterSlot
extends NonInteractiveResultSlot {
    @NotNull
    private final Supplier<ItemStack> filterStack;
    @NotNull
    private final HolderLookup.Provider lookupProvider;

    public ItemFilterSlot(@NotNull Supplier<ItemStack> filterStack, @NotNull HolderLookup.Provider lookupProvider, int x, int y) {
        Intrinsics.checkNotNullParameter(filterStack, (String)"filterStack");
        Intrinsics.checkNotNullParameter((Object)lookupProvider, (String)"lookupProvider");
        super((Container)new SimpleContainer(0), 0, x, y);
        this.filterStack = filterStack;
        this.lookupProvider = lookupProvider;
    }

    private final ItemFilterDataComponent getStackComponent() {
        return (ItemFilterDataComponent)this.filterStack.get().get((Supplier)ModDataComponents.INSTANCE.getITEM_FILTER());
    }

    private final NonNullList<FilterEntry> getStackFilter() {
        ItemFilterDataComponent itemFilterDataComponent = this.getStackComponent();
        return itemFilterDataComponent != null ? itemFilterDataComponent.getEntries() : null;
    }

    private final FilterEntry getEntryInThisSlot() {
        NonNullList<FilterEntry> nonNullList = this.getStackFilter();
        return nonNullList != null ? (FilterEntry)CollectionsKt.getOrNull((List)((List)nonNullList), (int)this.index) : null;
    }

    public boolean mayPickup(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        NonNullList<FilterEntry> nonNullList = this.getStackFilter();
        if (nonNullList == null) {
            return false;
        }
        NonNullList<FilterEntry> stackFilter = nonNullList;
        List newFilter = CollectionsKt.toMutableList((Collection)((Collection)stackFilter));
        newFilter.set(this.index, FilterEntry.Empty.INSTANCE);
        ItemFilterDataComponent itemFilterDataComponent = this.getStackComponent();
        this.filterStack.get().set((Supplier)ModDataComponents.INSTANCE.getITEM_FILTER(), (Object)new ItemFilterDataComponent(newFilter, itemFilterDataComponent != null ? itemFilterDataComponent.isBlacklist() : false));
        return false;
    }

    @NotNull
    public ItemStack safeInsert(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (stack.isEmpty()) {
            return stack;
        }
        if (!(this.getEntryInThisSlot() instanceof FilterEntry.Empty) && this.getEntryInThisSlot() != null) {
            return stack;
        }
        NonNullList<FilterEntry> nonNullList = this.getStackFilter();
        if (nonNullList == null) {
            return stack;
        }
        NonNullList<FilterEntry> oldFilter = nonNullList;
        List newFilter = CollectionsKt.toMutableList((Collection)((Collection)ItemFilterDataComponent.Companion.sanitizeEntries((List)oldFilter)));
        ItemStack itemStack = stack.copyWithCount(1);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copyWithCount(...)");
        newFilter.set(this.index, new FilterEntry.Item(itemStack, false));
        ItemFilterDataComponent itemFilterDataComponent = this.getStackComponent();
        this.filterStack.get().set((Supplier)ModDataComponents.INSTANCE.getITEM_FILTER(), (Object)new ItemFilterDataComponent(newFilter, itemFilterDataComponent != null ? itemFilterDataComponent.isBlacklist() : false));
        return stack;
    }

    @NotNull
    public ItemStack getItem() {
        FilterEntry filterEntry = this.getEntryInThisSlot();
        if (filterEntry == null || (filterEntry = filterEntry.getDisplayStack(this.lookupProvider)) == null) {
            ItemStack itemStack = ItemStack.EMPTY;
            filterEntry = itemStack;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
        }
        return filterEntry;
    }

    @NotNull
    public ItemStack remove(int amount) {
        ItemStack itemStack = ItemStack.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
        return itemStack;
    }

    public void set(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
    }

    public boolean isHighlightable() {
        return true;
    }

    public int getSlotIndex() {
        return 0;
    }
}

