/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.item;

import dev.aaronhowser.mods.irregular_implements.registry.ModDataComponents;
import dev.aaronhowser.mods.irregular_implements.registry.ModItems;
import java.util.Optional;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICurioItem;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u00012\u00020\u0002:\u0001\u0016B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J0\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u0017"}, d2={"Ldev/aaronhowser/mods/irregular_implements/item/LavaCharmItem;", "Lnet/minecraft/world/item/Item;", "Ltop/theillusivec4/curios/api/type/capability/ICurioItem;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "inventoryTick", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "level", "Lnet/minecraft/world/level/Level;", "entity", "Lnet/minecraft/world/entity/Entity;", "slotId", "", "isSelected", "", "curioTick", "slotContext", "Ltop/theillusivec4/curios/api/SlotContext;", "Companion", "irregular-implements-1.21.1"})
public final class LavaCharmItem
extends Item
implements ICurioItem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int MAX_CHARGE = 200;
    public static final int MAX_COOLDOWN = 40;
    @NotNull
    private static final Supplier<Item.Properties> DEFAULT_PROPERTIES = LavaCharmItem::DEFAULT_PROPERTIES$lambda$0;

    public LavaCharmItem(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slotId, boolean isSelected) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Companion.charge(stack);
    }

    public void curioTick(@NotNull SlotContext slotContext, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)slotContext, (String)"slotContext");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Companion.charge(stack);
    }

    private static final Item.Properties DEFAULT_PROPERTIES$lambda$0() {
        return new Item.Properties().stacksTo(1).rarity(Rarity.RARE).fireResistant().component((Supplier)ModDataComponents.INSTANCE.getCOOLDOWN(), (Object)0).component((Supplier)ModDataComponents.INSTANCE.getCHARGE(), (Object)200);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0017\u001a\u00020\u0018R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Ldev/aaronhowser/mods/irregular_implements/item/LavaCharmItem$Companion;", "", "<init>", "()V", "MAX_CHARGE", "", "MAX_COOLDOWN", "DEFAULT_PROPERTIES", "Ljava/util/function/Supplier;", "Lnet/minecraft/world/item/Item$Properties;", "getDEFAULT_PROPERTIES", "()Ljava/util/function/Supplier;", "charge", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "tryBlockLavaDamage", "event", "Lnet/neoforged/neoforge/event/entity/living/LivingIncomingDamageEvent;", "isChargedLavaCharm", "", "isChargedLavaWader", "getFirstLavaProtector", "entity", "Lnet/minecraft/world/entity/LivingEntity;", "irregular-implements-1.21.1"})
    @SourceDebugExtension(value={"SMAP\nLavaCharmItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LavaCharmItem.kt\ndev/aaronhowser/mods/irregular_implements/item/LavaCharmItem$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,110:1\n295#2,2:111\n295#2,2:113\n*S KotlinDebug\n*F\n+ 1 LavaCharmItem.kt\ndev/aaronhowser/mods/irregular_implements/item/LavaCharmItem$Companion\n*L\n99#1:111,2\n105#1:113,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Supplier<Item.Properties> getDEFAULT_PROPERTIES() {
            return DEFAULT_PROPERTIES;
        }

        public final void charge(@NotNull ItemStack stack) {
            int cooldown;
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Integer n = (Integer)stack.get((Supplier)ModDataComponents.INSTANCE.getCHARGE());
            int charge = n != null ? n : 0;
            Integer n2 = (Integer)stack.get((Supplier)ModDataComponents.INSTANCE.getCOOLDOWN());
            int n3 = cooldown = n2 != null ? n2 : 40;
            if (cooldown >= 1) {
                stack.set((Supplier)ModDataComponents.INSTANCE.getCOOLDOWN(), (Object)(cooldown - 1));
                return;
            }
            if (charge < 200) {
                stack.set((Supplier)ModDataComponents.INSTANCE.getCHARGE(), (Object)(charge + 1));
            }
        }

        public final void tryBlockLavaDamage(@NotNull LivingIncomingDamageEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (event.isCanceled() || !event.getSource().is(DamageTypes.LAVA)) {
                return;
            }
            LivingEntity entity = event.getEntity();
            Intrinsics.checkNotNull((Object)entity);
            ItemStack itemStack = this.getFirstLavaProtector(entity);
            if (itemStack == null) {
                return;
            }
            ItemStack lavaProtectorStack = itemStack;
            Integer n = (Integer)lavaProtectorStack.get((Supplier)ModDataComponents.INSTANCE.getCHARGE());
            if (n == null) {
                return;
            }
            int charge = n;
            if (charge > 0) {
                lavaProtectorStack.set((Supplier)ModDataComponents.INSTANCE.getCHARGE(), (Object)(charge - 1));
                lavaProtectorStack.set((Supplier)ModDataComponents.INSTANCE.getCOOLDOWN(), (Object)40);
                event.setCanceled(true);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isChargedLavaCharm(ItemStack stack) {
            if (!stack.is((Holder)ModItems.INSTANCE.getLAVA_CHARM())) return false;
            Integer n = (Integer)stack.get((Supplier)ModDataComponents.INSTANCE.getCHARGE());
            if (n == null) return false;
            int n2 = n;
            if (n2 <= 0) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isChargedLavaWader(ItemStack stack) {
            if (!stack.is((Holder)ModItems.INSTANCE.getLAVA_WADERS())) return false;
            Integer n = (Integer)stack.get((Supplier)ModDataComponents.INSTANCE.getCHARGE());
            if (n == null) return false;
            int n2 = n;
            if (n2 <= 0) return false;
            return true;
        }

        @Nullable
        public final ItemStack getFirstLavaProtector(@NotNull LivingEntity entity) {
            Object v5;
            block7: {
                Object object;
                Optional optional;
                ItemStack curioProtector;
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                ItemStack footArmor = entity.getItemBySlot(EquipmentSlot.FEET);
                Intrinsics.checkNotNull((Object)footArmor);
                if (this.isChargedLavaWader(footArmor)) {
                    return footArmor;
                }
                Optional optional2 = CuriosApi.getCuriosInventory((LivingEntity)entity);
                Intrinsics.checkNotNullExpressionValue((Object)optional2, (String)"getCuriosInventory(...)");
                ICuriosItemHandler iCuriosItemHandler = (ICuriosItemHandler)OptionalsKt.getOrNull((Optional)optional2);
                ItemStack itemStack = curioProtector = iCuriosItemHandler != null && (optional = iCuriosItemHandler.findFirstCurio(this::isChargedLavaCharm)) != null && (object = (SlotResult)OptionalsKt.getOrNull((Optional)optional)) != null ? object.stack() : null;
                if (curioProtector != null) {
                    return curioProtector;
                }
                if (entity instanceof Player) {
                    Object v3;
                    block6: {
                        NonNullList nonNullList = ((Player)entity).getInventory().items;
                        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"items");
                        Iterable $this$firstOrNull$iv = (Iterable)nonNullList;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            ItemStack p0 = (ItemStack)element$iv;
                            boolean bl = false;
                            if (!this.isChargedLavaCharm(p0)) continue;
                            v3 = element$iv;
                            break block6;
                        }
                        v3 = null;
                    }
                    ItemStack inventoryCharm = v3;
                    if (inventoryCharm != null) {
                        return inventoryCharm;
                    }
                }
                Iterable iterable = entity.getHandSlots();
                Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getHandSlots(...)");
                Iterable $this$firstOrNull$iv = iterable;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ItemStack p0 = (ItemStack)element$iv;
                    boolean bl = false;
                    if (!this.isChargedLavaCharm(p0)) continue;
                    v5 = element$iv;
                    break block7;
                }
                v5 = null;
            }
            return v5;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

