/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.handler;

import dev.aaronhowser.mods.irregular_implements.datagen.ModLanguageProvider;
import dev.aaronhowser.mods.irregular_implements.registry.ModDataComponents;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.FallLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001a\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u00112\u0006\u0010\f\u001a\u00020\rJ,\u0010\u0014\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0007H\u0007J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001d\u001a\u00020\rH\u0007J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00020\rH\u0007R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Ldev/aaronhowser/mods/irregular_implements/handler/FluidWalkingHandler;", "", "<init>", "()V", "FLUID_SHAPES", "", "", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "FLUID_BOOT_FALL", "Lnet/minecraft/world/damagesource/FallLocation;", "shouldEntityStandOnFluid", "", "livingEntity", "Lnet/minecraft/world/entity/LivingEntity;", "fluidState", "Lnet/minecraft/world/level/material/FluidState;", "getFluidsEntityCanStandOn", "", "Lnet/minecraft/tags/TagKey;", "Lnet/minecraft/world/level/material/Fluid;", "checkCollisionShape", "level", "Lnet/minecraft/world/level/BlockGetter;", "pos", "Lnet/minecraft/core/BlockPos;", "context", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "original", "fluidWalkingFallLocation", "entity", "fluidWalkingDeathMessage", "Lnet/minecraft/network/chat/Component;", "irregular-implements-1.21.1"})
@SourceDebugExtension(value={"SMAP\nFluidWalkingHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FluidWalkingHandler.kt\ndev/aaronhowser/mods/irregular_implements/handler/FluidWalkingHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,116:1\n1761#2,3:117\n1761#2,3:120\n*S KotlinDebug\n*F\n+ 1 FluidWalkingHandler.kt\ndev/aaronhowser/mods/irregular_implements/handler/FluidWalkingHandler\n*L\n31#1:117,3\n100#1:120,3\n*E\n"})
public final class FluidWalkingHandler {
    @NotNull
    public static final FluidWalkingHandler INSTANCE = new FluidWalkingHandler();
    @NotNull
    private static final Map<Float, VoxelShape> FLUID_SHAPES = new LinkedHashMap();
    @JvmField
    @NotNull
    public static final FallLocation FLUID_BOOT_FALL = new FallLocation("fluid_boot_fall");

    private FluidWalkingHandler() {
    }

    public final boolean shouldEntityStandOnFluid(@NotNull LivingEntity livingEntity, @NotNull FluidState fluidState) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
            Intrinsics.checkNotNullParameter((Object)fluidState, (String)"fluidState");
            Set<TagKey<Fluid>> fluidsEntityCanStandOn = this.getFluidsEntityCanStandOn(livingEntity);
            Iterable $this$any$iv = fluidsEntityCanStandOn;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TagKey it = (TagKey)element$iv;
                    boolean bl2 = false;
                    if (!fluidState.is(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final Set<TagKey<Fluid>> getFluidsEntityCanStandOn(@NotNull LivingEntity livingEntity) {
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        if (livingEntity.isCrouching() || livingEntity.isUnderWater()) {
            return SetsKt.emptySet();
        }
        Set fluidTags = new LinkedHashSet();
        List bodySlots = CollectionsKt.minus((Iterable)CollectionsKt.minus((Iterable)((Iterable)EntriesMappings.entries$0), (Object)EquipmentSlot.MAINHAND), (Object)EquipmentSlot.OFFHAND);
        for (EquipmentSlot slot : bodySlots) {
            ItemStack armorItem = livingEntity.getItemBySlot(slot);
            Object object = armorItem.getOrDefault((Supplier)ModDataComponents.INSTANCE.getCAN_STAND_ON_FLUIDS(), (Object)CollectionsKt.emptyList());
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getOrDefault(...)");
            fluidTags.addAll((Collection)object);
        }
        CuriosApi.getCuriosInventory((LivingEntity)livingEntity).ifPresent(arg_0 -> FluidWalkingHandler.getFluidsEntityCanStandOn$lambda$2(arg_0 -> FluidWalkingHandler.getFluidsEntityCanStandOn$lambda$1(fluidTags, arg_0), arg_0));
        return fluidTags;
    }

    @JvmStatic
    @Nullable
    public static final VoxelShape checkCollisionShape(@NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context, @Nullable VoxelShape original) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(context instanceof EntityCollisionContext)) {
            return null;
        }
        Entity entity = ((EntityCollisionContext)context).getEntity();
        LivingEntity livingEntity = entity instanceof LivingEntity ? (LivingEntity)entity : null;
        if (livingEntity == null) {
            return null;
        }
        LivingEntity entity2 = livingEntity;
        FluidState fluidState = level.getFluidState(pos);
        float fluidHeight = fluidState.getHeight(level, pos);
        if (fluidHeight <= 0.0f) {
            return null;
        }
        Intrinsics.checkNotNull((Object)fluidState);
        if (!INSTANCE.shouldEntityStandOnFluid(entity2, fluidState)) {
            return null;
        }
        VoxelShape voxelShape = FLUID_SHAPES.computeIfAbsent(Float.valueOf(fluidHeight), arg_0 -> FluidWalkingHandler.checkCollisionShape$lambda$4(FluidWalkingHandler::checkCollisionShape$lambda$3, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"computeIfAbsent(...)");
        VoxelShape shape = voxelShape;
        if (!((EntityCollisionContext)context).isAbove(shape, pos, true)) {
            return null;
        }
        VoxelShape voxelShape2 = original;
        return voxelShape2 == null ? shape : Shapes.or((VoxelShape)voxelShape2, (VoxelShape)shape);
    }

    @JvmStatic
    @Nullable
    public static final FallLocation fluidWalkingFallLocation(@NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        FluidState fluidBelow = entity.level().getFluidState(entity.blockPosition());
        Intrinsics.checkNotNull((Object)fluidBelow);
        if (!INSTANCE.shouldEntityStandOnFluid(entity, fluidBelow)) {
            return null;
        }
        return FLUID_BOOT_FALL;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Component fluidWalkingDeathMessage(@NotNull LivingEntity entity) {
        Component component;
        boolean bootWasResponsible;
        Object[] objectArray;
        ItemStack bootArmor;
        FluidState fluidBelow;
        block7: {
            void $this$any$iv;
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            fluidBelow = entity.level().getFluidState(entity.blockPosition());
            bootArmor = entity.getItemBySlot(EquipmentSlot.FEET);
            Object object = bootArmor.getOrDefault((Supplier)ModDataComponents.INSTANCE.getCAN_STAND_ON_FLUIDS(), (Object)CollectionsKt.emptyList());
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getOrDefault(...)");
            objectArray = (Object[])object;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v1 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TagKey it = (TagKey)element$iv;
                    boolean bl = false;
                    if (!fluidBelow.is(it)) continue;
                    v1 = true;
                    break block7;
                }
                v1 = bootWasResponsible = false;
            }
        }
        if (bootWasResponsible) {
            objectArray = new Object[3];
            Component component2 = entity.getDisplayName();
            if (component2 == null) {
                component2 = entity.getName();
            }
            objectArray[0] = component2;
            objectArray[1] = fluidBelow.getFluidType().getDescription();
            objectArray[2] = bootArmor.getDisplayName();
            component = (Component)ModLanguageProvider.Companion.toComponent("death.fell.accident.fluid_fall.boot", objectArray);
        } else {
            objectArray = new Object[2];
            Component component3 = entity.getDisplayName();
            if (component3 == null) {
                component3 = entity.getName();
            }
            objectArray[0] = component3;
            objectArray[1] = fluidBelow.getFluidType().getDescription();
            component = (Component)ModLanguageProvider.Companion.toComponent("death.fell.accident.fluid_fall.generic", objectArray);
        }
        return component;
    }

    private static final Unit getFluidsEntityCanStandOn$lambda$1(Set $fluidTags, ICuriosItemHandler it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        int n = it.getEquippedCurios().getSlots();
        for (int slot = 0; slot < n; ++slot) {
            ItemStack stack = it.getEquippedCurios().getStackInSlot(slot);
            Object object = stack.getOrDefault((Supplier)ModDataComponents.INSTANCE.getCAN_STAND_ON_FLUIDS(), (Object)CollectionsKt.emptyList());
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getOrDefault(...)");
            $fluidTags.addAll((Collection)object);
        }
        return Unit.INSTANCE;
    }

    private static final void getFluidsEntityCanStandOn$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final VoxelShape checkCollisionShape$lambda$3(Float it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)(it.floatValue() * (float)16), (double)16.0);
    }

    private static final VoxelShape checkCollisionShape$lambda$4(Function1 $tmp0, Object p0) {
        return (VoxelShape)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<EquipmentSlot> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])EquipmentSlot.values()));
        }
    }
}

