/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.entity;

import dev.aaronhowser.mods.aaron.AaronExtensions;
import dev.aaronhowser.mods.irregular_implements.item.WeatherEggItem;
import dev.aaronhowser.mods.irregular_implements.registry.ModEntityTypes;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 (2\u00020\u0001:\u0001(B\u001b\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B1\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u0006\u0010\u000eJ\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0002J\b\u0010\u001d\u001a\u00020\u001bH\u0002J\b\u0010\u001e\u001a\u00020\u001bH\u0002J\b\u0010\u001f\u001a\u00020\u001bH\u0002J\b\u0010 \u001a\u00020\u001bH\u0002J\b\u0010\u0018\u001a\u00020\u001bH\u0002J\u0010\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020#H\u0014J\u0010\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020&H\u0014J\u0010\u0010'\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020&H\u0014R$\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00108F@BX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R$\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006)"}, d2={"Ldev/aaronhowser/mods/irregular_implements/entity/WeatherCloudEntity;", "Lnet/minecraft/world/entity/Entity;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "x", "", "y", "z", "weather", "Ldev/aaronhowser/mods/irregular_implements/item/WeatherEggItem$Weather;", "(Lnet/minecraft/world/level/Level;DDDLdev/aaronhowser/mods/irregular_implements/item/WeatherEggItem$Weather;)V", "value", "", "age", "getAge", "()I", "setAge", "(I)V", "getWeather", "()Ldev/aaronhowser/mods/irregular_implements/item/WeatherEggItem$Weather;", "setWeather", "(Ldev/aaronhowser/mods/irregular_implements/item/WeatherEggItem$Weather;)V", "tick", "", "spawnParticles", "spawnDefaultCloud", "spawnRainyCloud", "spawnStormyCloud", "spawnNiceCloud", "defineSynchedData", "builder", "Lnet/minecraft/network/syncher/SynchedEntityData$Builder;", "readAdditionalSaveData", "compound", "Lnet/minecraft/nbt/CompoundTag;", "addAdditionalSaveData", "Companion", "irregular-implements-1.21.1"})
public final class WeatherCloudEntity
extends Entity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final EntityDataAccessor<Integer> AGE;
    @NotNull
    private static final EntityDataAccessor<Integer> WEATHER_TYPE;
    @NotNull
    public static final String AGE_NBT = "Age";
    @NotNull
    public static final String WEATHER_NBT = "Weather";

    public WeatherCloudEntity(@NotNull EntityType<?> entityType, @NotNull Level level) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super(entityType, level);
        this.noPhysics = true;
    }

    public WeatherCloudEntity(@NotNull Level level, double x, double y, double z, @NotNull WeatherEggItem.Weather weather) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)((Object)weather), (String)"weather");
        Object object = ModEntityTypes.INSTANCE.getWEATHER_CLOUD().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        this((EntityType)object, level);
        this.setPos(x, y, z);
        this.setWeather(weather);
    }

    public final int getAge() {
        Object object = this.entityData.get(AGE);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return ((Number)object).intValue();
    }

    private final void setAge(int value) {
        this.entityData.set(AGE, (Object)value);
    }

    @NotNull
    public final WeatherEggItem.Weather getWeather() {
        EnumEntries<WeatherEggItem.Weather> enumEntries = WeatherEggItem.Weather.getEntries();
        Object object = this.entityData.get(WEATHER_TYPE);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (WeatherEggItem.Weather)((Object)enumEntries.get(((Number)object).intValue()));
    }

    public final void setWeather(@NotNull WeatherEggItem.Weather value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.entityData.set(WEATHER_TYPE, (Object)value.ordinal());
    }

    public void tick() {
        super.tick();
        if (this.getAge() < 200) {
            this.setDeltaMovement(new Vec3(0.0, 0.007, 0.0));
        } else {
            Vec3 dm = this.getDeltaMovement();
            double dy = dm.y + 0.001;
            this.setDeltaMovement(new Vec3(dm.x, dy *= 1.02, dm.z));
            if (this.position().y >= (double)this.level().getMaxBuildHeight()) {
                this.setWeather();
                this.discard();
                return;
            }
        }
        int n = this.getAge();
        this.setAge(n + 1);
        this.move(MoverType.SELF, this.getDeltaMovement());
        if (this.level().isClientSide) {
            this.spawnParticles();
        }
    }

    private final void spawnParticles() {
        if (!AaronExtensions.INSTANCE.isClientSide((Entity)this)) {
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.getWeather().ordinal()]) {
            case 1: {
                this.spawnNiceCloud();
                break;
            }
            case 2: {
                this.spawnRainyCloud();
                break;
            }
            case 3: {
                this.spawnStormyCloud();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final void spawnDefaultCloud() {
        for (int y = -1; y < 2; ++y) {
            for (double t = 0.0; t < Math.PI * 2; t += 0.6283185307179586) {
                double yDouble = y;
                double a = 0.25;
                double b = 0.35;
                double divisor = Math.abs(yDouble) * 0.5 + 1.0;
                double elX = (a /= divisor) * Math.cos(t);
                double elZ = (b /= divisor) * Math.sin(t);
                this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, true, this.getX() + elX, this.getY() + yDouble / 8.0, this.getZ() + elZ, 0.0, -0.03, 0.0);
            }
        }
    }

    private final void spawnRainyCloud() {
        this.spawnDefaultCloud();
        for (int i = 0; i < 2; ++i) {
            double t = Math.PI * 2 * this.random.nextDouble();
            double a = 0.25;
            double b = 0.35;
            double elX = (a /= 1.5 + this.random.nextDouble()) * Math.cos(t);
            double elZ = (b /= 1.5 + this.random.nextDouble()) * Math.sin(t);
            this.level().addParticle((ParticleOptions)ParticleTypes.FISHING, true, this.getX() + elX, this.getY() - 0.2, this.getZ() + elZ, 0.0, -0.05, 0.0);
        }
    }

    private final void spawnStormyCloud() {
        this.spawnDefaultCloud();
        double t = Math.PI * 2 * this.random.nextDouble();
        double a = 0.25;
        double b = 0.35;
        double elX = (a /= 1.5 + this.random.nextDouble()) * Math.cos(t);
        double elZ = (b /= 1.5 + this.random.nextDouble()) * Math.sin(t);
        this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, true, this.getX() + elX, this.getY(), this.getZ() + elZ, this.random.nextDouble() * 0.1 - 0.05, this.random.nextDouble() * 0.2 - 0.1, this.random.nextDouble() * 0.1 - 0.05);
    }

    private final void spawnNiceCloud() {
        Level level = this.level();
        Intrinsics.checkNotNull((Object)level);
        if (AaronExtensions.INSTANCE.isServerSide(level)) {
            return;
        }
        for (int y = -1; y < 2; ++y) {
            double t = 0.0;
            while (t < Math.PI * 2) {
                double a = 0.25;
                double b = 0.35;
                double elX = (a /= (double)Math.abs(y) * 0.5 + 1.0) * Math.cos(t += 1.0471975511965976);
                double elZ = (b /= (double)Math.abs(y) * 0.5 + 1.0) * Math.sin(t);
                int shade = (int)((double)255 - ((double)level.random.nextFloat() * 0.5 - 0.025));
                int color = FastColor.ARGB32.color((int)255, (int)shade, (int)shade, (int)shade);
                level.addParticle((ParticleOptions)new DustParticleOptions(Vec3.fromRGB24((int)color).toVector3f(), 1.0f), true, this.getX() + elX, this.getY() + (double)((float)y / (float)8), this.getZ() + elZ, 0.0, 0.0, 0.0);
            }
        }
    }

    private final void setWeather() {
        int duration = (300 + this.random.nextInt(600)) * 20;
        Level level = this.level();
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            return;
        }
        ServerLevel level2 = serverLevel;
        switch (WhenMappings.$EnumSwitchMapping$0[this.getWeather().ordinal()]) {
            case 1: {
                level2.setWeatherParameters(duration, 0, false, false);
                break;
            }
            case 2: {
                level2.setWeatherParameters(0, duration, true, false);
                break;
            }
            case 3: {
                level2.setWeatherParameters(0, duration, true, true);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.define(AGE, (Object)0).define(WEATHER_TYPE, (Object)WeatherEggItem.Weather.SUNNY.ordinal());
    }

    protected void readAdditionalSaveData(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        this.setAge(compound.getInt(AGE_NBT));
        this.setWeather((WeatherEggItem.Weather)((Object)WeatherEggItem.Weather.getEntries().get(compound.getInt(WEATHER_NBT))));
    }

    protected void addAdditionalSaveData(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        compound.putInt(AGE_NBT, this.getAge());
        compound.putInt(WEATHER_NBT, this.getWeather().ordinal());
    }

    static {
        EntityDataAccessor entityDataAccessor = SynchedEntityData.defineId(WeatherCloudEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor, (String)"defineId(...)");
        AGE = entityDataAccessor;
        EntityDataAccessor entityDataAccessor2 = SynchedEntityData.defineId(WeatherCloudEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor2, (String)"defineId(...)");
        WEATHER_TYPE = entityDataAccessor2;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ldev/aaronhowser/mods/irregular_implements/entity/WeatherCloudEntity$Companion;", "", "<init>", "()V", "AGE", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "", "getAGE", "()Lnet/minecraft/network/syncher/EntityDataAccessor;", "WEATHER_TYPE", "getWEATHER_TYPE", "AGE_NBT", "", "WEATHER_NBT", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EntityDataAccessor<Integer> getAGE() {
            return AGE;
        }

        @NotNull
        public final EntityDataAccessor<Integer> getWEATHER_TYPE() {
            return WEATHER_TYPE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WeatherEggItem.Weather.values().length];
            try {
                nArray[WeatherEggItem.Weather.SUNNY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WeatherEggItem.Weather.RAINY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WeatherEggItem.Weather.STORMY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

