/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.client;

import dev.aaronhowser.mods.aaron.client.AaronClientUtil;
import dev.aaronhowser.mods.irregular_implements.handler.SpectreIlluminationHandler;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\bR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ldev/aaronhowser/mods/irregular_implements/client/ClientSpectreIllumination;", "", "<init>", "()V", "illuminatedChunks", "", "", "isChunkIlluminated", "", "blockPos", "Lnet/minecraft/core/BlockPos;", "chunkPos", "Lnet/minecraft/world/level/ChunkPos;", "setChunkIlluminated", "", "newValue", "irregular-implements-1.21.1"})
public final class ClientSpectreIllumination {
    @NotNull
    public static final ClientSpectreIllumination INSTANCE = new ClientSpectreIllumination();
    @NotNull
    private static final Set<Long> illuminatedChunks = new LinkedHashSet();

    private ClientSpectreIllumination() {
    }

    @JvmStatic
    public static final boolean isChunkIlluminated(@NotNull BlockPos blockPos) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        long chunkPosLong = ChunkPos.asLong((BlockPos)blockPos);
        return illuminatedChunks.contains(chunkPosLong);
    }

    public final boolean isChunkIlluminated(@NotNull ChunkPos chunkPos) {
        Intrinsics.checkNotNullParameter((Object)chunkPos, (String)"chunkPos");
        long chunkPosLong = chunkPos.toLong();
        return illuminatedChunks.contains(chunkPosLong);
    }

    public final void setChunkIlluminated(@NotNull ChunkPos chunkPos, boolean newValue) {
        Intrinsics.checkNotNullParameter((Object)chunkPos, (String)"chunkPos");
        boolean oldValue = this.isChunkIlluminated(chunkPos);
        if (oldValue == newValue) {
            return;
        }
        long chunkPosLong = chunkPos.toLong();
        boolean bl = newValue ? illuminatedChunks.add(chunkPosLong) : illuminatedChunks.remove(chunkPosLong);
        Level level = AaronClientUtil.getLocalLevel();
        if (level != null) {
            SpectreIlluminationHandler.Companion.forceLightUpdates(level, chunkPos);
        }
    }
}

