/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.block.block_entity;

import dev.aaronhowser.mods.irregular_implements.block.block_entity.base.ImprovedSimpleContainer;
import dev.aaronhowser.mods.irregular_implements.menu.imbuing_station.ImbuingStationMenu;
import dev.aaronhowser.mods.irregular_implements.recipe.machine.ImbuingInput;
import dev.aaronhowser.mods.irregular_implements.recipe.machine.ImbuingRecipe;
import dev.aaronhowser.mods.irregular_implements.registry.ModBlockEntityTypes;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.items.wrapper.RangedWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 ,2\u00020\u00012\u00020\u0002:\u0001,B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\b\u0010\u001f\u001a\u00020\nH\u0002J\b\u0010 \u001a\u00020\nH\u0002J\b\u0010!\u001a\u00020\"H\u0002J \u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020+H\u0016R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u001b@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u001d\u0010\u001e\u00a8\u0006-"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/block_entity/ImbuingStationBlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "Lnet/minecraft/world/MenuProvider;", "pPos", "Lnet/minecraft/core/BlockPos;", "pBlockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "saveAdditional", "", "tag", "Lnet/minecraft/nbt/CompoundTag;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "loadAdditional", "container", "Ldev/aaronhowser/mods/irregular_implements/block/block_entity/base/ImprovedSimpleContainer;", "getContainer", "()Ldev/aaronhowser/mods/irregular_implements/block/block_entity/base/ImprovedSimpleContainer;", "invWrapper", "Lnet/neoforged/neoforge/items/wrapper/InvWrapper;", "getItemHandler", "Lnet/neoforged/neoforge/items/IItemHandler;", "direction", "Lnet/minecraft/core/Direction;", "value", "", "progress", "setProgress", "(I)V", "tick", "craftItem", "hasRecipe", "", "createMenu", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "containerId", "playerInventory", "Lnet/minecraft/world/entity/player/Inventory;", "player", "Lnet/minecraft/world/entity/player/Player;", "getDisplayName", "Lnet/minecraft/network/chat/Component;", "Companion", "irregular-implements-1.21.1"})
public final class ImbuingStationBlockEntity
extends BlockEntity
implements MenuProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ImprovedSimpleContainer container;
    @NotNull
    private final InvWrapper invWrapper;
    private int progress;
    public static final int CONTAINER_SIZE = 5;
    public static final int TOP_SLOT_INDEX = 0;
    public static final int LEFT_SLOT_INDEX = 1;
    public static final int BOTTOM_SLOT_INDEX = 2;
    public static final int CENTER_SLOT_INDEX = 3;
    public static final int OUTPUT_SLOT_INDEX = 4;
    private static final int MIN_OUTER_INDEX = Math.min(0, Math.min(1, 2));
    private static final int MAX_OUTER_INDEX = Math.max(0, Math.max(1, 2));
    @NotNull
    public static final String CRAFT_PROGRESS_NBT = "CraftProgress";
    public static final int MAX_PROGRESS = 200;

    public ImbuingStationBlockEntity(@NotNull BlockPos pPos, @NotNull BlockState pBlockState) {
        Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
        Intrinsics.checkNotNullParameter((Object)pBlockState, (String)"pBlockState");
        super((BlockEntityType)ModBlockEntityTypes.INSTANCE.getIMBUING_STATION().get(), pPos, pBlockState);
        this.container = new ImprovedSimpleContainer(this, 5);
        this.invWrapper = new InvWrapper((Container)this.container);
    }

    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.saveAdditional(tag, registries);
        tag.putInt(CRAFT_PROGRESS_NBT, this.progress);
        ContainerHelper.saveAllItems((CompoundTag)tag, (NonNullList)this.container.getItems(), (HolderLookup.Provider)registries);
    }

    protected void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.loadAdditional(tag, registries);
        this.setProgress(tag.getInt(CRAFT_PROGRESS_NBT));
        ContainerHelper.loadAllItems((CompoundTag)tag, (NonNullList)this.container.getItems(), (HolderLookup.Provider)registries);
    }

    @NotNull
    public final ImprovedSimpleContainer getContainer() {
        return this.container;
    }

    @Nullable
    public final IItemHandler getItemHandler(@Nullable Direction direction) {
        Direction direction2 = direction;
        return switch (direction2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction2.ordinal()]) {
            case 1 -> (IItemHandler)new RangedWrapper((IItemHandlerModifiable)this.invWrapper, 3, 4);
            case -1, 2 -> (IItemHandler)new RangedWrapper((IItemHandlerModifiable)this.invWrapper, 4, 5);
            default -> (IItemHandler)new RangedWrapper((IItemHandlerModifiable)this.invWrapper, MIN_OUTER_INDEX, MAX_OUTER_INDEX + 1);
        };
    }

    private final void setProgress(int value) {
        if (this.progress == value) {
            return;
        }
        this.progress = value;
        this.setChanged();
    }

    private final void tick() {
        if (!this.hasRecipe()) {
            this.setProgress(0);
            return;
        }
        int n = this.progress;
        this.setProgress(n + 1);
        if (this.progress >= 200) {
            this.setProgress(0);
            this.craftItem();
        }
    }

    private final void craftItem() {
        ItemStack topStack = this.container.getItem(0);
        ItemStack leftStack = this.container.getItem(1);
        ItemStack bottomStack = this.container.getItem(2);
        ItemStack centerStack = this.container.getItem(3);
        Object[] objectArray = new ItemStack[]{topStack, leftStack, bottomStack};
        List outerStacks = CollectionsKt.listOf((Object[])objectArray);
        Intrinsics.checkNotNull((Object)centerStack);
        ImbuingInput imbuingInput = new ImbuingInput(outerStacks, centerStack);
        Level level = this.level;
        Intrinsics.checkNotNull((Object)level);
        ImbuingRecipe imbuingRecipe = ImbuingRecipe.Companion.getRecipe(level, imbuingInput);
        if (imbuingRecipe == null) {
            return;
        }
        ImbuingRecipe imbuingRecipe2 = imbuingRecipe;
        Level level2 = this.level;
        Intrinsics.checkNotNull((Object)level2);
        RegistryAccess registryAccess = level2.registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        ItemStack outputStack = imbuingRecipe2.assemble(imbuingInput, (HolderLookup.Provider)registryAccess);
        ItemStack stackInOutput = this.container.getItem(4);
        if (stackInOutput.isEmpty()) {
            this.container.setItem(4, outputStack);
        } else {
            stackInOutput.grow(outputStack.getCount());
        }
        this.container.removeItem(0, 1);
        this.container.removeItem(1, 1);
        this.container.removeItem(2, 1);
        this.container.removeItem(3, 1);
        this.setProgress(0);
    }

    private final boolean hasRecipe() {
        ItemStack topStack = this.container.getItem(0);
        ItemStack leftStack = this.container.getItem(1);
        ItemStack bottomStack = this.container.getItem(2);
        ItemStack centerStack = this.container.getItem(3);
        Object[] objectArray = new ItemStack[]{topStack, leftStack, bottomStack};
        List outerStacks = CollectionsKt.listOf((Object[])objectArray);
        Intrinsics.checkNotNull((Object)centerStack);
        ImbuingInput imbuingInput = new ImbuingInput(outerStacks, centerStack);
        Level level = this.level;
        Intrinsics.checkNotNull((Object)level);
        ImbuingRecipe imbuingRecipe = ImbuingRecipe.Companion.getRecipe(level, imbuingInput);
        if (imbuingRecipe == null) {
            return false;
        }
        ImbuingRecipe recipe = imbuingRecipe;
        ItemStack stackInOutput = this.container.getItem(4);
        if (stackInOutput.isEmpty()) {
            return true;
        }
        Level level2 = this.level;
        Intrinsics.checkNotNull((Object)level2);
        RegistryAccess registryAccess = level2.registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        ItemStack recipeOutput = recipe.getResultItem((HolderLookup.Provider)registryAccess);
        boolean outputCanFit = ItemStack.isSameItemSameComponents((ItemStack)recipeOutput, (ItemStack)stackInOutput) && stackInOutput.getCount() + recipeOutput.getCount() <= stackInOutput.getMaxStackSize();
        return outputCanFit;
    }

    @NotNull
    public AbstractContainerMenu createMenu(int containerId, @NotNull Inventory playerInventory, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return (AbstractContainerMenu)new ImbuingStationMenu(containerId, playerInventory, (Container)this.container);
    }

    @NotNull
    public Component getDisplayName() {
        MutableComponent mutableComponent = this.getBlockState().getBlock().getName();
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"getName(...)");
        return (Component)mutableComponent;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u001c2\b\u0010 \u001a\u0004\u0018\u00010!R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u000e\u0010\u0010\u001a\u00020\u0011X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/block_entity/ImbuingStationBlockEntity$Companion;", "", "<init>", "()V", "CONTAINER_SIZE", "", "TOP_SLOT_INDEX", "LEFT_SLOT_INDEX", "BOTTOM_SLOT_INDEX", "CENTER_SLOT_INDEX", "OUTPUT_SLOT_INDEX", "MIN_OUTER_INDEX", "getMIN_OUTER_INDEX", "()I", "MAX_OUTER_INDEX", "getMAX_OUTER_INDEX", "CRAFT_PROGRESS_NBT", "", "MAX_PROGRESS", "tick", "", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "blockEntity", "Ldev/aaronhowser/mods/irregular_implements/block/block_entity/ImbuingStationBlockEntity;", "getItemCapability", "Lnet/neoforged/neoforge/items/IItemHandler;", "imbuingStation", "direction", "Lnet/minecraft/core/Direction;", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        public final int getMIN_OUTER_INDEX() {
            return MIN_OUTER_INDEX;
        }

        public final int getMAX_OUTER_INDEX() {
            return MAX_OUTER_INDEX;
        }

        public final void tick(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ImbuingStationBlockEntity blockEntity) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
            blockEntity.tick();
        }

        @Nullable
        public final IItemHandler getItemCapability(@NotNull ImbuingStationBlockEntity imbuingStation, @Nullable Direction direction) {
            Intrinsics.checkNotNullParameter((Object)((Object)imbuingStation), (String)"imbuingStation");
            return imbuingStation.getItemHandler(direction);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.UP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.DOWN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

