/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsjewelry.network.packets;

import io.redspace.ironsjewelry.IronsJewelry;
import io.redspace.ironsjewelry.core.data.PlayerData;
import io.redspace.ironsjewelry.registry.DataAttachmentRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SyncPlayerDataPacket(PlayerData playerData) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncPlayerDataPacket> TYPE = new CustomPacketPayload.Type(IronsJewelry.id("clientbound_sync_player_data"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncPlayerDataPacket> STREAM_CODEC = CustomPacketPayload.codec(SyncPlayerDataPacket::write, SyncPlayerDataPacket::new);

    public SyncPlayerDataPacket(RegistryFriendlyByteBuf registryFriendlyByteBuf) {
        this(PlayerData.Serializer.networkRead(registryFriendlyByteBuf));
    }

    private void write(RegistryFriendlyByteBuf registryFriendlyByteBuf) {
        PlayerData.Serializer.networkWrite(registryFriendlyByteBuf, this.playerData);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(SyncPlayerDataPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            if (Minecraft.getInstance().player != null) {
                Minecraft.getInstance().player.setData(DataAttachmentRegistry.PLAYER_DATA, (Object)packet.playerData);
            }
        });
    }
}

