/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsjewelry.command;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import io.redspace.ironsjewelry.IronsJewelry;
import io.redspace.ironsjewelry.core.actions.ApplyDamageAction;
import io.redspace.ironsjewelry.core.actions.ApplyEffectAction;
import io.redspace.ironsjewelry.core.actions.CreateItemsAction;
import io.redspace.ironsjewelry.core.actions.ExplodeAction;
import io.redspace.ironsjewelry.core.actions.HealAction;
import io.redspace.ironsjewelry.core.actions.IAction;
import io.redspace.ironsjewelry.core.data.AttributeInstance;
import io.redspace.ironsjewelry.core.data.BonusInstance;
import io.redspace.ironsjewelry.core.data.MaterialDefinition;
import io.redspace.ironsjewelry.core.data.PartDefinition;
import io.redspace.ironsjewelry.core.data.PartIngredient;
import io.redspace.ironsjewelry.core.data.PatternDefinition;
import io.redspace.ironsjewelry.core.parameters.ActionParameter;
import io.redspace.ironsjewelry.core.parameters.IBonusParameterType;
import io.redspace.ironsjewelry.item.PatternRecipeItem;
import io.redspace.ironsjewelry.registry.AssetHandlerRegistry;
import io.redspace.ironsjewelry.registry.IronsJewelryRegistries;
import io.redspace.ironsjewelry.registry.ItemRegistry;
import io.redspace.ironsjewelry.registry.ParameterTypeRegistry;
import io.redspace.ironsjewelry.utils.Utils;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.IntUnaryOperator;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.atlas.sources.PalettedPermutations;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.TagKey;
import net.minecraft.util.FastColor;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class GenerateSiteData {
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.irons_spellbooks.generate_recipe_data.failed"));
    private static final String RECIPE_DATA_TEMPLATE = "- id: \"%s\"\n  name: \"%s\"\n  path: \"%s\"\n  group: \"%s\"\n  craftingType: \"%s\"\n  item0Id: \"%s\"\n  item0: \"%s\"\n  item0Path: \"%s\"\n  item1Id: \"%s\"\n  item1: \"%s\"\n  item1Path: \"%s\"\n  item2Id: \"%s\"\n  item2: \"%s\"\n  item2Path: \"%s\"\n  item3Id: \"%s\"\n  item3: \"%s\"\n  item3Path: \"%s\"\n  item4Id: \"%s\"\n  item4: \"%s\"\n  item4Path: \"%s\"\n  item5Id: \"%s\"\n  item5: \"%s\"\n  item5Path: \"%s\"\n  item6Id: \"%s\"\n  item6: \"%s\"\n  item6Path: \"%s\"\n  item7Id: \"%s\"\n  item7: \"%s\"\n  item7Path: \"%s\"\n  item8Id: \"%s\"\n  item8: \"%s\"\n  item8Path: \"%s\"\n  tooltip: \"%s\"\n  description: \"\"\n\n";
    private static final String PATTERN_DATA_TEMPLATE = "- name: \"%s\"\n  icon: \"/img/patterns/%s.png\"\n  locked: \"%s\"\n  part_for_quality: \"%s\"\n  quality: %s\n  part1: \"%s\"\n  part2: \"%s\"\n  part3: \"%s\"\n  part4: \"%s\"\n  bonus1: \"%s\"\n  bonus2: \"%s\"\n  bonus3: \"%s\"\n  bonus4: \"%s\"\n\n";
    private static final String MATERIAL_DATA_TEMPLATE = "- name: \"%s\"\n  icon: \"/img/materials/%s.png\"\n  source: \"%s\"\n  quality: %s\n  types: \"%s\"\n  bonus_types: \"%s\"\n  bonus_values: \"%s\"\n  sort: \"%s\"\n\n";
    static ServerLevel level;

    protected static int generateSiteData(CommandSourceStack source) {
        GenerateSiteData.generateRecipeData(source);
        GenerateSiteData.generatePatternData(source);
        GenerateSiteData.generateMaterialData(source);
        return 1;
    }

    public static List<Item> getVisibleItems() {
        return BuiltInRegistries.ITEM.stream().filter(item -> CreativeModeTabs.allTabs().stream().anyMatch(tab -> tab.contains(new ItemStack((ItemLike)item)))).toList();
    }

    private static void generateRecipeData(CommandSourceStack source) {
        try {
            StringBuilder itemBuilder = new StringBuilder();
            StringBuilder armorBuilder = new StringBuilder();
            StringBuilder spellbookBuilder = new StringBuilder();
            StringBuilder curioBuilder = new StringBuilder();
            StringBuilder blockBuilder = new StringBuilder();
            level = source.getLevel();
            HashSet<Item> itemsTracked = new HashSet<Item>();
            GenerateSiteData.handleArtisanScrollEntry(itemBuilder, itemsTracked, source);
            GenerateSiteData.getVisibleItems().stream().sorted(Comparator.comparing(Item::getDescriptionId)).forEach(item -> {
                ResourceLocation itemResource = BuiltInRegistries.ITEM.getKey(item);
                String tooltip = GenerateSiteData.getTooltip(source.getPlayer(), new ItemStack((ItemLike)item));
                if (itemResource.getNamespace().equals("irons_jewelry") && !itemsTracked.contains(item)) {
                    Recipe recipe = GenerateSiteData.getRecipeFor(source, item);
                    String name = item.getName(ItemStack.EMPTY).getString();
                    if (recipe != null) {
                        GenerateSiteData.appendToBuilder(itemBuilder, recipe, GenerateSiteData.getRecipeData(recipe), GenerateSiteData.handleGenericItemGrouping(item), tooltip);
                    } else {
                        GenerateSiteData.appendToBuilder3(itemBuilder, name, itemResource, GenerateSiteData.handleGenericItemGrouping(item), tooltip);
                    }
                    itemsTracked.add((Item)item);
                }
            });
            BufferedWriter file = new BufferedWriter(new FileWriter("site_data/item_data.yml"));
            file.write(GenerateSiteData.postProcess(itemBuilder));
            file.close();
        }
        catch (Exception e) {
            IronsJewelry.LOGGER.debug(e.getMessage());
        }
    }

    private static String handleGenericItemGrouping(Item item) {
        if (item instanceof BlockItem) {
            return "Blocks";
        }
        if (new ItemStack((ItemLike)item).is(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)"c:gems")))) {
            return "Gems";
        }
        return "All";
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    @NotNull
    private static ArrayList<RecipeIngredientData> getRecipeData(Recipe<?> recipe) {
        ResourceLocation resultItemResourceLocation = BuiltInRegistries.ITEM.getKey((Object)recipe.getResultItem((HolderLookup.Provider)level.registryAccess()).getItem());
        ArrayList<RecipeIngredientData> recipeData = new ArrayList<RecipeIngredientData>(10);
        recipeData.add(new RecipeIngredientData(resultItemResourceLocation.toString(), recipe.getResultItem((HolderLookup.Provider)level.registryAccess()).getItem().getName(ItemStack.EMPTY).getString(), String.format("/img/items/%s.png", resultItemResourceLocation.getPath()), recipe.getResultItem((HolderLookup.Provider)level.registryAccess()).getItem()));
        if (recipe instanceof ShapedRecipe) {
            ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
            if (shapedRecipe.pattern.width() < 3) {
                NonNullList ingredients = recipe.getIngredients();
                int i = 0;
                while (i < ingredients.size()) {
                    GenerateSiteData.handleIngredient((Ingredient)ingredients.get(i), recipeData, recipe);
                    if ((i + 1) % shapedRecipe.pattern.width() == 0) {
                        recipeData.add(RecipeIngredientData.EMPTY);
                    }
                    ++i;
                }
                return recipeData;
            }
        }
        recipe.getIngredients().forEach(ingredient -> GenerateSiteData.handleIngredient(ingredient, recipeData, recipe));
        return recipeData;
    }

    @Nullable
    private static Recipe getRecipeFor(CommandSourceStack sourceStack, Item item) {
        for (RecipeHolder recipe : sourceStack.getRecipeManager().getRecipes()) {
            if (!recipe.value().getResultItem((HolderLookup.Provider)level.registryAccess()).is(item)) continue;
            return recipe.value();
        }
        return null;
    }

    private static void handleArtisanScrollEntry(StringBuilder curioBuilder, Set<Item> itemsTracked, CommandSourceStack source) {
        PatternRecipeItem item = (PatternRecipeItem)((Object)ItemRegistry.RECIPE.get());
        itemsTracked.add(item);
        ResourceLocation itemResource = BuiltInRegistries.ITEM.getKey((Object)item);
        String name = item.getName(ItemStack.EMPTY).getString();
        GenerateSiteData.appendToBuilder3(curioBuilder, name, itemResource, "All", "Artisan Scrolls can be found, looted, or traded for, and can be consumed to learn a new jewelry pattern.");
    }

    private static String postProcess(StringBuilder sb) {
        return sb.toString();
    }

    private static String getTooltip(ServerPlayer player, ItemStack itemStack) {
        return Arrays.stream(itemStack.getTooltipLines(Item.TooltipContext.EMPTY, (Player)player, (TooltipFlag)TooltipFlag.Default.NORMAL).stream().skip(1L).map(Component::getString).filter(x -> x.trim().length() > 0).collect(Collectors.joining(", ")).replace(":,", ": ").replace("  ", " ").split(",")).filter(item -> !item.contains("Slot")).collect(Collectors.joining(",")).trim().replace(":", ":<br>");
    }

    private static void appendToBuilder(StringBuilder sb, Recipe recipe, List<RecipeIngredientData> recipeIngredientData, String group, String tooltip) {
        sb.append(String.format(RECIPE_DATA_TEMPLATE, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)0).id, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)0).name, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)0).path, group, recipe.getType(), GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)1).id, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)1).name, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)1).path, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)2).id, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)2).name, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)2).path, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)3).id, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)3).name, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)3).path, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)4).id, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)4).name, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)4).path, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)5).id, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)5).name, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)5).path, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)6).id, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)6).name, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)6).path, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)7).id, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)7).name, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)7).path, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)8).id, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)8).name, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)8).path, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)9).id, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)9).name, GenerateSiteData.getRecipeDataAtIndex(recipeIngredientData, (int)9).path, tooltip));
    }

    private static void appendToBuilder2(StringBuilder sb, String name, ResourceLocation itemResource, String tooltip) {
        sb.append(String.format(RECIPE_DATA_TEMPLATE, itemResource.toString(), name, String.format("/img/items/%s.png", itemResource.getPath()), "", "none", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", tooltip));
    }

    private static void appendToBuilder3(StringBuilder sb, String name, ResourceLocation itemResource, String group, String tooltip) {
        sb.append(String.format(RECIPE_DATA_TEMPLATE, itemResource.toString(), name, String.format("/img/items/%s.png", itemResource.getPath()), group, "none", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", tooltip));
    }

    private static void handleIngredient(Ingredient ingredient, ArrayList<RecipeIngredientData> recipeData, Recipe recipe) {
        Arrays.stream(ingredient.getItems()).findFirst().ifPresentOrElse(itemStack -> {
            ResourceLocation itemResource = BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem());
            String path = "";
            path = itemResource.toString().contains("irons_jewelry") ? String.format("/img/items/%s.png", itemResource.getPath()) : String.format("/img/items/minecraft/%s.png", itemResource.getPath());
            recipeData.add(new RecipeIngredientData(itemResource.toString(), itemStack.getItem().getName(ItemStack.EMPTY).getString(), path, recipe.getResultItem((HolderLookup.Provider)level.registryAccess()).getItem()));
        }, () -> recipeData.add(RecipeIngredientData.EMPTY));
    }

    private static RecipeIngredientData getRecipeDataAtIndex(List<RecipeIngredientData> recipeIngredientData, int index) {
        if (index < recipeIngredientData.size()) {
            return recipeIngredientData.get(index);
        }
        return RecipeIngredientData.EMPTY;
    }

    private static String rasterizeTranslation(String descriptionId) {
        return GenerateSiteData.handleCapitalization(Component.translatable((String)descriptionId).getString());
    }

    private static String listListElements(List<?> list) {
        StringBuilder builder = new StringBuilder();
        list.forEach(obj -> builder.append(obj.toString()).append(", "));
        return builder.substring(0, builder.length() - 2);
    }

    private static String handleMaterialBonusDescription(IBonusParameterType<?> type, Object value) {
        if (type.equals(ParameterTypeRegistry.ACTION_PARAMETER.get())) {
            ActionParameter.ActionRunnable action = (ActionParameter.ActionRunnable)value;
            ResourceLocation resource = IronsJewelryRegistries.ACTION_REGISTRY.getKey(action.action().codec());
            return Component.translatable((String)String.format("action.%s.%s.name", resource.getNamespace(), resource.getPath())).getString() + GenerateSiteData.handleExtraActionInformation(action);
        }
        if (type.equals(ParameterTypeRegistry.POSITIVE_EFFECT_PARAMETER.get())) {
            return Component.translatable((String)((MobEffect)((Holder)value).value()).getDescriptionId()).getString();
        }
        if (type.equals(ParameterTypeRegistry.NEGATIVE_EFFECT_PARAMETER.get())) {
            return Component.translatable((String)((MobEffect)((Holder)value).value()).getDescriptionId()).getString();
        }
        if (type.equals(ParameterTypeRegistry.ATTRIBUTE_PARAMETER.get())) {
            AttributeInstance attribute = (AttributeInstance)value;
            return GenerateSiteData.createAttributeModifierText(attribute.attribute(), new AttributeModifier(IronsJewelry.id("noop"), attribute.amount(), attribute.operation()));
        }
        return "";
    }

    private static String handleExtraActionInformation(ActionParameter.ActionRunnable action) {
        IAction location;
        IAction iAction = action.action();
        if (iAction instanceof ApplyDamageAction) {
            ApplyDamageAction damageAction = (ApplyDamageAction)iAction;
            location = damageAction.damageType().getKey().location();
            MutableComponent typeComponent = Component.translatable((String)String.format("damage_type.%s.%s", location.getNamespace(), location.getPath()));
            return String.format(" (%s %s Damage)", Float.valueOf(damageAction.getDamage(1.0)), typeComponent.getString());
        }
        location = action.action();
        if (location instanceof ApplyEffectAction) {
            ApplyEffectAction effectAction = (ApplyEffectAction)location;
            String[] amp = new String[]{"I", "II", "III", "IV", "V"};
            if (((MobEffect)effectAction.effect().value()).isInstantenous()) {
                return String.format(" (%s %s)", Component.translatable((String)((MobEffect)effectAction.effect().value()).getDescriptionId()).getString(), amp[(int)effectAction.amplifier().sample(1.0)]);
            }
            return String.format(" (%s %s, %s)", Component.translatable((String)((MobEffect)effectAction.effect().value()).getDescriptionId()).getString(), amp[(int)effectAction.amplifier().sample(1.0)], Utils.digitalTimeFromTicks((int)effectAction.duration().sample(1.0), true));
        }
        iAction = action.action();
        if (iAction instanceof HealAction) {
            HealAction healAction = (HealAction)iAction;
            return String.format(" (%s Base Healing)", healAction.amount().sample(1.0));
        }
        iAction = action.action();
        if (iAction instanceof CreateItemsAction) {
            CreateItemsAction itemsAction = (CreateItemsAction)iAction;
            return String.format(" (%s)", itemsAction.formatTooltip(new BonusInstance(null, 1.0, null, null), false).getString());
        }
        iAction = action.action();
        if (iAction instanceof ExplodeAction) {
            ExplodeAction explodeAction = (ExplodeAction)iAction;
            return String.format(" (%s)", explodeAction.formatTooltip(new BonusInstance(null, 1.0, null, null), false).getString().replace(" (", ", ").replace(")", ""));
        }
        return "";
    }

    private static int sortIngredientStack(ItemStack a, ItemStack b) {
        return GenerateSiteData.prioritizeCompare(BuiltInRegistries.ITEM.getKey((Object)a.getItem()).getNamespace(), BuiltInRegistries.ITEM.getKey((Object)a.getItem()).getNamespace(), "irons_jewelry");
    }

    private static int prioritizeCompare(String a, String b, String priority) {
        if (a.equals(priority)) {
            return -1;
        }
        if (b.equals(priority)) {
            return 1;
        }
        return a.compareTo(b);
    }

    private static void generateMaterialData(CommandSourceStack source) {
        try {
            Registry<MaterialDefinition> registry = IronsJewelryRegistries.materialRegistry(source.registryAccess());
            StringBuilder sb = new StringBuilder();
            for (MaterialDefinition material : registry) {
                String name = GenerateSiteData.rasterizeTranslation(material.descriptionId());
                ResourceLocation id = registry.wrapAsHolder((Object)material).getKey().location();
                if (id.equals((Object)IronsJewelry.id("example"))) continue;
                if (material.ingredient().hasNoItems()) {
                    IronsJewelry.LOGGER.error("Cannot generate material {}, no valid ingredients present!", (Object)id);
                    continue;
                }
                ItemStack representativeStack = Arrays.stream(material.ingredient().getItems()).sorted(GenerateSiteData::sortIngredientStack).findFirst().get();
                ResourceLocation ingrId = BuiltInRegistries.ITEM.getKey((Object)representativeStack.getItem());
                String imgid = ingrId.getPath();
                int sortOrder = name.charAt(0);
                String modsource = "Vanilla";
                if (ingrId.getNamespace().equals("irons_jewelry")) {
                    modsource = "Gems 'n Jewelry";
                    sortOrder += 100;
                } else if (!ingrId.getNamespace().equals("minecraft")) {
                    modsource = "Requires Addon";
                    sortOrder += 1000;
                }
                double quality = material.quality();
                String types = material.materialType().stream().filter(string -> !id.toString().contains((CharSequence)string)).map(GenerateSiteData::handleCapitalization).collect(Collectors.joining(", "));
                String bonusTypes = material.bonusParameters().keySet().stream().map(param -> GenerateSiteData.handleCapitalization(IronsJewelryRegistries.PARAMETER_TYPE_REGISTRY.getKey(param).getPath().replace("_", " "))).collect(Collectors.joining(";"));
                String bonusValues = material.bonusParameters().entrySet().stream().map(entry -> GenerateSiteData.handleMaterialBonusDescription((IBonusParameterType)entry.getKey(), entry.getValue())).collect(Collectors.joining(";"));
                sb.append(String.format(MATERIAL_DATA_TEMPLATE, name, imgid, modsource, quality, types, bonusTypes, bonusValues, sortOrder));
                if (ingrId.getNamespace().equals("minecraft") || ingrId.getNamespace().equals("irons_jewelry") || !ingrId.getPath().contains("ingot")) continue;
                try {
                    Path filePath = Path.of("site_data/wiki_ingot_base.png", new String[0]);
                    if (Files.notExists(filePath, LinkOption.NOFOLLOW_LINKS)) {
                        throw new FileNotFoundException("No base ingot file");
                    }
                    NativeImage baseIngot = NativeImage.read((InputStream)Files.newInputStream(filePath, new OpenOption[0]));
                    NativeImage ingot = baseIngot.mappedCopy(GenerateSiteData.createPaletteMapping(PalettedPermutations.loadPaletteEntryFromImage((ResourceManager)Minecraft.getInstance().getResourceManager(), (ResourceLocation)IronsJewelry.id("palettes/gold")), PalettedPermutations.loadPaletteEntryFromImage((ResourceManager)Minecraft.getInstance().getResourceManager(), (ResourceLocation)material.paletteLocation())));
                    GenerateSiteData.exportNativeImage(ingot, "ingredient/" + ingrId.getPath());
                }
                catch (Exception exception) {
                    IronsJewelry.LOGGER.debug("Failed to make image file {}: {}", (Object)ingrId, (Object)exception.getMessage());
                }
            }
            BufferedWriter file = new BufferedWriter(new FileWriter("site_data/material_data.yml"));
            file.write(sb.toString());
            file.close();
        }
        catch (Exception e) {
            IronsJewelry.LOGGER.debug(e.getMessage());
        }
    }

    private static void generatePatternData(CommandSourceStack source) {
        try {
            Registry<PatternDefinition> registry = IronsJewelryRegistries.patternRegistry(source.registryAccess());
            StringBuilder sb = new StringBuilder();
            registry.stream().forEach(pattern -> {
                String name = GenerateSiteData.rasterizeTranslation(pattern.descriptionId());
                String imgid = registry.wrapAsHolder(pattern).getKey().location().getPath();
                String locked = pattern.unlockedByDefault() ? "Yes" : "No";
                String partForQuality = pattern.partForQuality().map(part -> GenerateSiteData.rasterizeTranslation(((PartDefinition)part.value()).descriptionId())).orElse("None");
                double quality = pattern.qualityMultiplier();
                List<String> parts = pattern.partTemplate().stream().map(part -> String.format("%s (%s - %s)", GenerateSiteData.rasterizeTranslation(((PartDefinition)part.part().value()).descriptionId()), part.materialCost(), GenerateSiteData.handleCapitalization(GenerateSiteData.listListElements(((PartDefinition)part.part().value()).allowedMaterials())))).toList();
                String part1 = parts.size() >= 1 ? parts.get(0) : "";
                String part2 = parts.size() >= 2 ? parts.get(1) : "";
                String part3 = parts.size() >= 3 ? parts.get(2) : "";
                String part4 = parts.size() >= 4 ? parts.get(3) : "";
                List<MutableComponent> bonuses = pattern.getPatternBonusesTooltip();
                if (!bonuses.isEmpty()) {
                    bonuses.removeFirst();
                }
                String bonus1 = bonuses.size() >= 1 ? bonuses.get(0).getString() : "";
                String bonus2 = bonuses.size() >= 2 ? bonuses.get(1).getString() : "";
                String bonus3 = bonuses.size() >= 3 ? bonuses.get(2).getString() : "";
                String bonus4 = bonuses.size() >= 4 ? bonuses.get(3).getString() : "";
                sb.append(String.format(PATTERN_DATA_TEMPLATE, name, imgid, locked, partForQuality, quality, part1, part2, part3, part4, bonus1, bonus2, bonus3, bonus4));
                GenerateSiteData.tryGeneratePatternImage(source, pattern, imgid);
            });
            BufferedWriter file = new BufferedWriter(new FileWriter("site_data/pattern_data.yml"));
            file.write(sb.toString());
            file.close();
        }
        catch (Exception e) {
            IronsJewelry.LOGGER.debug(e.getMessage());
        }
    }

    private static void tryGeneratePatternImage(CommandSourceStack source, PatternDefinition pattern, String imgid) {
        try {
            Registry<MaterialDefinition> materialRegistry = IronsJewelryRegistries.materialRegistry(source.registryAccess());
            Holder.Reference metal = (Holder.Reference)materialRegistry.getHolder(IronsJewelry.id("gold")).get();
            Holder.Reference gem = (Holder.Reference)materialRegistry.getHolder(IronsJewelry.id("ruby")).get();
            NativeImage image = new NativeImage(16, 16, false);
            pattern.partTemplate().stream().map(PartIngredient::part).forEach(part -> {
                Holder.Reference renderMaterial = null;
                if (((PartDefinition)part.value()).canUseMaterial("gem")) {
                    renderMaterial = gem;
                } else if (((PartDefinition)part.value()).canUseMaterial("metal")) {
                    renderMaterial = metal;
                } else {
                    for (MaterialDefinition materialDefinition : materialRegistry) {
                        if (!((PartDefinition)part.value()).canUseMaterial(materialDefinition.materialType())) continue;
                        renderMaterial = materialRegistry.wrapAsHolder((Object)materialDefinition);
                        break;
                    }
                    Objects.requireNonNull(renderMaterial);
                }
                TextureAtlasSprite sprite = AssetHandlerRegistry.JEWELRY_HANDLER.get().getSprite(AssetHandlerRegistry.JEWELRY_HANDLER.get().getSpriteLocation((Holder<PartDefinition>)part, (Holder<MaterialDefinition>)renderMaterial));
                NativeImage layer = sprite.contents().getOriginalImage();
                int[] pixels = layer.getPixelsRGBA();
                for (int x = 0; x < 16; ++x) {
                    for (int y = 0; y < 16; ++y) {
                        int i = y * 16 + x;
                        int rgba = pixels[i];
                        int alpha = rgba >> 24 & 0xFF;
                        if (alpha == 0) continue;
                        image.setPixelRGBA(x, y, rgba);
                    }
                }
            });
            GenerateSiteData.exportNativeImage(image, imgid);
        }
        catch (Exception e) {
            IronsJewelry.LOGGER.debug("Failed to make image file: {} {}", (Object)pattern.descriptionId(), (Object)e.getMessage());
        }
    }

    public static void exportNativeImage(NativeImage image, String name) throws IOException {
        Object fileName = name;
        if (!((String)fileName).endsWith(".png")) {
            fileName = (String)fileName + ".png";
        }
        Path filePath = Path.of("site_data/img", new String[0]).resolve((String)fileName);
        if (Files.notExists(filePath, LinkOption.NOFOLLOW_LINKS)) {
            Files.createFile(filePath, new FileAttribute[0]);
        }
        image.writeToFile(filePath);
    }

    private static List<String> processUniqueInfo(AbstractSpell spell) {
        ArrayList<String> text = new ArrayList<String>();
        List uniqueInfoMin = spell.getUniqueInfo(spell.getMinLevel(), null);
        List uniqueInfoMax = spell.getUniqueInfo(spell.getMaxLevel(), null);
        for (int i = 0; i < uniqueInfoMax.size(); ++i) {
            String[] splitMin = ((MutableComponent)uniqueInfoMin.get(i)).getString().split(" ");
            String[] splitMax = ((MutableComponent)uniqueInfoMax.get(i)).getString().split(" ");
            int k = -1;
            for (int j = 0; j < splitMin.length; ++j) {
                if (!splitMin[j].matches("\\d\\.?\\d*(s|m|%)*")) continue;
                k = j;
                break;
            }
            if (k >= 0 && !splitMin[k].equals(splitMax[k])) {
                text.add(String.format(((MutableComponent)uniqueInfoMin.get(i)).getString().replaceFirst(splitMin[k], "%s"), String.format("%s-%s", splitMin[k], splitMax[k])));
                continue;
            }
            text.add(((MutableComponent)uniqueInfoMin.get(i)).getString());
        }
        return text;
    }

    public static String handleCapitalization(String input) {
        return Arrays.stream(input.split("[ |_]")).map(word -> {
            if (word.equals("spell")) {
                return "";
            }
            String first = word.substring(0, 1);
            String rest = word.substring(1);
            return first.toUpperCase() + rest;
        }).collect(Collectors.joining(" ")).trim();
    }

    private static String createAttributeModifierText(Holder<Attribute> attribute, AttributeModifier modifier) {
        double d0 = modifier.amount();
        double d1 = modifier.operation() == AttributeModifier.Operation.ADD_MULTIPLIED_BASE || modifier.operation() == AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL ? d0 * 100.0 : (attribute.is(Attributes.KNOCKBACK_RESISTANCE) ? d0 * 10.0 : d0);
        if (d0 >= 0.0) {
            return Component.translatable((String)("attribute.modifier.plus." + modifier.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(d1), Component.translatable((String)((Attribute)attribute.value()).getDescriptionId())}).withStyle(((Attribute)attribute.value()).getStyle(true)).getString();
        }
        return Component.translatable((String)("attribute.modifier.take." + modifier.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(-d1), Component.translatable((String)((Attribute)attribute.value()).getDescriptionId())}).withStyle(((Attribute)attribute.value()).getStyle(false)).getString();
    }

    private static IntUnaryOperator createPaletteMapping(int[] p_266839_, int[] p_266776_) {
        if (p_266776_.length != p_266839_.length) {
            throw new IllegalArgumentException();
        }
        Int2IntOpenHashMap int2intmap = new Int2IntOpenHashMap(p_266776_.length);
        for (int i = 0; i < p_266839_.length; ++i) {
            int j = p_266839_[i];
            if (FastColor.ABGR32.alpha((int)j) == 0) continue;
            int2intmap.put(FastColor.ABGR32.transparent((int)j), p_266776_[i]);
        }
        return arg_0 -> GenerateSiteData.lambda$createPaletteMapping$17((Int2IntMap)int2intmap, arg_0);
    }

    private static /* synthetic */ int lambda$createPaletteMapping$17(Int2IntMap int2intmap, int p_267899_) {
        int k = FastColor.ABGR32.alpha((int)p_267899_);
        if (k == 0) {
            return p_267899_;
        }
        int l = FastColor.ABGR32.transparent((int)p_267899_);
        int i1 = int2intmap.getOrDefault(l, FastColor.ABGR32.opaque((int)l));
        int j1 = FastColor.ABGR32.alpha((int)i1);
        return FastColor.ABGR32.color((int)(k * j1 / 255), (int)i1);
    }

    private record RecipeIngredientData(String id, String name, String path, Item item) {
        public static RecipeIngredientData EMPTY = new RecipeIngredientData("", "", "", null);
    }

    private static enum CraftingType {
        CRAFTING_TABLE,
        SMITHING_TABLE,
        NOT_CRAFTABLE;

    }
}

