/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.irons_apothic.util;

import com.google.common.collect.Multimap;
import io.redspace.ironsspellbooks.api.item.UpgradeData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.item.armor.UpgradeOrbType;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class AffixSchoolMapper {
    public static Set<SchoolType> getSpellSchoolsFromGear(ItemStack stack) {
        HashSet<SchoolType> schools = new HashSet<SchoolType>();
        schools.addAll(AffixSchoolMapper.getVanillaSlotAttributes(stack));
        schools.addAll(AffixSchoolMapper.getCurioAttributes(stack));
        schools.addAll(AffixSchoolMapper.getUpgradeDataAttributes(stack));
        return schools;
    }

    private static Set<SchoolType> getVanillaSlotAttributes(ItemStack stack) {
        HashSet<SchoolType> schools = new HashSet<SchoolType>();
        ItemAttributeModifiers componentModifiers = (ItemAttributeModifiers)stack.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY);
        List allModifierEntries = componentModifiers.modifiers();
        for (ItemAttributeModifiers.Entry entry : allModifierEntries) {
            Attribute attribute;
            SchoolType school;
            Holder attributeHolder = entry.attribute();
            if (!attributeHolder.isBound() || (school = AffixSchoolMapper.getSchoolFromAttribute(attribute = (Attribute)attributeHolder.value())) == null) continue;
            schools.add(school);
        }
        return schools;
    }

    private static Set<SchoolType> getUpgradeDataAttributes(ItemStack stack) {
        HashSet<SchoolType> schools = new HashSet<SchoolType>();
        UpgradeData upgradeData = UpgradeData.getUpgradeData((ItemStack)stack);
        for (Holder upgradeHolder : upgradeData.upgrades().keySet()) {
            Attribute attribute;
            SchoolType school;
            UpgradeOrbType upgradeOrb;
            Holder attributeHolder;
            if (!upgradeHolder.isBound() || !(attributeHolder = (upgradeOrb = (UpgradeOrbType)upgradeHolder.value()).attribute()).isBound() || (school = AffixSchoolMapper.getSchoolFromAttribute(attribute = (Attribute)attributeHolder.value())) == null) continue;
            schools.add(school);
        }
        return schools;
    }

    private static Set<SchoolType> getCurioAttributes(ItemStack stack) {
        HashSet<SchoolType> schools = new HashSet<SchoolType>();
        Item item = stack.getItem();
        if (!(item instanceof ICurioItem)) {
            return schools;
        }
        ICurioItem curio = (ICurioItem)item;
        Map slotTypes = CuriosApi.getItemStackSlots((ItemStack)stack, (boolean)false);
        for (String slotId : slotTypes.keySet()) {
            SlotContext context = new SlotContext(slotId, null, -1, false, true);
            ResourceLocation modifierId = ResourceLocation.fromNamespaceAndPath((String)"irons_apothic", (String)"school_check");
            Multimap attributes = curio.getAttributeModifiers(context, modifierId, stack);
            for (Holder attributeHolder : attributes.keySet()) {
                Attribute attribute;
                SchoolType school;
                if (!attributeHolder.isBound() || (school = AffixSchoolMapper.getSchoolFromAttribute(attribute = (Attribute)attributeHolder.value())) == null) continue;
                schools.add(school);
            }
        }
        return schools;
    }

    private static SchoolType getSchoolFromAttribute(Attribute attribute) {
        ResourceLocation attrId = BuiltInRegistries.ATTRIBUTE.getKey((Object)attribute);
        if (attrId != null && attrId.getPath().endsWith("_spell_power")) {
            String schoolName = attrId.getPath().replace("_spell_power", "");
            ResourceLocation schoolResource = ResourceLocation.fromNamespaceAndPath((String)attrId.getNamespace(), (String)schoolName);
            return (SchoolType)SchoolRegistry.REGISTRY.get(schoolResource);
        }
        return null;
    }
}

