/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.worlddata;

import com.buuz135.industrial.block.generator.mycelial.IMycelialGeneratorType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.neoforge.common.util.INBTSerializable;

public class MycelialDataManager
extends SavedData {
    public static final String NAME = "IFMycelial";
    public HashMap<String, HashMap<String, List<GeneratorInfo>>> infos = new HashMap();

    public static void setGeneratorInfo(String uuid, Level world, BlockPos pos, IMycelialGeneratorType type) {
        if (world instanceof ServerLevel) {
            MycelialDataManager dataManager = MycelialDataManager.getData((LevelAccessor)world);
            List generatorInfos = dataManager.getInfos().computeIfAbsent(uuid, s -> new HashMap()).computeIfAbsent(type.getName(), s -> new ArrayList());
            boolean updated = false;
            for (GeneratorInfo generatorInfo : generatorInfos) {
                if (!generatorInfo.pos.equals((Object)pos) || !generatorInfo.world.equals((Object)world.dimension())) continue;
                updated = true;
                generatorInfo.lastRun = world.getGameTime();
            }
            if (!updated) {
                generatorInfos.add(new GeneratorInfo(world.getGameTime(), 0L, pos, (ResourceKey<Level>)world.dimension()));
            }
            dataManager.setDirty();
        }
    }

    public static void removeGeneratorInfo(String uuid, Level world, BlockPos pos, IMycelialGeneratorType type) {
        MycelialDataManager dataManager = MycelialDataManager.getData((LevelAccessor)world);
        List generatorInfos = dataManager.getInfos().computeIfAbsent(uuid, s -> new HashMap()).computeIfAbsent(type.getName(), s -> new ArrayList());
        generatorInfos.removeIf(generatorInfo -> generatorInfo.world.equals((Object)world.dimension()) && generatorInfo.pos.equals((Object)pos));
        dataManager.setDirty();
    }

    public static List<String> getReactorAvailable(String uuid, Level world, boolean execute) {
        ArrayList<String> names = new ArrayList<String>();
        if (world instanceof ServerLevel) {
            MycelialDataManager dataManager = MycelialDataManager.getData((LevelAccessor)world);
            HashMap generators = dataManager.getInfos().computeIfAbsent(uuid, s -> new HashMap());
            block0: for (IMycelialGeneratorType type : IMycelialGeneratorType.TYPES) {
                for (GeneratorInfo generatorInfo : generators.computeIfAbsent(type.getName(), s -> new ArrayList())) {
                    if (generatorInfo.lastTracked + 5L > world.getGameTime() || generatorInfo.lastRun + 5L < world.getGameTime()) continue;
                    names.add(type.getName());
                    if (execute) {
                        generatorInfo.lastTracked = world.getGameTime();
                    }
                    dataManager.setDirty();
                    continue block0;
                }
            }
        }
        return names;
    }

    public HashMap<String, HashMap<String, List<GeneratorInfo>>> getInfos() {
        return this.infos;
    }

    public static MycelialDataManager load(HolderLookup.Provider provider, CompoundTag nbt) {
        MycelialDataManager mycelialDataManager = new MycelialDataManager();
        for (String uuid : nbt.getCompound("values").getAllKeys()) {
            CompoundTag uuidNbt = nbt.getCompound("values").getCompound(uuid);
            HashMap<String, List> generators = new HashMap<String, List>();
            for (String genName : uuidNbt.getAllKeys()) {
                CompoundTag genNbt = uuidNbt.getCompound(genName);
                for (String s : genNbt.getAllKeys()) {
                    GeneratorInfo generatorInfo = new GeneratorInfo();
                    generatorInfo.deserializeNBT(provider, genNbt.getCompound(s));
                    generators.computeIfAbsent(genName, s1 -> new ArrayList()).add(generatorInfo);
                }
            }
            mycelialDataManager.infos.put(uuid, generators);
        }
        return mycelialDataManager;
    }

    @Nullable
    public static MycelialDataManager getData(LevelAccessor world) {
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = ((ServerLevel)world).getServer().getLevel(Level.OVERWORLD);
            MycelialDataManager data = (MycelialDataManager)serverWorld.getDataStorage().computeIfAbsent(new SavedData.Factory(MycelialDataManager::new, (compoundTag, provider) -> MycelialDataManager.load(provider, compoundTag)), NAME);
            return data;
        }
        return null;
    }

    public CompoundTag save(CompoundTag compound, HolderLookup.Provider provider) {
        CompoundTag values = new CompoundTag();
        for (String uuid : this.infos.keySet()) {
            CompoundTag uuidNbt = new CompoundTag();
            for (String genName : this.infos.get(uuid).keySet()) {
                int i = 0;
                CompoundTag genNbt = new CompoundTag();
                for (GeneratorInfo generatorInfo : this.infos.get(uuid).get(genName)) {
                    genNbt.put("" + i, (Tag)generatorInfo.serializeNBT(provider));
                    ++i;
                }
                uuidNbt.put(genName, (Tag)genNbt);
            }
            values.put(uuid, (Tag)uuidNbt);
        }
        compound.put("values", (Tag)values);
        return compound;
    }

    public static class GeneratorInfo
    implements INBTSerializable<CompoundTag> {
        private long lastRun;
        private long lastTracked;
        private BlockPos pos;
        private ResourceKey<Level> world;

        public GeneratorInfo(long lastRun, long lastTracked, BlockPos pos, ResourceKey<Level> world) {
            this.lastRun = lastRun;
            this.lastTracked = lastTracked;
            this.pos = pos;
            this.world = world;
        }

        public GeneratorInfo() {
        }

        public CompoundTag serializeNBT(HolderLookup.Provider provider) {
            CompoundTag compoundNBT = new CompoundTag();
            compoundNBT.putLong("Run", this.lastRun);
            compoundNBT.putLong("Track", this.lastTracked);
            compoundNBT.putLong("Pos", this.pos.asLong());
            compoundNBT.putString("RKValue", this.world.location().toString());
            return compoundNBT;
        }

        public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
            this.lastRun = nbt.getLong("Run");
            this.lastTracked = nbt.getLong("Track");
            this.pos = BlockPos.of((long)nbt.getLong("Pos"));
            this.world = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)nbt.getString("RKValue")));
        }
    }
}

