/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.item.infinity.item;

import com.buuz135.industrial.IndustrialForegoing;
import com.buuz135.industrial.block.tool.tile.InfinityBackpackTile;
import com.buuz135.industrial.container.BackpackContainer;
import com.buuz135.industrial.gui.component.SlotDefinitionGuiAddon;
import com.buuz135.industrial.item.infinity.InfinityEnergyStorage;
import com.buuz135.industrial.item.infinity.InfinityTankStorage;
import com.buuz135.industrial.item.infinity.InfinityTier;
import com.buuz135.industrial.item.infinity.ItemInfinity;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.module.ModuleTool;
import com.buuz135.industrial.proxy.network.BackpackOpenedMessage;
import com.buuz135.industrial.proxy.network.BackpackSyncMessage;
import com.buuz135.industrial.utils.IFAttachments;
import com.buuz135.industrial.utils.IndustrialTags;
import com.buuz135.industrial.worlddata.BackpackDataManager;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.AssetScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.StateButtonAddon;
import com.hrznstudio.titanium.client.screen.addon.StateButtonInfo;
import com.hrznstudio.titanium.component.button.ButtonComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.event.handler.EventManager;
import com.hrznstudio.titanium.item.BasicItem;
import com.hrznstudio.titanium.itemstack.ItemStackHarnessRegistry;
import com.hrznstudio.titanium.network.Message;
import com.hrznstudio.titanium.network.locator.LocatorFactory;
import com.hrznstudio.titanium.network.locator.LocatorInstance;
import com.hrznstudio.titanium.network.locator.PlayerInventoryFinder;
import com.hrznstudio.titanium.network.locator.instance.HeldStackLocatorInstance;
import com.hrznstudio.titanium.network.locator.instance.InventoryStackLocatorInstance;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.event.entity.player.PlayerXpEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class ItemInfinityBackpack
extends ItemInfinity {
    public static int POWER_CONSUMPTION = 0;
    public static int FUEL_CONSUMPTION = 1;

    public ItemInfinityBackpack() {
        super("infinity_backpack", ModuleTool.TAB_TOOL, new Item.Properties().stacksTo(1), POWER_CONSUMPTION, FUEL_CONSUMPTION, false);
        this.disableArea();
        EventManager.forge(ItemEntityPickupEvent.Pre.class).filter(entityItemPickupEvent -> !entityItemPickupEvent.getItemEntity().getItem().isEmpty()).process(entityItemPickupEvent -> {
            for (PlayerInventoryFinder.Target target : ItemInfinityBackpack.findAllBackpacks(entityItemPickupEvent.getPlayer())) {
                BackpackDataManager.BackpackItemHandler handler;
                BackpackDataManager manager;
                ItemStack stack = (ItemStack)target.getFinder().getStackGetter().apply(entityItemPickupEvent.getPlayer(), target.getSlot());
                if (stack.isEmpty() || !(stack.getItem() instanceof ItemInfinityBackpack) || ItemInfinityBackpack.getPickUpMode(stack) != 1 && ItemInfinityBackpack.getPickUpMode(stack) != 0 || (manager = BackpackDataManager.getData((LevelAccessor)entityItemPickupEvent.getItemEntity().level())) == null || !stack.has(IFAttachments.INFINITY_BACKPACK_ID) || (handler = manager.getBackpack((String)stack.get(IFAttachments.INFINITY_BACKPACK_ID))) == null) continue;
                ItemStack picked = entityItemPickupEvent.getItemEntity().getItem();
                for (int pos = 0; pos < handler.getSlots(); ++pos) {
                    ItemStack slotStack = handler.getSlotDefinition(pos).getStack().copy();
                    slotStack.setCount(1);
                    if (slotStack.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)picked, (ItemStack)slotStack)) continue;
                    ItemStack returned = handler.insertItem(pos, picked.copy(), false);
                    picked.setCount(returned.getCount());
                    entityItemPickupEvent.setCanPickup(TriState.FALSE);
                    Player patt0$temp = entityItemPickupEvent.getPlayer();
                    if (patt0$temp instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                        ItemInfinityBackpack.sync(entityItemPickupEvent.getItemEntity().level(), (String)stack.get(IFAttachments.INFINITY_BACKPACK_ID), serverPlayer);
                    }
                    return;
                }
            }
        }).subscribe();
        EventManager.forge(PlayerXpEvent.PickupXp.class).filter(pickupXp -> pickupXp.getOrb().isAlive()).process(pickupXp -> ItemInfinityBackpack.findFirstBackpack(pickupXp.getEntity()).ifPresent(target -> {
            IFluidHandlerItem handlerItem;
            ItemStack stack = (ItemStack)target.getFinder().getStackGetter().apply(pickupXp.getEntity(), target.getSlot());
            if (!stack.isEmpty() && stack.getItem() instanceof ItemInfinityBackpack && (ItemInfinityBackpack.getPickUpMode(stack) == 2 || ItemInfinityBackpack.getPickUpMode(stack) == 0) && (handlerItem = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM)) != null) {
                ExperienceOrb entity = pickupXp.getOrb();
                if (handlerItem.fill(new FluidStack((Fluid)ModuleCore.ESSENCE.getSourceFluid().get(), entity.getValue() * 20), IFluidHandler.FluidAction.SIMULATE) > 0) {
                    handlerItem.fill(new FluidStack((Fluid)ModuleCore.ESSENCE.getSourceFluid().get(), entity.getValue() * 20), IFluidHandler.FluidAction.EXECUTE);
                    entity.remove(Entity.RemovalReason.KILLED);
                    pickupXp.setCanceled(true);
                }
            }
        })).subscribe();
    }

    public static int getSlotSize(ItemStack stack) {
        InfinityTier braquet = (InfinityTier)((Object)InfinityTier.getTierBraquet(ItemInfinityBackpack.getPowerFromStack(stack)).getLeft());
        return braquet == InfinityTier.ARTIFACT ? Integer.MAX_VALUE : (int)(2048.0 * Math.pow(8.0, braquet.getRadius()));
    }

    public static void sync(Level world, String id, ServerPlayer player) {
        BackpackDataManager.BackpackItemHandler backpack;
        BackpackDataManager data = BackpackDataManager.getData((LevelAccessor)world);
        if (data != null && (backpack = data.getBackpack(id)) != null) {
            IndustrialForegoing.NETWORK.sendTo((Message)new BackpackSyncMessage(id, backpack.serializeNBT((HolderLookup.Provider)world.registryAccess())), player);
        }
    }

    public static boolean isMagnetEnabled(ItemStack stack) {
        return (Boolean)stack.getOrDefault(IFAttachments.INFINITY_MAGNET_ENABLED, (Object)true);
    }

    public static void setMagnet(ItemStack stack, boolean enabled) {
        stack.set(IFAttachments.INFINITY_MAGNET_ENABLED, (Object)enabled);
    }

    public static int getPickUpMode(ItemStack stack) {
        return (Integer)stack.getOrDefault(IFAttachments.INFINITY_BACKPACK_PICKUP_MODE, (Object)0);
    }

    public static void setPickUpMode(ItemStack stack, int mode) {
        stack.set(IFAttachments.INFINITY_BACKPACK_PICKUP_MODE, (Object)mode);
    }

    public static List<PlayerInventoryFinder.Target> findAllBackpacks(Player entity) {
        ArrayList<PlayerInventoryFinder.Target> list = new ArrayList<PlayerInventoryFinder.Target>();
        for (String name : PlayerInventoryFinder.FINDERS.keySet()) {
            PlayerInventoryFinder finder = (PlayerInventoryFinder)PlayerInventoryFinder.FINDERS.get(name);
            for (int i = 0; i < (Integer)finder.getSlotAmountGetter().apply(entity); ++i) {
                if (!(((ItemStack)finder.getStackGetter().apply(entity, i)).getItem() instanceof ItemInfinityBackpack)) continue;
                list.add(new PlayerInventoryFinder.Target(name, finder, i));
            }
        }
        return Collections.unmodifiableList(list);
    }

    public static Optional<PlayerInventoryFinder.Target> findFirstBackpack(Player entity) {
        for (String name : PlayerInventoryFinder.FINDERS.keySet()) {
            PlayerInventoryFinder finder = (PlayerInventoryFinder)PlayerInventoryFinder.FINDERS.get(name);
            for (int i = 0; i < (Integer)finder.getSlotAmountGetter().apply(entity); ++i) {
                if (!(((ItemStack)finder.getStackGetter().apply(entity, i)).getItem() instanceof ItemInfinityBackpack)) continue;
                return Optional.of(new PlayerInventoryFinder.Target(name, finder, i));
            }
        }
        return Optional.empty();
    }

    private static void updateBlockEntityComponents(Level level, BlockPos poa, ItemStack stack) {
        BlockEntity blockentity = level.getBlockEntity(poa);
        if (blockentity != null) {
            blockentity.applyComponentsFromItemStack(stack);
            blockentity.setChanged();
        }
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level worldIn, Player player, InteractionHand handIn) {
        ItemStack stack = player.getItemInHand(handIn);
        if (player instanceof ServerPlayer) {
            Object id;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!stack.has(IFAttachments.INFINITY_BACKPACK_ID)) {
                id = UUID.randomUUID();
                BackpackDataManager.getData((LevelAccessor)worldIn).createBackPack((UUID)id);
                stack.set(IFAttachments.INFINITY_BACKPACK_ID, (Object)((UUID)id).toString());
            }
            id = (String)stack.get(IFAttachments.INFINITY_BACKPACK_ID);
            IndustrialForegoing.NETWORK.sendTo((Message)new BackpackOpenedMessage(player.getInventory().selected, PlayerInventoryFinder.MAIN), serverPlayer);
            ItemInfinityBackpack.sync(worldIn, (String)id, serverPlayer);
            serverPlayer.openMenu((MenuProvider)this, buffer -> LocatorFactory.writePacketBuffer((RegistryFriendlyByteBuf)buffer, (LocatorInstance)new HeldStackLocatorInstance(handIn == InteractionHand.MAIN_HAND)));
            return InteractionResultHolder.success((Object)player.getItemInHand(handIn));
        }
        if (IndustrialForegoing.CAT_EARS.getPlayers().contains(player.getUUID())) {
            player.getItemInHand(handIn).set(IFAttachments.INFINITY_ITEM_SPECIAL, (Object)true);
        }
        return super.use(worldIn, player, handIn);
    }

    public void inventoryTick(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (ItemInfinityBackpack.isMagnetEnabled(stack)) {
            for (ItemEntity itemEntity : entityIn.level().getEntitiesOfClass(ItemEntity.class, new AABB(entityIn.getX(), entityIn.getY(), entityIn.getY(), entityIn.getX(), entityIn.getY(), entityIn.getZ()).inflate(5.0))) {
                if (entityIn.level().isClientSide && this.enoughFuel(stack)) {
                    if (!itemEntity.onGround() || worldIn.random.nextInt(5) >= 1) continue;
                    itemEntity.level().addParticle((ParticleOptions)ParticleTypes.PORTAL, itemEntity.getX(), itemEntity.getY() + 0.5, itemEntity.getZ(), 0.0, -0.5, 0.0);
                    continue;
                }
                if (itemEntity.hasPickUpDelay() || !this.enoughFuel(stack)) continue;
                itemEntity.teleportTo(entityIn.getX(), entityIn.getY(), entityIn.getZ());
                this.consumeFuel(stack);
            }
        }
        if (!entityIn.level().isClientSide && entityIn instanceof Player) {
            BackpackDataManager.BackpackItemHandler handler;
            BackpackDataManager manager;
            if (this.enoughFuel(stack)) {
                IFluidHandlerItem handlerItem = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
                if ((((Player)entityIn).getFoodData().needsFood() || ((Player)entityIn).getFoodData().getSaturationLevel() < 10.0f) && handlerItem != null) {
                    for (int i = 0; i < handlerItem.getTanks(); ++i) {
                        FluidStack fluidStack = handlerItem.getFluidInTank(i);
                        if (fluidStack.isEmpty() || fluidStack.getAmount() < 400) continue;
                        handlerItem.drain(new FluidStack((Holder)ModuleCore.MEAT.getSourceFluid(), 400), IFluidHandler.FluidAction.EXECUTE);
                        ((Player)entityIn).getFoodData().eat(1, 1.0f);
                        this.consumeFuel(stack);
                    }
                }
            }
            if (entityIn.level().getGameTime() % 10L == 0L && (manager = BackpackDataManager.getData((LevelAccessor)entityIn.level())) != null && stack.has(IFAttachments.INFINITY_BACKPACK_ID) && (handler = manager.getBackpack((String)stack.get(IFAttachments.INFINITY_BACKPACK_ID))) != null) {
                if (ItemInfinityBackpack.getSlotSize(stack) != handler.getSlotLimit(0)) {
                    handler.setMaxAmount(ItemInfinityBackpack.getSlotSize(stack));
                }
                if (this.enoughFuel(stack)) {
                    for (int i = 0; i < 32; ++i) {
                        if (handler.getStackInSlot(i).isEmpty() || !handler.getSlotDefinition(i).isRefillItems()) continue;
                        Inventory inventory = ((Player)entityIn).getInventory();
                        for (int inv = 0; inv <= 35; ++inv) {
                            ItemStack inventoryStack = inventory.getItem(inv);
                            if (inventoryStack.isEmpty() || inventoryStack.getCount() >= inventoryStack.getMaxStackSize() || !handler.isItemValid(i, inventoryStack) || !this.enoughFuel(stack)) continue;
                            int extracting = inventoryStack.getMaxStackSize() - inventoryStack.getCount();
                            ItemStack extractedSLot = handler.extractItem(i, extracting, false);
                            inventoryStack.setCount(inventoryStack.getCount() + extractedSLot.getCount());
                            if (entityIn instanceof ServerPlayer) {
                                ItemInfinityBackpack.sync(entityIn.level(), (String)stack.get(IFAttachments.INFINITY_BACKPACK_ID), (ServerPlayer)entityIn);
                            }
                            this.consumeFuel(stack);
                            return;
                        }
                    }
                }
            }
        }
        super.inventoryTick(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    @Override
    public IFactory<InfinityTankStorage> getTankConstructor(ItemStack stack) {
        int y = 88;
        return () -> new InfinityTankStorage(stack, new InfinityTankStorage.TankDefinition("biofuel", 1000000, -21, y + 0, fluidStack -> fluidStack.getFluid().isSame((Fluid)ModuleCore.BIOFUEL.getSourceFluid().get()), true, true, FluidTankComponent.Type.SMALL, new FluidStack((Fluid)ModuleCore.BIOFUEL.getSourceFluid().get(), 1000)), new InfinityTankStorage.TankDefinition("essence", 1000000, -21, y + 25, fluidStack -> fluidStack.is(IndustrialTags.Fluids.EXPERIENCE), true, true, FluidTankComponent.Type.SMALL, new FluidStack((Fluid)ModuleCore.ESSENCE.getSourceFluid().get(), 1000)), new InfinityTankStorage.TankDefinition("meat", 1000000, -21, y + 50, fluidStack -> fluidStack.getFluid().isSame((Fluid)ModuleCore.MEAT.getSourceFluid().get()), false, true, FluidTankComponent.Type.SMALL, new FluidStack((Fluid)ModuleCore.MEAT.getSourceFluid().get(), 1000)));
    }

    @Override
    public IFactory<InfinityEnergyStorage> getEnergyConstructor(final ItemStack stack) {
        return () -> new InfinityEnergyStorage(this, InfinityTier.ARTIFACT.getPowerNeeded(), -21, 24){

            @Override
            public long getLongEnergyStored() {
                return Math.min((Long)stack.getOrDefault(IFAttachments.INFINITY_ITEM_POWER, (Object)0L), InfinityTier.ARTIFACT.getPowerNeeded());
            }

            @Override
            public void setEnergyStored(long energy) {
                stack.set(IFAttachments.INFINITY_ITEM_POWER, (Object)Math.min(energy, InfinityTier.ARTIFACT.getPowerNeeded()));
            }

            @Override
            public boolean canReceive() {
                return ItemInfinity.canCharge(stack);
            }
        };
    }

    public void handleButtonMessage(int id, Player playerEntity, CompoundTag compound, ItemStack stack) {
        if (id == 4 && playerEntity instanceof ServerPlayer) {
            String backpackId = compound.getString("Id");
            ItemStack cursor = playerEntity.containerMenu.getCarried();
            boolean shift = compound.getBoolean("Shift");
            boolean ctrl = compound.getBoolean("Ctrl");
            int button = compound.getInt("Button");
            int slot = compound.getInt("Slot");
            BackpackDataManager dataManager = BackpackDataManager.getData((LevelAccessor)playerEntity.level());
            BackpackDataManager.BackpackItemHandler handler = dataManager.getBackpack(backpackId);
            ItemStack result = ItemStack.EMPTY;
            boolean hasCursorChanged = false;
            if (button == 2) {
                ItemStack simulated = handler.extractItem(slot, 1, true);
                if (!simulated.isEmpty() && (cursor.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)simulated, (ItemStack)cursor))) {
                    result = handler.extractItem(slot, 1, false);
                    result.setCount(cursor.getCount() + 1);
                    hasCursorChanged = true;
                }
            } else if (cursor.isEmpty()) {
                int maxStack = handler.getStackInSlot(slot).getMaxStackSize();
                if (button == 0) {
                    if (ctrl) {
                        BackpackDataManager.SlotDefinition definition;
                        definition.setVoidItems(!(definition = handler.getSlotDefinition(slot)).isVoidItems());
                    } else if (shift) {
                        if (handler.getSlotDefinition(slot).getAmount() == 0) {
                            handler.getSlotDefinition(slot).setStack(ItemStack.EMPTY);
                            handler.getSlotDefinition(slot).setAmount(0);
                        } else {
                            ItemHandlerHelper.giveItemToPlayer((Player)playerEntity, (ItemStack)handler.extractItem(slot, maxStack, false));
                        }
                    } else {
                        result = handler.extractItem(slot, maxStack, false);
                        hasCursorChanged = true;
                    }
                } else if (button == 1) {
                    if (ctrl) {
                        BackpackDataManager.SlotDefinition definition;
                        definition.setRefillItems(!(definition = handler.getSlotDefinition(slot)).isRefillItems());
                    } else {
                        result = handler.extractItem(slot, maxStack / 2, false);
                        hasCursorChanged = true;
                    }
                }
            } else if (button == 0) {
                result = handler.insertItem(slot, cursor, false);
                hasCursorChanged = true;
            } else if (button == 1 && handler.insertItem(slot, cursor.copyWithCount(1), false).isEmpty()) {
                cursor.shrink(1);
                result = cursor;
                hasCursorChanged = true;
            }
            if (hasCursorChanged) {
                playerEntity.containerMenu.setCarried(result);
                ((ServerPlayer)playerEntity).containerMenu.broadcastChanges();
            }
            ItemInfinityBackpack.sync(playerEntity.level(), backpackId, (ServerPlayer)playerEntity);
        }
        if (id == 10) {
            ItemInfinityBackpack.setMagnet(stack, !ItemInfinityBackpack.isMagnetEnabled(stack));
        }
        if (id == 11) {
            ItemInfinityBackpack.setPickUpMode(stack, (ItemInfinityBackpack.getPickUpMode(stack) + 1) % 4);
        }
        if (id == 3) {
            this.setCanCharge(stack, !ItemInfinityBackpack.canCharge(stack));
        }
        if (id == -10) {
            this.setSpecialEnabled(stack, !this.isSpecialEnabled(stack));
        }
    }

    @Override
    public void handleButtonMessage(int id, Player playerEntity, CompoundTag compound) {
        ItemInfinityBackpack.findFirstBackpack(playerEntity).ifPresent(target -> {
            ItemStack stack = (ItemStack)target.getFinder().getStackGetter().apply(playerEntity, target.getSlot());
            if (!stack.isEmpty()) {
                this.handleButtonMessage(id, playerEntity, compound, stack);
            }
        });
    }

    @Override
    public void addTooltipDetails(@Nullable BasicItem.Key key, ItemStack stack, List<Component> tooltip, boolean advanced) {
        tooltip.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + Component.translatable((String)"text.industrialforegoing.tooltip.can_hold").getString() + ": " + String.valueOf(ChatFormatting.DARK_AQUA) + NumberFormat.getInstance(Locale.ROOT).format(ItemInfinityBackpack.getSlotSize(stack)) + String.valueOf(ChatFormatting.GRAY) + " " + Component.translatable((String)"text.industrialforegoing.tooltip.items").getString())));
        super.addTooltipDetails(key, stack, tooltip, advanced);
    }

    @Override
    public void addNbt(ItemStack stack, long power, int fuel, boolean special) {
        stack.set(IFAttachments.INFINITY_ITEM_POWER, (Object)power);
        stack.set(IFAttachments.INFINITY_ITEM_SPECIAL, (Object)special);
        stack.set(IFAttachments.INFINITY_ITEM_SELECTED_TIER, (Object)((InfinityTier)((Object)InfinityTier.getTierBraquet(power).getLeft())));
        stack.set(IFAttachments.INFINITY_ITEM_CAN_CHARGE, (Object)true);
    }

    @Override
    public void verifyComponentsAfterLoad(ItemStack stack) {
        super.verifyComponentsAfterLoad(stack);
    }

    @Override
    public boolean enoughFuel(ItemStack stack) {
        int i = EnchantmentHelper.getItemEnchantmentLevel((Holder)IFAttachments.registryAccess().holderOrThrow(Enchantments.UNBREAKING), (ItemStack)stack);
        return this.getFuelFromStack(stack) >= FUEL_CONSUMPTION * (1 / (i + 1));
    }

    @Override
    public void consumeFuel(ItemStack stack) {
        IFluidHandlerItem capability;
        int level = EnchantmentHelper.getItemEnchantmentLevel((Holder)IFAttachments.registryAccess().holderOrThrow(Enchantments.UNBREAKING), (ItemStack)stack);
        if (this.getFuelFromStack(stack) >= FUEL_CONSUMPTION * (1 / (level + 1)) && (capability = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM)) != null) {
            for (int i = 0; i < capability.getTanks(); ++i) {
                if (!capability.getFluidInTank(i).is((Holder)ModuleCore.BIOFUEL.getSourceFluid())) continue;
                capability.drain(new FluidStack((Holder)ModuleCore.BIOFUEL.getSourceFluid(), FUEL_CONSUMPTION * (1 / (level + 1))), IFluidHandler.FluidAction.EXECUTE);
                return;
            }
        }
    }

    @Override
    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    @Override
    public float getDestroySpeed(ItemStack stack, BlockState state) {
        return 1.0f;
    }

    @Override
    public ItemAttributeModifiers getDefaultAttributeModifiers(ItemStack stack) {
        return ItemAttributeModifiers.EMPTY;
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int menu, Inventory p_createMenu_2_, Player playerEntity) {
        return ItemInfinityBackpack.findFirstBackpack(playerEntity).map(target -> {
            ItemStack stack = (ItemStack)target.getFinder().getStackGetter().apply(playerEntity, target.getSlot());
            if (!stack.isEmpty()) {
                Object id;
                if (!stack.has(IFAttachments.INFINITY_BACKPACK_ID)) {
                    id = UUID.randomUUID();
                    BackpackDataManager.getData((LevelAccessor)playerEntity.level()).createBackPack((UUID)id);
                    stack.set(IFAttachments.INFINITY_BACKPACK_ID, (Object)((UUID)id).toString());
                }
                id = (String)stack.get(IFAttachments.INFINITY_BACKPACK_ID);
                return new BackpackContainer(((Function)ItemStackHarnessRegistry.getHarnessCreators().get(ModuleTool.INFINITY_BACKPACK)).apply(stack), (LocatorInstance)new InventoryStackLocatorInstance(target.getName(), target.getSlot()), new ContainerLevelAccess(this){

                    public <T> Optional<T> evaluate(BiFunction<Level, BlockPos, T> p_221484_1_) {
                        return Optional.empty();
                    }
                }, playerEntity.getInventory(), menu, (String)id);
            }
            return null;
        }).orElse(null);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<IFactory<? extends IScreenAddon>> getScreenAddons(final Supplier<ItemStack> stack) {
        ArrayList<IFactory<? extends IScreenAddon>> factory = new ArrayList<IFactory<? extends IScreenAddon>>();
        int i = 0;
        while (i < 32) {
            int x = i % 8;
            int y = i / 8;
            int finalI = i++;
            factory.add(() -> new SlotDefinitionGuiAddon(this, new ButtonComponent(17 + 18 * x, 22 + 18 * y, 17, 17).setId(4), finalI){

                @Override
                public ItemStack getItemStack() {
                    return (ItemStack)stack.get();
                }
            });
        }
        factory.add(() -> new AssetScreenAddon(AssetTypes.AUGMENT_BACKGROUND_LEFT_TALL, -27, 10, true));
        factory.add(() -> new AssetScreenAddon(AssetTypes.AUGMENT_BACKGROUND, 175, 10, true));
        int x = 181;
        int y = 19;
        factory.add(() -> new StateButtonAddon(this, new ButtonComponent(x, 16 + y * 0, 14, 14).setId(10), new StateButtonInfo[]{new StateButtonInfo(0, AssetTypes.BUTTON_SIDENESS_ENABLED, new String[]{String.valueOf(ChatFormatting.GREEN) + Component.translatable((String)"tooltip.industrialforegoing.backpack.magnet_enabled").getString(), String.valueOf(ChatFormatting.DARK_GRAY) + Component.translatable((String)"tooltip.industrialforegoing.backpack.needs_biofuel").getString()}), new StateButtonInfo(1, AssetTypes.BUTTON_SIDENESS_DISABLED, new String[]{String.valueOf(ChatFormatting.RED) + Component.translatable((String)"tooltip.industrialforegoing.backpack.magnet_disabled").getString()})}){

            public int getState() {
                return ItemInfinityBackpack.isMagnetEnabled((ItemStack)stack.get()) ? 0 : 1;
            }
        });
        factory.add(() -> new StateButtonAddon(this, new ButtonComponent(x, 16 + y * 1, 14, 14).setId(11), new StateButtonInfo[]{new StateButtonInfo(0, AssetTypes.BUTTON_SIDENESS_ENABLED, new String[]{String.valueOf(ChatFormatting.GREEN) + Component.translatable((String)"tooltip.industrialforegoing.backpack.pickup_all").getString(), String.valueOf(ChatFormatting.GRAY) + Component.translatable((String)"tooltip.industrialforegoing.backpack.pickup_extra").getString(), String.valueOf(ChatFormatting.GRAY) + Component.translatable((String)"tooltip.industrialforegoing.backpack.pickup_extra_1").getString()}), new StateButtonInfo(1, AssetTypes.BUTTON_SIDENESS_PULL, new String[]{String.valueOf(ChatFormatting.GREEN) + Component.translatable((String)"tooltip.industrialforegoing.backpack.item_pickup_enabled").getString(), String.valueOf(ChatFormatting.GRAY) + Component.translatable((String)"tooltip.industrialforegoing.backpack.pickup_extra").getString(), String.valueOf(ChatFormatting.GRAY) + Component.translatable((String)"tooltip.industrialforegoing.backpack.pickup_extra_1").getString()}), new StateButtonInfo(2, AssetTypes.BUTTON_SIDENESS_PUSH, new String[]{String.valueOf(ChatFormatting.GREEN) + Component.translatable((String)"tooltip.industrialforegoing.backpack.xp_pickup_enabled").getString(), String.valueOf(ChatFormatting.GRAY) + Component.translatable((String)"tooltip.industrialforegoing.backpack.pickup_extra").getString(), String.valueOf(ChatFormatting.GRAY) + Component.translatable((String)"tooltip.industrialforegoing.backpack.pickup_extra_1").getString()}), new StateButtonInfo(3, AssetTypes.BUTTON_SIDENESS_DISABLED, new String[]{String.valueOf(ChatFormatting.RED) + Component.translatable((String)"tooltip.industrialforegoing.backpack.pickup_disabled").getString(), String.valueOf(ChatFormatting.GRAY) + Component.translatable((String)"tooltip.industrialforegoing.backpack.pickup_extra").getString(), String.valueOf(ChatFormatting.GRAY) + Component.translatable((String)"tooltip.industrialforegoing.backpack.pickup_extra_1").getString()})}){

            public int getState() {
                return ItemInfinityBackpack.getPickUpMode((ItemStack)stack.get());
            }
        });
        factory.add(() -> new StateButtonAddon(this, new ButtonComponent(x, 16 + y * 2, 14, 14).setId(3), new StateButtonInfo[]{new StateButtonInfo(0, AssetTypes.BUTTON_SIDENESS_ENABLED, new String[]{String.valueOf(ChatFormatting.GREEN) + Component.translatable((String)"text.industrialforegoing.display.charging").getString() + Component.translatable((String)"text.industrialforegoing.display.enabled").getString()}), new StateButtonInfo(1, AssetTypes.BUTTON_SIDENESS_DISABLED, new String[]{String.valueOf(ChatFormatting.RED) + Component.translatable((String)"text.industrialforegoing.display.charging").getString() + Component.translatable((String)"text.industrialforegoing.display.disabled").getString()})}){

            public int getState() {
                return ItemInfinity.canCharge((ItemStack)stack.get()) ? 0 : 1;
            }
        });
        if (this.isSpecial(stack.get())) {
            factory.add((IFactory<? extends IScreenAddon>)((IFactory)() -> new StateButtonAddon(this, new ButtonComponent(x, 16 + y * 3, 14, 14).setId(-10), new StateButtonInfo[]{new StateButtonInfo(0, AssetTypes.BUTTON_SIDENESS_ENABLED, new String[]{String.valueOf(ChatFormatting.GOLD) + Component.translatable((String)"text.industrialforegoing.display.special").getString()}), new StateButtonInfo(1, AssetTypes.BUTTON_SIDENESS_DISABLED, new String[]{String.valueOf(ChatFormatting.GOLD) + Component.translatable((String)"text.industrialforegoing.display.special").getString()})}){

                public int getState() {
                    return ((ItemInfinityBackpack)ModuleTool.INFINITY_BACKPACK.get()).isSpecialEnabled((ItemStack)stack.get()) ? 0 : 1;
                }
            }));
        }
        return factory;
    }

    @Override
    public void registerRecipe(RecipeOutput consumer) {
        TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this).pattern("CDC").pattern("BPB").pattern("GGG").define(Character.valueOf('C'), Tags.Items.CHESTS_WOODEN).define(Character.valueOf('D'), IndustrialTags.Items.GEAR_DIAMOND).define(Character.valueOf('B'), (ItemLike)Items.BUCKET).define(Character.valueOf('P'), (ItemLike)Items.ENDER_PEARL).define(Character.valueOf('G'), IndustrialTags.Items.GEAR_GOLD).save(consumer);
    }

    public InteractionResult useOn(UseOnContext context) {
        InteractionResult interactionresult = this.place(new BlockPlaceContext(context));
        if (!interactionresult.consumesAction() && context.getItemInHand().has(DataComponents.FOOD)) {
            InteractionResult interactionresult1 = super.use(context.getLevel(), context.getPlayer(), context.getHand()).getResult();
            return interactionresult1 == InteractionResult.CONSUME ? InteractionResult.CONSUME_PARTIAL : interactionresult1;
        }
        return interactionresult;
    }

    public InteractionResult place(BlockPlaceContext context) {
        if (!context.getPlayer().isShiftKeyDown()) {
            return InteractionResult.PASS;
        }
        if (!context.canPlace()) {
            return InteractionResult.FAIL;
        }
        BlockPlaceContext blockplacecontext = this.updatePlacementContext(context);
        if (blockplacecontext == null) {
            return InteractionResult.FAIL;
        }
        BlockState blockstate = this.getPlacementState(blockplacecontext);
        if (blockstate == null) {
            return InteractionResult.FAIL;
        }
        if (!this.placeBlock(blockplacecontext, blockstate)) {
            return InteractionResult.FAIL;
        }
        BlockPos blockpos = blockplacecontext.getClickedPos();
        Level level = blockplacecontext.getLevel();
        Player player = blockplacecontext.getPlayer();
        ItemStack itemstack = blockplacecontext.getItemInHand();
        BlockState blockstate1 = level.getBlockState(blockpos);
        if (blockstate1.is(blockstate.getBlock())) {
            this.updateCustomBlockEntityTag(level, player, blockpos, itemstack);
            ItemInfinityBackpack.updateBlockEntityComponents(level, blockpos, itemstack);
            blockstate1.getBlock().setPlacedBy(level, blockpos, blockstate1, (LivingEntity)player, itemstack);
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.PLACED_BLOCK.trigger((ServerPlayer)player, blockpos, itemstack);
            }
        }
        SoundType soundtype = blockstate1.getSoundType((LevelReader)level, blockpos, (Entity)context.getPlayer());
        level.playSound(player, blockpos, this.getPlaceSound(blockstate1, level, blockpos, context.getPlayer()), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
        level.gameEvent((Holder)GameEvent.BLOCK_PLACE, blockpos, GameEvent.Context.of((Entity)player, (BlockState)blockstate1));
        itemstack.consume(1, (LivingEntity)player);
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    @Deprecated
    protected SoundEvent getPlaceSound(BlockState state) {
        return state.getSoundType().getPlaceSound();
    }

    protected SoundEvent getPlaceSound(BlockState p_state, Level world, BlockPos pos, Player entity) {
        return p_state.getSoundType((LevelReader)world, pos, (Entity)entity).getPlaceSound();
    }

    @Nullable
    public BlockPlaceContext updatePlacementContext(BlockPlaceContext context) {
        return context;
    }

    public Block getBlock() {
        return ModuleTool.INFINITY_BACKPACK_BLOCK.getBlock();
    }

    @Nullable
    protected BlockState getPlacementState(BlockPlaceContext context) {
        BlockState blockstate = this.getBlock().getStateForPlacement(context);
        return blockstate != null && this.canPlace(context, blockstate) ? blockstate : null;
    }

    protected boolean canPlace(BlockPlaceContext context, BlockState state) {
        Player player = context.getPlayer();
        CollisionContext collisioncontext = player == null ? CollisionContext.empty() : CollisionContext.of((Entity)player);
        return (!this.mustSurvive() || state.canSurvive((LevelReader)context.getLevel(), context.getClickedPos())) && context.getLevel().isUnobstructed(state, context.getClickedPos(), collisioncontext);
    }

    protected boolean mustSurvive() {
        return true;
    }

    protected boolean placeBlock(BlockPlaceContext context, BlockState state) {
        return context.getLevel().setBlock(context.getClickedPos(), state, 11);
    }

    public boolean updateCustomBlockEntityTag(Level level, @Nullable Player player, BlockPos pos, ItemStack stack) {
        CustomData customdata;
        MinecraftServer minecraftserver = level.getServer();
        if (minecraftserver == null) {
            return false;
        }
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (blockentity instanceof InfinityBackpackTile) {
            InfinityBackpackTile infinityBackpackTile = (InfinityBackpackTile)blockentity;
            infinityBackpackTile.setBackpack(stack.copy());
        }
        if (!(customdata = (CustomData)stack.getOrDefault(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.EMPTY)).isEmpty() && blockentity != null) {
            if (!(level.isClientSide || !blockentity.onlyOpCanSetNbt() || player != null && player.canUseGameMasterBlocks())) {
                return false;
            }
            return customdata.loadInto(blockentity, (HolderLookup.Provider)level.registryAccess());
        }
        return false;
    }
}

