/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.fluid;

import com.buuz135.industrial.fluid.OreFluid;
import com.buuz135.industrial.fluid.OreTitaniumFluidType;
import com.hrznstudio.titanium.module.DeferredRegistryHelper;
import com.hrznstudio.titanium.tab.TitaniumTab;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class OreFluidInstance {
    private DeferredHolder<FluidType, FluidType> fluidType;
    private DeferredHolder<Fluid, Fluid> flowingFluid;
    private DeferredHolder<Fluid, Fluid> sourceFluid;
    private DeferredHolder<Item, Item> bucketFluid;
    private DeferredHolder<Block, Block> blockFluid;
    private String fluid;

    public OreFluidInstance(DeferredRegistryHelper helper, String fluid, FluidType.Properties properties, final IClientFluidTypeExtensions renderProperties, @Nullable TitaniumTab group) {
        this.fluid = fluid;
        this.sourceFluid = helper.registerGeneric(Registries.FLUID, fluid, () -> new OreFluid.Source(this));
        this.flowingFluid = helper.registerGeneric(Registries.FLUID, fluid + "_flowing", () -> new OreFluid.Flowing(this));
        this.bucketFluid = helper.registerGeneric(Registries.ITEM, fluid + "_bucket", () -> {
            BucketItem item = new BucketItem((Fluid)this.sourceFluid.get(), new Item.Properties().craftRemainder(Items.BUCKET).stacksTo(1));
            if (group != null) {
                group.getTabList().add(item);
            }
            return item;
        });
        this.blockFluid = helper.registerGeneric(Registries.BLOCK, fluid, () -> new LiquidBlock((FlowingFluid)this.sourceFluid.get(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WATER).noCollission().strength(100.0f)));
        this.fluidType = helper.registerGeneric(NeoForgeRegistries.FLUID_TYPES.key(), fluid, () -> new OreTitaniumFluidType(this, properties){

            public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
                consumer.accept(renderProperties);
            }
        });
    }

    public Fluid getFlowingFluid() {
        return (Fluid)this.flowingFluid.get();
    }

    public Fluid getSourceFluid() {
        return (Fluid)this.sourceFluid.get();
    }

    public Item getBucketFluid() {
        return (Item)this.bucketFluid.get();
    }

    public Block getBlockFluid() {
        return (Block)this.blockFluid.get();
    }

    public String getFluid() {
        return this.fluid;
    }

    public DeferredHolder<FluidType, FluidType> getFluidType() {
        return this.fluidType;
    }
}

