/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.queryparser.flexible.standard.builders;

import guideme.internal.shaded.lucene.queryparser.flexible.core.QueryNodeException;
import guideme.internal.shaded.lucene.queryparser.flexible.core.builders.QueryTreeBuilder;
import guideme.internal.shaded.lucene.queryparser.flexible.core.messages.QueryParserMessages;
import guideme.internal.shaded.lucene.queryparser.flexible.core.nodes.AnyQueryNode;
import guideme.internal.shaded.lucene.queryparser.flexible.core.nodes.QueryNode;
import guideme.internal.shaded.lucene.queryparser.flexible.messages.MessageImpl;
import guideme.internal.shaded.lucene.queryparser.flexible.standard.builders.StandardQueryBuilder;
import guideme.internal.shaded.lucene.search.BooleanClause;
import guideme.internal.shaded.lucene.search.BooleanQuery;
import guideme.internal.shaded.lucene.search.IndexSearcher;
import guideme.internal.shaded.lucene.search.Query;
import java.util.List;

public class AnyQueryNodeBuilder
implements StandardQueryBuilder {
    @Override
    public BooleanQuery build(QueryNode queryNode) throws QueryNodeException {
        AnyQueryNode andNode = (AnyQueryNode)queryNode;
        BooleanQuery.Builder bQuery = new BooleanQuery.Builder();
        List<QueryNode> children = andNode.getChildren();
        if (children != null) {
            for (QueryNode child : children) {
                Object obj = child.getTag(QueryTreeBuilder.QUERY_TREE_BUILDER_TAGID);
                if (obj == null) continue;
                Query query = (Query)obj;
                try {
                    bQuery.add(query, BooleanClause.Occur.SHOULD);
                }
                catch (IndexSearcher.TooManyClauses ex) {
                    throw new QueryNodeException(new MessageImpl(QueryParserMessages.EMPTY_MESSAGE), (Throwable)ex);
                }
            }
        }
        bQuery.setMinimumNumberShouldMatch(andNode.getMinimumMatchingElements());
        return bQuery.build();
    }
}

