/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.codecs.lucene101;

import guideme.internal.shaded.lucene.store.DataInput;
import guideme.internal.shaded.lucene.store.DataOutput;
import guideme.internal.shaded.lucene.store.IndexInput;
import guideme.internal.shaded.lucene.util.GroupVIntUtil;
import java.io.IOException;

final class PostingsUtil {
    PostingsUtil() {
    }

    static void readVIntBlock(IndexInput docIn, int[] docBuffer, int[] freqBuffer, int num, boolean indexHasFreq, boolean decodeFreq) throws IOException {
        block3: {
            block2: {
                GroupVIntUtil.readGroupVInts((DataInput)docIn, docBuffer, num);
                if (!indexHasFreq || !decodeFreq) break block2;
                for (int i = 0; i < num; ++i) {
                    freqBuffer[i] = docBuffer[i] & 1;
                    int n = i;
                    docBuffer[n] = docBuffer[n] >>> 1;
                    if (freqBuffer[i] != 0) continue;
                    freqBuffer[i] = docIn.readVInt();
                }
                break block3;
            }
            if (!indexHasFreq) break block3;
            int i = 0;
            while (i < num) {
                int n = i++;
                docBuffer[n] = docBuffer[n] >>> 1;
            }
        }
    }

    static void writeVIntBlock(DataOutput docOut, int[] docBuffer, int[] freqBuffer, int num, boolean writeFreqs) throws IOException {
        int i;
        if (writeFreqs) {
            for (i = 0; i < num; ++i) {
                docBuffer[i] = docBuffer[i] << 1 | (freqBuffer[i] == 1 ? 1 : 0);
            }
        }
        docOut.writeGroupVInts(docBuffer, num);
        if (writeFreqs) {
            for (i = 0; i < num; ++i) {
                int freq = freqBuffer[i];
                if (freq == 1) continue;
                docOut.writeVInt(freq);
            }
        }
    }
}

