/*
 * Decompiled with CFR 0.152.
 */
package com.strawberry.gaze.common.event;

import com.sammy.malum.core.handlers.SoulHarvestHandler;
import com.sammy.malum.registry.common.item.MalumItems;
import com.strawberry.gaze.Config;
import com.strawberry.gaze.GazeMod;
import com.strawberry.gaze.common.item.curiosities.weapons.VeilDaggerItem;
import com.strawberry.gaze.core.handlers.enchantment.EnmityHandler;
import com.strawberry.gaze.registry.GazeEnchantmentKeys;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingConversionEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;

public class GazeEvents {
    private static final Set<String> playerVictimPairs = new HashSet<String>();

    @SubscribeEvent
    public void onDrops(LivingDropsEvent event) {
        Entity dagger;
        boolean isUsingVeilDagger;
        Entity main;
        LivingEntity attacker;
        Entity entity;
        DamageSource source = event.getSource();
        LivingEntity victim = event.getEntity();
        if (!(victim instanceof Player) && !this.isConfiguredUmbralDropEntity(victim)) {
            return;
        }
        if (Config.farmUmbrals && (entity = source.getEntity()) instanceof LivingEntity && !((attacker = (LivingEntity)entity) instanceof Player)) {
            main = attacker.getMainHandItem();
            if (!(victim instanceof Player) && (double)attacker.getRandom().nextFloat() > Config.umbralDropChance) {
                return;
            }
            if (main.is((Item)GazeMod.VEIL_DAGGER.get())) {
                SoulHarvestHandler.SpiritSpawner spawner = SoulHarvestHandler.spawnSpirits((Entity)victim).setPreferredCollector(attacker).setCustomItems(new Item[]{(Item)MalumItems.UMBRAL_SPIRIT.get()});
                spawner.spawnSpirits(victim.level());
                return;
            }
        }
        if (!((main = source.getEntity()) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)main;
        if (this.isConfiguredUmbralDropEntity(victim) && !(victim instanceof Player)) {
            if (!Config.mobsDropUmbralsOnServer && !player.getServer().isSingleplayer()) {
                return;
            }
            if ((double)player.getRandom().nextFloat() > Config.umbralDropChance) {
                return;
            }
        }
        main = player.getMainHandItem();
        ItemStack off = player.getOffhandItem();
        boolean bl = isUsingVeilDagger = main.getItem() instanceof VeilDaggerItem || off.getItem() instanceof VeilDaggerItem || main.getItem() == GazeMod.SOUL_OF_THE_VEIL_DAGGER.get() || off.getItem() == GazeMod.SOUL_OF_THE_VEIL_DAGGER.get();
        if (!isUsingVeilDagger) {
            return;
        }
        Entity entity2 = source.getEntity();
        if (!(entity2 instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer killer = (ServerPlayer)entity2;
        Entity entity3 = main.is((Item)GazeMod.VEIL_DAGGER.get()) ? main : (dagger = off.is((Item)GazeMod.VEIL_DAGGER.get()) ? off : ItemStack.EMPTY);
        if (victim instanceof Player) {
            UUID playerUUID = player.getUUID();
            UUID victimUUID = victim.getUUID();
            String pairKey = String.valueOf(playerUUID) + ":" + String.valueOf(victimUUID);
            if (playerVictimPairs.contains(pairKey)) {
                return;
            }
            playerVictimPairs.add(pairKey);
            Holder.Reference enmity = killer.level().registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(GazeEnchantmentKeys.ENMITY);
            int level = dagger.getEnchantmentLevel((Holder)enmity);
            if (level >= 5) {
                return;
            }
            dagger.enchant((Holder)enmity, level + 1);
        }
        SoulHarvestHandler.SpiritSpawner spawner = SoulHarvestHandler.spawnSpirits((Entity)victim).setPreferredCollector((LivingEntity)player).setCustomItems(new Item[]{(Item)MalumItems.UMBRAL_SPIRIT.get()});
        spawner.spawnSpirits(victim.level());
    }

    @SubscribeEvent
    public void onLivingConvertPre(LivingConversionEvent.Pre event) {
        LivingEntity entity = event.getEntity();
        EntityType outcome = event.getOutcome();
        if ((entity instanceof Piglin || entity instanceof Hoglin) && outcome == EntityType.ZOMBIFIED_PIGLIN && entity.getTags().contains("gaze.prevent_zombify") && entity.level().dimension() == Level.OVERWORLD) {
            event.setCanceled(true);
        }
    }

    private boolean isConfiguredUmbralDropEntity(LivingEntity entity) {
        ResourceLocation id = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
        return id != null && Config.umbralDropEntities.contains(id.toString());
    }

    @SubscribeEvent
    public void onLivingDamage(LivingDamageEvent.Pre event) {
        DamageSource source = event.getSource();
        if (source == null) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player targetPlayer = (Player)livingEntity;
        Entity entity = source.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)entity;
        ItemStack weapon = attacker.getMainHandItem();
        if (!weapon.is((Item)GazeMod.VEIL_DAGGER.get())) {
            return;
        }
        EnmityHandler.applyEnmityDamage(attacker, event);
    }
}

