/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.recipe.pigment;

import ky.someone.mods.gag.GAGRegistry;
import ky.someone.mods.gag.item.PigmentJarItem;
import ky.someone.mods.gag.item.data.Pigment;
import ky.someone.mods.gag.util.GAGUtil;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class PigmentJarMixingRecipe
extends CustomRecipe {
    public static final ResourceLocation ID = GAGUtil.id("pigment_jar_mixing");

    public PigmentJarMixingRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput container, Level level) {
        int found = 0;
        for (ItemStack stack : container.items()) {
            if (stack.is((Item)GAGRegistry.PIGMENT_JAR.get())) {
                if (PigmentJarItem.getPigment(stack).isEmpty()) continue;
                ++found;
                continue;
            }
            if (stack.isEmpty()) continue;
            return false;
        }
        return found >= 2;
    }

    public ItemStack assemble(CraftingInput container, HolderLookup.Provider reg) {
        Pigment result = null;
        for (ItemStack stack : container.items()) {
            if (!PigmentJarItem.isNonEmptyJar(stack)) continue;
            Pigment pigment = PigmentJarItem.getPigment(stack);
            if (result == null) {
                result = pigment;
                continue;
            }
            result = result.mix(pigment);
        }
        if (result == null) {
            return ItemStack.EMPTY;
        }
        return result.asJar();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput container) {
        NonNullList list = NonNullList.withSize((int)container.size(), (Object)ItemStack.EMPTY);
        boolean first = true;
        for (int i = 0; i < container.size(); ++i) {
            ItemStack stack = container.getItem(i);
            if (!stack.is((Item)GAGRegistry.PIGMENT_JAR.get())) continue;
            if (first) {
                first = false;
                continue;
            }
            list.set(i, (Object)((Item)GAGRegistry.PIGMENT_JAR.get()).getDefaultInstance());
        }
        return list;
    }

    public boolean canCraftInDimensions(int i, int j) {
        return i * j >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)GAGRegistry.PIGMENT_JAR_MIXING.get();
    }
}

