/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.item.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.awt.Color;
import java.util.Objects;
import ky.someone.mods.gag.GAGRegistry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public final class Pigment {
    private final int color;
    private final int amount;
    public static final Pigment EMPTY = new Pigment(-1, 0);
    public static final Codec<Pigment> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("color").forGetter(Pigment::color), (App)Codec.INT.fieldOf("amount").forGetter(Pigment::amount)).apply((Applicative)builder, Pigment::new));
    public static final StreamCodec<FriendlyByteBuf, Pigment> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, Pigment::color, (StreamCodec)ByteBufCodecs.INT, Pigment::amount, Pigment::new);

    private Pigment(int color, int amount) {
        this.color = color;
        this.amount = amount;
    }

    public static Pigment ofRgb(int color, int amount) {
        return new Pigment(color, amount);
    }

    public boolean isEmpty() {
        return this.amount <= 0 || this.color < 0;
    }

    public int rgb() {
        return this.color();
    }

    public String hex() {
        return String.format("#%06x", this.rgb());
    }

    public String toString() {
        return String.format("Pigment{rgb=%s, amount=%d}", this.hex(), this.amount);
    }

    public float[] hsb() {
        int rgb = this.rgb();
        return Color.RGBtoHSB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb >> 0 & 0xFF, null);
    }

    public Pigment withAmount(int amount) {
        return new Pigment(this.color(), amount);
    }

    public Pigment mix(@Nullable Pigment other) {
        float[] otherHsv;
        if (this.isEmpty()) {
            return other;
        }
        if (other == null || other.isEmpty()) {
            return this;
        }
        int newAmount = this.amount + other.amount;
        if (newAmount > 64) {
            newAmount = 64;
        }
        if (this.color() == other.color()) {
            return new Pigment(this.color(), newAmount);
        }
        float weight = (float)this.amount / (float)newAmount;
        float[] thisHsv = this.hsb();
        float hDelta = Math.abs(thisHsv[0] - (otherHsv = other.hsb())[0]);
        if ((double)hDelta > 0.5) {
            if (thisHsv[0] > otherHsv[0]) {
                otherHsv[0] = otherHsv[0] + 1.0f;
            } else {
                thisHsv[0] = thisHsv[0] + 1.0f;
            }
        }
        float h = weight * thisHsv[0] + (1.0f - weight) * otherHsv[0];
        float s = weight * thisHsv[1] + (1.0f - weight) * otherHsv[1];
        float b = weight * thisHsv[2] + (1.0f - weight) * otherHsv[2];
        int newColor = Color.HSBtoRGB(h, s, b) & 0xFFFFFF;
        return new Pigment(newColor, newAmount);
    }

    public ItemStack asJar() {
        ItemStack stack = ((Item)GAGRegistry.PIGMENT_JAR.get()).getDefaultInstance();
        if (this.isEmpty()) {
            return stack;
        }
        stack.set(GAGRegistry.PIGMENT_DATA, (Object)this);
        return stack;
    }

    public static Pigment forText(DyeColor dye) {
        return new Pigment(dye.getTextColor(), 4);
    }

    public static Pigment forLeather(DyeColor dye) {
        return new Pigment(dye.getTextureDiffuseColor(), 4);
    }

    public int color() {
        return this.color;
    }

    public int amount() {
        return this.amount;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof Pigment) {
            Pigment pigment = (Pigment)other;
            return pigment.color == this.color && pigment.amount == this.amount;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.color, this.amount);
    }
}

