/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.item;

import java.util.List;
import ky.someone.mods.gag.GAGRegistry;
import ky.someone.mods.gag.config.GAGConfig;
import ky.someone.mods.gag.item.GAGItem;
import ky.someone.mods.gag.util.GAGUtil;
import ky.someone.mods.gag.util.Tooltips;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;

public class EscapeRopeItem
extends GAGItem {
    public EscapeRopeItem() {
        super(new Item.Properties().stacksTo(1).durability(GAGConfig.escapeRope.durability()));
    }

    public int getEnchantmentValue() {
        return 1;
    }

    public UseAnim getUseAnimation(ItemStack itemStack) {
        return UseAnim.BOW;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand interactionHand) {
        ItemStack stack = player.getItemInHand(interactionHand);
        player.startUsingItem(interactionHand);
        return InteractionResultHolder.success((Object)stack);
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return GAGConfig.escapeRope.warmup();
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        if (!level.isClientSide && entity instanceof Player) {
            Player player = (Player)entity;
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos pos = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, entity.getOnPos());
            BlockPos teleportPos = null;
            if (pos.getY() > 0) {
                if (pos.getY() >= serverLevel.getLogicalHeight()) {
                    for (BlockPos.MutableBlockPos newPos : BlockPos.spiralAround((BlockPos)new BlockPos(pos.getX(), level.getSeaLevel(), pos.getY()), (int)16, (Direction)Direction.EAST, (Direction)Direction.SOUTH)) {
                        BlockState bs = level.getBlockState((BlockPos)newPos);
                        if (!bs.isCollisionShapeFullBlock((BlockGetter)serverLevel, (BlockPos)newPos) || !level.isEmptyBlock(newPos.above(1)) || !level.isEmptyBlock(newPos.above(2)) || !level.isEmptyBlock(newPos.above(3))) continue;
                        teleportPos = newPos.above();
                        break;
                    }
                } else {
                    teleportPos = pos.above();
                }
            }
            boolean creative = player.isCreative();
            if (teleportPos != null) {
                int durabilityUsed = player.blockPosition().distManhattan((Vec3i)teleportPos);
                int durabilityLeft = stack.getMaxDamage() - stack.getDamageValue();
                if (creative || durabilityUsed <= durabilityLeft) {
                    InteractionHand hand = player.getUsedItemHand();
                    stack.hurtAndBreak(durabilityUsed, (LivingEntity)player, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
                    player.teleportTo((double)teleportPos.getX() + 0.5, (double)teleportPos.getY() + 0.5, (double)teleportPos.getZ() + 0.5);
                    level.playSound(null, teleportPos, (SoundEvent)GAGRegistry.TELEPORT.value(), SoundSource.PLAYERS, 0.5f, 1.0f);
                }
            } else {
                player.sendSystemMessage((Component)Tooltips.FAIL.lang("item.gag.escape_rope.no_space", new Object[0]));
                level.playSound(null, player.blockPosition(), (SoundEvent)GAGRegistry.TELEPORT_FAIL.value(), SoundSource.PLAYERS, 0.6f, 1.0f);
            }
            if (!stack.isEmpty() && !creative) {
                player.getCooldowns().addCooldown(stack.getItem(), GAGConfig.escapeRope.cooldown());
            }
        }
        return stack;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        GAGUtil.appendInfoTooltip(tooltip, List.of(Tooltips.MAIN.lang("item.gag.escape_rope.info", new Object[0]), Tooltips.EXTRA.lang("info.gag.supports_unbreaking", new Object[0])));
    }
}

