/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.client.tooltip;

import java.util.ArrayList;
import java.util.List;
import ky.someone.mods.gag.client.tooltip.HStackClientTooltip;
import ky.someone.mods.gag.client.tooltip.ImageClientTooltip;
import ky.someone.mods.gag.client.tooltip.ItemClientTooltip;
import ky.someone.mods.gag.util.GAGUtil;
import ky.someone.mods.gag.util.VerticalAlignment;
import ky.someone.mods.gag.util.tooltip.ItemTooltipComponent;
import ky.someone.mods.gag.util.tooltip.TooltipSink;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ClientTooltipBuilder
implements TooltipSink {
    private List<ClientTooltipComponent> lines = new ArrayList<ClientTooltipComponent>();
    static final ResourceLocation GENERIC_ARROW = GAGUtil.id("textures/gui/generic_arrow.png");
    private static final ClientTooltipComponent ARROW = new ImageClientTooltip(GENERIC_ARROW, 0, 0, 24, 18, 24, 18, 24, 54);
    private static final ClientTooltipComponent ARROW_EMPTY = new ImageClientTooltip(GENERIC_ARROW, 0, 18, 24, 18, 24, 18, 24, 54);
    private static final ClientTooltipComponent ARROW_FAIL = new ImageClientTooltip(GENERIC_ARROW, 0, 36, 24, 18, 24, 18, 24, 54);

    public ClientTooltipBuilder add(ClientTooltipComponent component) {
        this.lines.add(component);
        return this;
    }

    public ClientTooltipBuilder add(TooltipComponent component) {
        return this.add(ClientTooltipComponent.create((TooltipComponent)component));
    }

    public ClientTooltipBuilder text(FormattedCharSequence text) {
        return this.add(ClientTooltipComponent.create((FormattedCharSequence)text));
    }

    public ClientTooltipBuilder text(Component component) {
        return this.text(component.getVisualOrderText());
    }

    public ClientTooltipBuilder text(String text) {
        return this.text((Component)Component.literal((String)text));
    }

    public ClientTooltipBuilder hstack(List<ClientTooltipComponent> components) {
        return this.hstack(components, 0, VerticalAlignment.TOP);
    }

    public ClientTooltipBuilder hstack(List<ClientTooltipComponent> components, int padding, VerticalAlignment alignment) {
        return this.add(new HStackClientTooltip(components, padding, alignment));
    }

    public ClientTooltipBuilder item(ItemTooltipComponent data) {
        return this.add(new ItemClientTooltip(data));
    }

    public ClientTooltipBuilder item(ItemStack item) {
        return this.item(new ItemTooltipComponent(item));
    }

    public ClientTooltipBuilder item(ItemLike item) {
        return this.item(item.asItem().getDefaultInstance());
    }

    public ClientTooltipBuilder arrow() {
        return this.add(ARROW);
    }

    public ClientTooltipBuilder emptyArrow() {
        return this.add(ARROW_EMPTY);
    }

    public ClientTooltipBuilder failArrow() {
        return this.add(ARROW_FAIL);
    }

    public List<ClientTooltipComponent> build() {
        List<ClientTooltipComponent> list = this.lines;
        this.lines = new ArrayList<ClientTooltipComponent>();
        return list;
    }

    @Override
    public void acceptText(Component text) {
        this.text(text);
    }

    @Override
    public void acceptImage(TooltipComponent image) {
        this.add(image);
    }
}

