/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.client;

import com.google.common.collect.Iterables;
import java.util.List;
import ky.someone.mods.gag.GAGRegistry;
import ky.someone.mods.gag.client.tooltip.ClientTooltipBuilder;
import ky.someone.mods.gag.client.tooltip.EmptyClientTooltip;
import ky.someone.mods.gag.client.tooltip.TimeArrowClientTooltip;
import ky.someone.mods.gag.config.GAGConfig;
import ky.someone.mods.gag.entity.TimeAcceleratorEntity;
import ky.someone.mods.gag.item.GAGItem;
import ky.someone.mods.gag.util.Tooltips;
import ky.someone.mods.gag.util.VerticalAlignment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;

public interface GAGClientEvents {
    @SubscribeEvent
    public static void renderHUD(RenderGuiEvent.Post event) {
        Item item;
        GuiGraphics graphics = event.getGuiGraphics();
        Minecraft mc = Minecraft.getInstance();
        if (mc.options.hideGui || mc.gameMode.getPlayerMode() == GameType.SPECTATOR) {
            return;
        }
        ClientLevel level = mc.level;
        LocalPlayer player = mc.player;
        if (level == null || player == null) {
            return;
        }
        HitResult hitResult = mc.hitResult;
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult blockHit = (BlockHitResult)hitResult;
            BlockPos pos = blockHit.getBlockPos();
            Block block = level.getBlockState(pos).getBlock();
            TimeAcceleratorEntity accelerator = (TimeAcceleratorEntity)((Object)Iterables.getFirst((Iterable)level.getEntitiesOfClass(TimeAcceleratorEntity.class, new AABB(pos)), null));
            if (accelerator != null) {
                int accelSpeed = accelerator.getTimesAccelerated();
                double timeLeft = (double)accelerator.getTicksRemaining() / 20.0;
                if (accelSpeed == 0) {
                    return;
                }
                Component speed = Tooltips.asStyledValue(accelSpeed, GAGConfig.temporalPouch.maxRate(), Integer.toString(1 << accelSpeed));
                MutableComponent text = Tooltips.FLAVOUR.literal("\ud83d\ude80 x").append(speed).append("   ").append("\u23f3 ").append(Tooltips.asStyledValue(timeLeft, GAGConfig.temporalPouch.durationPerUse(), String.format("%.2f", timeLeft))).append("s");
                GAGClientEvents.renderHudTooltip(mc, graphics, new ClientTooltipBuilder().text((Component)block.getName()).hstack(new ClientTooltipBuilder().item((ItemLike)GAGRegistry.TIME_SAND_POUCH).add(new TimeArrowClientTooltip(accelerator)).item((ItemLike)block).build(), 1, VerticalAlignment.CENTER).add(EmptyClientTooltip.y(4)).text((Component)text).build());
                return;
            }
        }
        ItemStack stack = player.getUseItem();
        ClientTooltipBuilder builder = new ClientTooltipBuilder();
        if (!stack.isEmpty() && (item = stack.getItem()) instanceof GAGItem) {
            GAGItem item2 = (GAGItem)item;
            item2.getUsingTooltip((Player)player, stack, player.getTicksUsingItem(), builder);
        } else {
            stack = player.getMainHandItem();
            item = stack.getItem();
            if (item instanceof GAGItem) {
                GAGItem item3 = (GAGItem)item;
                item3.getHoldingTooltip((Player)player, stack, builder);
            } else {
                stack = player.getOffhandItem();
                item = stack.getItem();
                if (item instanceof GAGItem) {
                    GAGItem item4 = (GAGItem)item;
                    item4.getHoldingTooltip((Player)player, stack, builder);
                }
            }
        }
        List<ClientTooltipComponent> tooltip = builder.build();
        if (!tooltip.isEmpty()) {
            GAGClientEvents.renderHudTooltip(mc, graphics, tooltip);
        }
    }

    private static void renderHudTooltip(Minecraft mc, GuiGraphics graphics, List<ClientTooltipComponent> tooltip) {
        if (mc.screen != null) {
            return;
        }
        int x = mc.getWindow().getGuiScaledWidth() / 2;
        int y = mc.getWindow().getGuiScaledHeight() / 2;
        graphics.renderTooltipInternal(mc.font, tooltip, x + 10, y, DefaultTooltipPositioner.INSTANCE);
    }
}

