/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.item;

import com.buuz135.functionalstorage.block.config.FunctionalStorageConfig;
import com.buuz135.functionalstorage.item.FSAttachments;
import com.buuz135.functionalstorage.item.UpgradeItem;
import com.buuz135.functionalstorage.item.component.SizeProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class StorageUpgradeItem
extends UpgradeItem {
    private final StorageTier storageTier;

    public StorageUpgradeItem(StorageTier tier) {
        super(StorageUpgradeItem.getProps(tier), UpgradeItem.Type.STORAGE);
        this.storageTier = tier;
    }

    private static Item.Properties getProps(StorageTier tier) {
        Item.Properties props = new Item.Properties();
        if (tier == StorageTier.IRON) {
            props = props.component(FSAttachments.ITEM_STORAGE_MODIFIER, (Object)new SizeProvider.SetBase(1)).component(FSAttachments.FLUID_STORAGE_MODIFIER, (Object)new SizeProvider.SetBase(1));
        } else {
            float level = FunctionalStorageConfig.getLevelMult(tier.getLevel());
            props = props.component(FSAttachments.ITEM_STORAGE_MODIFIER, (Object)new SizeProvider.ModifyFactor(level)).component(FSAttachments.FLUID_STORAGE_MODIFIER, (Object)new SizeProvider.ModifyFactor(level / (float)FunctionalStorageConfig.FLUID_DIVISOR)).component(FSAttachments.CONTROLLER_RANGE_MODIFIER, (Object)new SizeProvider.ModifyFactor(level / (float)FunctionalStorageConfig.RANGE_DIVISOR));
        }
        return props;
    }

    public boolean isFoil(ItemStack p_41453_) {
        return this.storageTier == StorageTier.MAX_STORAGE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component getName(ItemStack p_41458_) {
        Component component = super.getName(p_41458_);
        if (component instanceof MutableComponent) {
            ((MutableComponent)component).setStyle(Style.EMPTY.withColor(this.storageTier == StorageTier.NETHERITE && Minecraft.getInstance().level != null ? Mth.hsvToRgb((float)((float)(Minecraft.getInstance().level.getGameTime() % 360L) / 360.0f), (float)1.0f, (float)1.0f) : this.storageTier.getColor()));
        }
        return component;
    }

    public static enum StorageTier {
        COPPER(1, Mth.color((float)0.8f, (float)0.42745098f, (float)0.31764707f)),
        GOLD(2, Mth.color((float)0.9137255f, (float)0.69411767f, (float)0.08235294f)),
        DIAMOND(3, Mth.color((float)0.1254902f, (float)0.77254903f, (float)0.70980394f)),
        NETHERITE(4, Mth.color((float)49.0f, (float)41.0f, (float)42.0f)),
        IRON(0, Mth.color((float)0.50980395f, (float)0.50980395f, (float)0.50980395f)),
        MAX_STORAGE(-1, Mth.color((float)0.654902f, (float)0.21176471f, (float)0.96862745f));

        private final int level;
        private final int color;

        private StorageTier(int level, int color) {
            this.level = level;
            this.color = color;
        }

        public int getLevel() {
            return this.level;
        }

        public int getColor() {
            return this.color;
        }
    }
}

