/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftboceanmobs.registry;

import dev.ftb.mods.ftboceanmobs.entity.AbyssalSludge;
import dev.ftb.mods.ftboceanmobs.entity.AbyssalWinged;
import dev.ftb.mods.ftboceanmobs.entity.BaseRiftMob;
import dev.ftb.mods.ftboceanmobs.entity.CorrosiveCraig;
import dev.ftb.mods.ftboceanmobs.entity.MossbackGoliath;
import dev.ftb.mods.ftboceanmobs.entity.RiftDemon;
import dev.ftb.mods.ftboceanmobs.entity.RiftMinotaur;
import dev.ftb.mods.ftboceanmobs.entity.RiftlingObserver;
import dev.ftb.mods.ftboceanmobs.entity.ShadowBeast;
import dev.ftb.mods.ftboceanmobs.entity.Sludgeling;
import dev.ftb.mods.ftboceanmobs.entity.TentacledHorror;
import dev.ftb.mods.ftboceanmobs.entity.TumblingBlockEntity;
import dev.ftb.mods.ftboceanmobs.entity.riftweaver.RiftWeaverBoss;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModEntityTypes {
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"ftboceanmobs");
    public static final Supplier<EntityType<RiftlingObserver>> RIFTLING_OBSERVER = ModEntityTypes.register("riftling_observer", ModEntityTypes::riftlingObserver);
    public static final Supplier<EntityType<AbyssalWinged>> ABYSSAL_WINGED = ModEntityTypes.register("abyssal_winged", ModEntityTypes::abyssalWinged);
    public static final Supplier<EntityType<CorrosiveCraig>> CORROSIVE_CRAIG = ModEntityTypes.register("corrosive_craig", ModEntityTypes::corrosiveCraig);
    public static final Supplier<EntityType<MossbackGoliath>> MOSSBACK_GOLIATH = ModEntityTypes.register("mossback_goliath", ModEntityTypes::mossbackGoliath);
    public static final Supplier<EntityType<AbyssalSludge>> ABYSSAL_SLUDGE = ModEntityTypes.register("abyssal_sludge", ModEntityTypes::abyssalSludge);
    public static final Supplier<EntityType<ShadowBeast>> SHADOW_BEAST = ModEntityTypes.register("shadow_beast", ModEntityTypes::shadowBeast);
    public static final Supplier<EntityType<RiftMinotaur>> RIFT_MINOTAUR = ModEntityTypes.register("rift_minotaur", ModEntityTypes::riftMinotaur);
    public static final Supplier<EntityType<TentacledHorror>> TENTACLED_HORROR = ModEntityTypes.register("tentacled_horror", ModEntityTypes::tentacledHorror);
    public static final Supplier<EntityType<RiftDemon>> RIFT_DEMON = ModEntityTypes.register("rift_demon", ModEntityTypes::riftDemon);
    public static final Supplier<EntityType<RiftWeaverBoss>> RIFT_WEAVER = ModEntityTypes.register("rift_weaver", ModEntityTypes::riftWeaver);
    public static final Supplier<EntityType<Sludgeling>> SLUDGELING = ModEntityTypes.register("sludgeling", ModEntityTypes::sludgeling);
    public static final Supplier<EntityType<TumblingBlockEntity>> TUMBLING_BLOCK = ModEntityTypes.register("tumbling_block", ModEntityTypes::tumblingBlock);
    public static final List<Supplier<? extends EntityType<? extends BaseRiftMob>>> NORMAL_MOBS = List.of(RIFTLING_OBSERVER, ABYSSAL_WINGED, CORROSIVE_CRAIG, MOSSBACK_GOLIATH, ABYSSAL_SLUDGE, SHADOW_BEAST, RIFT_MINOTAUR, TENTACLED_HORROR, RIFT_DEMON);

    public static EntityType<? extends BaseRiftMob> pickRandomMob(RandomSource randomSource) {
        return NORMAL_MOBS.get(randomSource.nextInt(NORMAL_MOBS.size())).get();
    }

    private static <E extends Entity> Supplier<EntityType<E>> register(String name, Supplier<EntityType.Builder<E>> sup) {
        return ENTITY_TYPES.register(name, () -> ((EntityType.Builder)sup.get()).build(name));
    }

    private static EntityType.Builder<RiftlingObserver> riftlingObserver() {
        return EntityType.Builder.of(RiftlingObserver::new, (MobCategory)MobCategory.MONSTER).sized(0.78f, 1.1f).eyeHeight(0.82f).clientTrackingRange(10).updateInterval(2);
    }

    private static EntityType.Builder<AbyssalWinged> abyssalWinged() {
        return EntityType.Builder.of(AbyssalWinged::new, (MobCategory)MobCategory.MONSTER).sized(2.3f, 3.0f).eyeHeight(2.25f).clientTrackingRange(10);
    }

    private static EntityType.Builder<CorrosiveCraig> corrosiveCraig() {
        return EntityType.Builder.of(CorrosiveCraig::new, (MobCategory)MobCategory.MONSTER).sized(1.55f, 3.2f).eyeHeight(2.85f).clientTrackingRange(10).fireImmune();
    }

    private static EntityType.Builder<MossbackGoliath> mossbackGoliath() {
        return EntityType.Builder.of(MossbackGoliath::new, (MobCategory)MobCategory.MONSTER).sized(1.05f, 2.5f).eyeHeight(2.03f).clientTrackingRange(10);
    }

    private static EntityType.Builder<AbyssalSludge> abyssalSludge() {
        return EntityType.Builder.of(AbyssalSludge::new, (MobCategory)MobCategory.MONSTER).sized(1.4f, 2.9f).eyeHeight(2.25f).clientTrackingRange(10);
    }

    private static EntityType.Builder<ShadowBeast> shadowBeast() {
        return EntityType.Builder.of(ShadowBeast::new, (MobCategory)MobCategory.MONSTER).sized(0.75f, 1.25f).eyeHeight(1.08f).clientTrackingRange(10);
    }

    private static EntityType.Builder<RiftMinotaur> riftMinotaur() {
        return EntityType.Builder.of(RiftMinotaur::new, (MobCategory)MobCategory.MONSTER).sized(1.6f, 3.4f).eyeHeight(3.1f).clientTrackingRange(10);
    }

    private static EntityType.Builder<TentacledHorror> tentacledHorror() {
        return EntityType.Builder.of(TentacledHorror::new, (MobCategory)MobCategory.MONSTER).sized(1.7f, 9.0f).eyeHeight(7.1f).clientTrackingRange(10);
    }

    private static EntityType.Builder<RiftDemon> riftDemon() {
        return EntityType.Builder.of(RiftDemon::new, (MobCategory)MobCategory.MONSTER).sized(1.7f, 3.75f).eyeHeight(3.4f).clientTrackingRange(10).fireImmune();
    }

    private static EntityType.Builder<RiftWeaverBoss> riftWeaver() {
        return EntityType.Builder.of(RiftWeaverBoss::new, (MobCategory)MobCategory.MONSTER).sized(8.0f, 15.0f).eyeHeight(15.0f).clientTrackingRange(10).fireImmune();
    }

    private static EntityType.Builder<Sludgeling> sludgeling() {
        return EntityType.Builder.of(Sludgeling::new, (MobCategory)MobCategory.MONSTER).sized(0.52f, 0.52f).eyeHeight(0.325f).clientTrackingRange(10);
    }

    private static EntityType.Builder<TumblingBlockEntity> tumblingBlock() {
        return EntityType.Builder.of(TumblingBlockEntity::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).fireImmune().setTrackingRange(4).setUpdateInterval(20).setShouldReceiveVelocityUpdates(true);
    }
}

