/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbunearthed;

import com.mojang.logging.LogUtils;
import dev.ftb.mods.ftblibrary.FTBLibrary;
import dev.ftb.mods.ftblibrary.config.manager.ConfigManager;
import dev.ftb.mods.ftbunearthed.block.UneartherCoreBlockEntity;
import dev.ftb.mods.ftbunearthed.command.ModCommands;
import dev.ftb.mods.ftbunearthed.config.ClientConfig;
import dev.ftb.mods.ftbunearthed.config.ServerConfig;
import dev.ftb.mods.ftbunearthed.config.StartupConfig;
import dev.ftb.mods.ftbunearthed.crafting.RecipeCaches;
import dev.ftb.mods.ftbunearthed.entity.Worker;
import dev.ftb.mods.ftbunearthed.integration.ultimine.UltimineIntegration;
import dev.ftb.mods.ftbunearthed.item.WorkerToken;
import dev.ftb.mods.ftbunearthed.registry.ModAttachmentTypes;
import dev.ftb.mods.ftbunearthed.registry.ModBlockEntityTypes;
import dev.ftb.mods.ftbunearthed.registry.ModBlocks;
import dev.ftb.mods.ftbunearthed.registry.ModDataComponents;
import dev.ftb.mods.ftbunearthed.registry.ModEntityTypes;
import dev.ftb.mods.ftbunearthed.registry.ModItems;
import dev.ftb.mods.ftbunearthed.registry.ModMenuTypes;
import dev.ftb.mods.ftbunearthed.registry.ModRecipes;
import dev.ftb.mods.ftbunearthed.util.MiscUtil;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.living.LivingConversionEvent;
import net.neoforged.neoforge.event.entity.living.LivingEquipmentChangeEvent;
import org.slf4j.Logger;

@Mod(value="ftbunearthed")
public class FTBUnearthed {
    public static final String MODID = "ftbunearthed";
    public static final Logger LOGGER = LogUtils.getLogger();

    public FTBUnearthed(IEventBus modEventBus) {
        ConfigManager.getInstance().registerStartupConfig(StartupConfig.STARTUP_CONFIG, "ftbunearthed.settings");
        ConfigManager.getInstance().registerServerConfig(ServerConfig.SERVER_CONFIG, "ftbunearthed.server", true);
        ConfigManager.getInstance().registerClientConfig(ClientConfig.CLIENT_CONFIG, "ftbunearthed.client", ClientConfig::onChanged);
        modEventBus.addListener(this::commonSetup);
        this.registerAll(modEventBus);
        modEventBus.addListener(this::addCreative);
        modEventBus.addListener(this::registerCapabilities);
        modEventBus.addListener(this::registerEntityAttributes);
        NeoForge.EVENT_BUS.addListener(this::addReloadListeners);
        NeoForge.EVENT_BUS.addListener(this::onItemEquip);
        NeoForge.EVENT_BUS.addListener(WorkerToken::addTooltip);
        NeoForge.EVENT_BUS.addListener(ModCommands::registerCommands);
        NeoForge.EVENT_BUS.addListener(this::onVillagerConvert);
        UltimineIntegration.init();
    }

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    private void registerAll(IEventBus modEventBus) {
        ModBlocks.BLOCKS.register(modEventBus);
        ModBlockEntityTypes.BLOCK_ENTITY_TYPES.register(modEventBus);
        ModEntityTypes.ENTITY_TYPES.register(modEventBus);
        ModItems.ITEMS.register(modEventBus);
        ModDataComponents.COMPONENTS.register(modEventBus);
        ModMenuTypes.MENU_TYPES.register(modEventBus);
        ModRecipes.RECIPE_SERIALIZERS.register(modEventBus);
        ModRecipes.RECIPE_TYPES.register(modEventBus);
        ModRecipes.RECIPE_CONDITIONS.register(modEventBus);
        ModAttachmentTypes.ATTACHMENT_TYPES.register(modEventBus);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM COMMON SETUP");
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTab() == FTBLibrary.getCreativeModeTab().get()) {
            event.accept((ItemLike)ModBlocks.CORE.asItem());
            event.accept((ItemLike)ModItems.CRUDE_BRUSH.get());
            event.accept((ItemLike)ModItems.REINFORCED_BRUSH.get());
            event.accept((ItemLike)ModItems.UNBREAKABLE_BRUSH.get());
            event.accept((ItemLike)ModItems.ECHO_ENCODER.get());
            BuiltInRegistries.VILLAGER_PROFESSION.forEach(profession -> event.accept(WorkerToken.createWithData(new WorkerToken.WorkerData((VillagerProfession)profession, (VillagerType)ClientConfig.DEFAULT_VILLAGER_TYPE.get()))));
        }
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModBlockEntityTypes.UNEARTHER_CORE.get(), (be, side) -> be.getItemHandler());
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModBlockEntityTypes.UNEARTHER_FRAME.get(), (be, side) -> be.getItemHandler());
    }

    private void addReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new CacheReloadListener());
    }

    private void onItemEquip(LivingEquipmentChangeEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (event.getSlot().getType() == EquipmentSlot.Type.HAND && UneartherCoreBlockEntity.isKnownToolItem(player.level(), event.getTo())) {
                player.displayClientMessage(MiscUtil.formatUneartherLevel((Player)player), true);
            }
        }
    }

    private void registerEntityAttributes(EntityAttributeCreationEvent event) {
        event.put(ModEntityTypes.WORKER.get(), Worker.createAttributes().build());
    }

    private void onVillagerConvert(LivingConversionEvent.Pre event) {
        if (event.getEntity() instanceof Worker && event.getOutcome() == EntityType.WITCH) {
            event.setCanceled(true);
        }
    }

    public static class CacheReloadListener
    implements PreparableReloadListener {
        public CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier stage, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
            return CompletableFuture.runAsync(RecipeCaches::clearAll, gameExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)stage).wait(arg_0));
        }
    }
}

