/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.api;

import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.api.event.TeamEvent;
import dev.ftb.mods.ftbteams.api.event.TeamPropertiesChangedEvent;
import dev.ftb.mods.ftbteams.api.property.TeamProperties;
import dev.ftb.mods.ftbteams.api.property.TeamPropertyCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public class TeamStagesHelper {
    public static boolean addTeamStage(Team team, String stage) {
        return TeamStagesHelper.addTeamStages(team, List.of(stage)) == 1;
    }

    public static int addTeamStages(Team team, Collection<String> stages) {
        return TeamStagesHelper.updateStages(team, stages, true);
    }

    public static boolean removeTeamStage(Team team, String stage) {
        return TeamStagesHelper.removeTeamStages(team, List.of(stage)) == 1;
    }

    public static int removeTeamStages(Team team, Collection<String> stages) {
        return TeamStagesHelper.updateStages(team, stages, false);
    }

    public static boolean hasTeamStage(Team team, String stage) {
        return team.getProperty(TeamProperties.TEAM_STAGES).contains(stage);
    }

    public static Collection<String> getStages(Team team) {
        return Collections.unmodifiableSet(team.getProperty(TeamProperties.TEAM_STAGES));
    }

    private static int updateStages(Team team, Collection<String> stages, boolean adding) {
        Set<String> stageSet = team.getProperty(TeamProperties.TEAM_STAGES);
        int changed = (int)stages.stream().filter(stage -> adding && stageSet.add((String)stage) || !adding && stageSet.remove(stage)).count();
        if (changed > 0) {
            team.setProperty(TeamProperties.TEAM_STAGES, stageSet);
            TeamPropertyCollection old = team.getProperties().copy();
            ((Consumer)TeamEvent.PROPERTIES_CHANGED.invoker()).accept(new TeamPropertiesChangedEvent(team, old));
            team.syncOnePropertyToTeam(TeamProperties.TEAM_STAGES, stageSet);
        }
        return changed;
    }
}

