/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteambases.worldgen.chunkgen;

import com.mojang.serialization.MapCodec;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftbteambases.worldgen.chunkgen.CustomChunkGenerator;
import dev.ftb.mods.ftbteambases.worldgen.chunkgen.VoidChunkGenerator;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.neoforged.neoforge.registries.DeferredRegister;

public enum ChunkGenerators {
    MULTI_BIOME_VOID("void", VoidChunkGenerator::create, VoidChunkGenerator.CODEC),
    CUSTOM("custom", CustomChunkGenerator::create, CustomChunkGenerator.CODEC);

    public static final NameMap<ChunkGenerators> NAME_MAP;
    private final String id;
    private final ChunkGeneratorProvider factory;
    private final MapCodec<? extends ChunkGenerator> codec;

    private ChunkGenerators(String id, ChunkGeneratorProvider factory, MapCodec<? extends ChunkGenerator> codec) {
        this.id = id;
        this.factory = factory;
        this.codec = codec;
    }

    public static void register(DeferredRegister<MapCodec<? extends ChunkGenerator>> chunkGenerators) {
        for (ChunkGenerators gen : ChunkGenerators.values()) {
            chunkGenerators.register(gen.id, () -> gen.codec);
        }
    }

    public String getId() {
        return this.id;
    }

    public MapCodec<? extends ChunkGenerator> getCodec() {
        return this.codec;
    }

    public ChunkGenerator makeGenerator(MinecraftServer server, RegistryAccess registryAccess, ResourceLocation prebuiltStructureId) {
        return this.factory.provide(server, registryAccess, prebuiltStructureId);
    }

    static {
        NAME_MAP = NameMap.of((Object)((Object)MULTI_BIOME_VOID), (Object[])ChunkGenerators.values()).create();
    }

    @FunctionalInterface
    public static interface ChunkGeneratorProvider {
        public ChunkGenerator provide(MinecraftServer var1, RegistryAccess var2, ResourceLocation var3);
    }
}

