/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteambases.util;

import dev.ftb.mods.ftbteambases.FTBTeamBases;
import dev.ftb.mods.ftbteambases.util.RegionCoords;
import dev.ftb.mods.ftbteambases.util.RegionExtents;
import dev.ftb.mods.ftbteambases.util.RegionFileRelocator;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegionFileUtil {
    private static final Pattern MCA_FILE = Pattern.compile("^r\\.(-?\\d+)\\.(-?\\d+)\\.mca$", 2);

    public static Optional<RegionCoords> getRegionCoords(Path file) {
        Matcher m = MCA_FILE.matcher(file.getFileName().toString());
        if (m.matches()) {
            try {
                int rx0 = Integer.parseInt(m.group(1));
                int rz0 = Integer.parseInt(m.group(2));
                return Optional.of(new RegionCoords(rx0, rz0));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    public static Optional<RegionExtents> getRegionExtents(Path dir) {
        Optional<RegionExtents> optional;
        block8: {
            Stream<Path> files = Files.list(dir);
            try {
                MutableInt minX = new MutableInt(Integer.MAX_VALUE);
                MutableInt maxX = new MutableInt(Integer.MIN_VALUE);
                MutableInt minZ = new MutableInt(Integer.MAX_VALUE);
                MutableInt maxZ = new MutableInt(Integer.MIN_VALUE);
                files.forEach(file -> RegionFileUtil.getRegionCoords(file).ifPresent(r -> {
                    minX.setValue(Math.min(r.x(), minX.intValue()));
                    minZ.setValue(Math.min(r.z(), minZ.intValue()));
                    maxX.setValue(Math.max(r.x(), maxX.intValue()));
                    maxZ.setValue(Math.max(r.z(), maxZ.intValue()));
                }));
                optional = Optional.of(new RegionExtents(new RegionCoords(minX.intValue(), minZ.intValue()), new RegionCoords(maxX.intValue(), maxZ.intValue())));
                if (files == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return Optional.empty();
                }
            }
            files.close();
        }
        return optional;
    }

    @NotNull
    public static Path getPregenPath(String templateId, MinecraftServer server, @Nullable String subDir) {
        Path base = server.getServerDirectory().resolve(RegionFileRelocator.PREGEN_PATH).resolve(templateId);
        return subDir == null ? base : base.resolve(subDir);
    }

    public static Path getPathForDimension(MinecraftServer server, ResourceKey<Level> levelKey) {
        Path levelDataDir = server.getWorldPath(LevelResource.ROOT);
        if (Level.OVERWORLD.equals(levelKey)) {
            return levelDataDir;
        }
        if (Level.NETHER.equals(levelKey)) {
            return levelDataDir.resolve("DIM-1");
        }
        if (Level.END.equals(levelKey)) {
            return levelDataDir.resolve("DIM1");
        }
        return levelDataDir.resolve("dimensions").resolve(levelKey.location().getNamespace()).resolve(levelKey.location().getPath());
    }

    @NotNull
    public static Path getPathForDimension(MinecraftServer server, ResourceKey<Level> levelKey, String subDirectory) {
        return RegionFileUtil.getPathForDimension(server, levelKey).resolve(subDirectory);
    }

    public static void copyIfExists(MinecraftServer server, Path pregenDir, ResourceKey<Level> dimensionKey) {
        if (!pregenDir.toFile().isDirectory()) {
            return;
        }
        Path destDir = server.getWorldPath(LevelResource.ROOT).resolve("dimensions").resolve(dimensionKey.location().getNamespace()).resolve(dimensionKey.location().getPath());
        try {
            FileUtils.copyDirectory((File)pregenDir.toFile(), (File)destDir.toFile());
            FTBTeamBases.LOGGER.info("Copied pregen MCA files from {} to {}", (Object)pregenDir, (Object)destDir);
        }
        catch (IOException e) {
            FTBTeamBases.LOGGER.error("Failed to copy pregen MCA files from {} to {}: {}", (Object)pregenDir, (Object)destDir, (Object)e.getMessage());
            e.printStackTrace();
        }
    }
}

