/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteambases.data.construction.workers;

import dev.ftb.mods.ftblibrary.util.BooleanConsumer;
import dev.ftb.mods.ftbteambases.FTBTeamBasesException;
import dev.ftb.mods.ftbteambases.data.construction.ConstructionWorker;
import dev.ftb.mods.ftbteambases.data.definition.BaseDefinition;
import dev.ftb.mods.ftbteambases.data.definition.Pregen;
import dev.ftb.mods.ftbteambases.util.DynamicDimensionManager;
import dev.ftb.mods.ftbteambases.util.RegionExtents;
import dev.ftb.mods.ftbteambases.util.RegionFileUtil;
import java.nio.file.Path;
import java.util.Objects;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;

public class PrivateDimensionPregenWorker
implements ConstructionWorker {
    private final ResourceKey<Level> dimensionKey;
    private final ServerPlayer player;
    private final BaseDefinition baseDefinition;
    private final RegionExtents extents;
    private final Path pregenDir;
    private BooleanConsumer onCompleted;
    private int delayTick = 2;

    public PrivateDimensionPregenWorker(ServerPlayer player, BaseDefinition baseDefinition, Pregen pregen) {
        this.player = player;
        this.baseDefinition = baseDefinition;
        this.dimensionKey = ConstructionWorker.makePrivateDimensionKeyFor(player.getGameProfile().getName().toLowerCase());
        this.pregenDir = RegionFileUtil.getPregenPath(pregen.templateId(), Objects.requireNonNull(player.getServer()), null);
        this.extents = RegionFileUtil.getRegionExtents(this.pregenDir.resolve("region")).orElseThrow(() -> new FTBTeamBasesException("no region files in " + String.valueOf(this.pregenDir)));
    }

    @Override
    public void startConstruction(BooleanConsumer onCompleted) {
        this.onCompleted = onCompleted;
        MinecraftServer server = Objects.requireNonNull(this.player.getServer());
        RegionFileUtil.copyIfExists(this.player.server, this.pregenDir, this.dimensionKey);
        DynamicDimensionManager.create(server, this.dimensionKey, this.baseDefinition);
    }

    @Override
    public RegionExtents getRegionExtents() {
        return this.extents;
    }

    @Override
    public ResourceKey<Level> getDimension() {
        return this.dimensionKey;
    }

    @Override
    public void tick() {
        if (--this.delayTick <= 0) {
            this.onCompleted.accept(true);
        }
    }
}

