/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteambases.data.construction;

import dev.ftb.mods.ftbteambases.FTBTeamBases;
import dev.ftb.mods.ftbteambases.FTBTeamBasesException;
import dev.ftb.mods.ftbteambases.data.bases.BaseInstanceManager;
import dev.ftb.mods.ftbteambases.data.construction.ConstructionWorker;
import dev.ftb.mods.ftbteambases.data.definition.BaseDefinition;
import dev.ftb.mods.ftbteambases.events.BaseCreatedEvent;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.data.PlayerTeam;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;

public class BaseConstructionAgent {
    private final BaseDefinition baseDefinition;
    private final UUID playerId;
    private final ConstructionWorker constructionWorker;
    private boolean done = false;
    private final MinecraftServer server;

    public BaseConstructionAgent(ServerPlayer player, BaseDefinition baseDefinition) {
        this.baseDefinition = baseDefinition;
        this.playerId = player.getUUID();
        this.server = player.getServer();
        try {
            this.constructionWorker = baseDefinition.createConstructionWorker(player);
            this.constructionWorker.startConstruction(this::onCompleted);
        }
        catch (IOException e) {
            throw new FTBTeamBasesException("failed to create construction worker", e);
        }
    }

    private void onCompleted(boolean success) {
        this.done = true;
        if (this.server != null && success) {
            ServerLevel destLevel = this.server.getLevel(this.constructionWorker.getDimension());
            if (destLevel == null) {
                FTBTeamBases.LOGGER.error("dest dimension {} doesn't exist?!", this.constructionWorker.getDimension());
                return;
            }
            ServerPlayer player = this.server.getPlayerList().getPlayer(this.playerId);
            FTBTeamsAPI.api().getManager().getTeamForPlayerID(this.playerId).ifPresent(arg_0 -> this.lambda$onCompleted$0((Level)destLevel, player, arg_0));
        }
    }

    public boolean isDone() {
        return this.done;
    }

    public void tick() {
        this.constructionWorker.tick();
    }

    private /* synthetic */ void lambda$onCompleted$0(Level destLevel, ServerPlayer player, Team team) {
        if (team instanceof PlayerTeam) {
            PlayerTeam playerTeam = (PlayerTeam)team;
            try {
                Team party = playerTeam.createParty("", null);
                BaseInstanceManager.get(this.server).addNewBase(party.getId(), this.constructionWorker.makeLiveBaseDetails(destLevel, this.baseDefinition));
                BaseInstanceManager.get(this.server).forceSave(this.server);
                if (player != null) {
                    BaseInstanceManager.get(this.server).teleportToBaseSpawn(player, party.getId());
                }
                FTBTeamBases.LOGGER.info("team base created for player id {}, party id = {}, dim id = {}, type = {}", (Object)this.playerId, (Object)party.getId(), (Object)destLevel.dimension().location(), (Object)this.baseDefinition.id());
                ((BaseCreatedEvent)BaseCreatedEvent.CREATED.invoker()).created(BaseInstanceManager.get(this.server), player, party);
            }
            catch (IllegalStateException e) {
                if (player != null) {
                    player.displayClientMessage((Component)Component.literal((String)("can't create party team for you! " + e.getMessage())), false);
                }
                FTBTeamBases.LOGGER.error("can't create party team for player {}: {}", (Object)this.playerId, (Object)e.getMessage());
            }
        }
    }
}

