/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteambases.config;

import dev.ftb.mods.ftblibrary.config.NameMap;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.ChunkPos;

public enum AutoClaimShape {
    SQUARE("square"),
    CIRCLE("circle");

    public static final NameMap<AutoClaimShape> NAME_MAP;
    private final String shape;

    private AutoClaimShape(String id) {
        this.shape = id;
    }

    public String getId() {
        return this.shape;
    }

    public void forEachChunk(ChunkPos origin, int radius, Consumer<ChunkPos> consumer) {
        BlockPos pos0 = origin.getMiddleBlockPosition(0);
        int blockRadiusSq = (radius << 4) * (radius << 4);
        switch (radius) {
            case 0: {
                break;
            }
            case 1: {
                consumer.accept(origin);
                break;
            }
            default: {
                int r = radius - 1;
                for (int cx = origin.x - r; cx <= origin.x + r; ++cx) {
                    for (int cz = origin.z - r; cz <= origin.z + r; ++cz) {
                        ChunkPos cp = new ChunkPos(cx, cz);
                        if (this != SQUARE && !(cp.getMiddleBlockPosition(0).distSqr((Vec3i)pos0) < (double)blockRadiusSq)) continue;
                        consumer.accept(cp);
                    }
                }
            }
        }
    }

    static {
        NAME_MAP = NameMap.of((Object)((Object)SQUARE), (Object[])AutoClaimShape.values()).id(AutoClaimShape::getId).create();
    }
}

