/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteambases.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.ftb.mods.ftbteambases.command.CommandUtils;
import dev.ftb.mods.ftbteambases.data.bases.ArchivedBaseDetails;
import dev.ftb.mods.ftbteambases.data.bases.BaseInstanceManager;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.api.TeamManager;
import java.text.DateFormat;
import java.time.Instant;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.players.PlayerList;

public class ArchiveCommand {
    private static final GameProfile UNKNOWN = new GameProfile(Util.NIL_UUID, "???");

    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"archive").requires(ctx -> ctx.hasPermission(2))).then(Commands.literal((String)"list").executes(ctx -> ArchiveCommand.doListArchive((CommandSourceStack)ctx.getSource(), (ArchivedBaseDetails base) -> true)))).then(Commands.literal((String)"list_for").then(Commands.argument((String)"owner", (ArgumentType)GameProfileArgument.gameProfile()).suggests((ctx, builder) -> {
            PlayerList playerlist = ((CommandSourceStack)ctx.getSource()).getServer().getPlayerList();
            return SharedSuggestionProvider.suggest(playerlist.getPlayers().stream().filter(p -> !playerlist.isOp(p.getGameProfile())).map(p -> p.getGameProfile().getName()), (SuggestionsBuilder)builder);
        }).executes(ctx -> ArchiveCommand.doListArchive((CommandSourceStack)ctx.getSource(), GameProfileArgument.getGameProfiles((CommandContext)ctx, (String)"owner")))))).then(Commands.literal((String)"restore").then(Commands.argument((String)"id", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> CommandUtils.suggestArchivedBases(builder)).executes(ctx -> ArchiveCommand.doRestoreArchive((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"id")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"purge").then(Commands.literal((String)"-older").then(Commands.argument((String)"min_age_in_days", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> ArchiveCommand.doPurgeArchive((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"min_age_in_days")))))).then(Commands.literal((String)"-id").then(Commands.argument((String)"id", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> CommandUtils.suggestArchivedBases(builder)).executes(ctx -> ArchiveCommand.doPurgeArchive((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"id"))))))).then(Commands.literal((String)"cleanup").executes(ctx -> ArchiveCommand.doCleanup((CommandSourceStack)ctx.getSource())));
    }

    private static int doCleanup(CommandSourceStack source) {
        BaseInstanceManager mgr = BaseInstanceManager.get(source.getServer());
        TeamManager teamManager = FTBTeamsAPI.api().getManager();
        HashSet toCleanup = new HashSet();
        mgr.allLiveBases().forEach((id, details) -> {
            if (teamManager.getTeamByID(id).isEmpty()) {
                toCleanup.add(id);
            }
        });
        toCleanup.forEach(mgr::deleteStaleBase);
        source.sendSuccess(() -> Component.translatable((String)"ftbteambases.message.stale_bases", (Object[])new Object[]{toCleanup.size()}).withStyle(ChatFormatting.YELLOW), false);
        return 1;
    }

    private static int doListArchive(CommandSourceStack source, Predicate<ArchivedBaseDetails> pred) {
        List<ArchivedBaseDetails> bases = BaseInstanceManager.get(source.getServer()).getArchivedBases().stream().filter(pred).sorted(Comparator.comparingLong(ArchivedBaseDetails::archiveTime)).toList();
        if (bases.isEmpty()) {
            source.sendSuccess(() -> Component.translatable((String)"ftbteambases.message.no_archived_bases").withStyle(ChatFormatting.GOLD), false);
        } else {
            source.sendSuccess(() -> Component.translatable((String)"ftbteambases.message.archived_bases", (Object[])new Object[]{bases.size()}).withStyle(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.UNDERLINE}), false);
            source.sendSuccess(Component::empty, false);
            bases.forEach(base -> {
                String playerName = source.getServer().getProfileCache().get(base.ownerId()).orElse(UNKNOWN).getName();
                String when = DateFormat.getDateTimeInstance(3, 3).format(Date.from(Instant.ofEpochMilli(base.archiveTime())));
                boolean isOwnerInParty = FTBTeamsAPI.api().getManager().getTeamForPlayerID(base.ownerId()).map(Team::isPlayerTeam).orElse(false);
                Component player = CommandUtils.makeTooltipComponent((Component)Component.literal((String)playerName), ChatFormatting.YELLOW, base.ownerId().toString());
                Component restore = CommandUtils.makeCommandClicky("ftbteambases.gui.restore", isOwnerInParty ? ChatFormatting.GREEN : ChatFormatting.GRAY, "/ftbteambases archive restore " + base.archiveId());
                Component purge = CommandUtils.makeCommandClicky("ftbteambases.gui.purge", ChatFormatting.RED, "/ftbteambases purge id " + base.archiveId(), true);
                source.sendSuccess(() -> Component.literal((String)"\u2022 ").append((Component)Component.literal((String)base.archiveId()).withStyle(ChatFormatting.AQUA)).append(" : ").append(player).append(" (").append((Component)Component.literal((String)when)).append(")").append("  ").append(restore).append("  ").append(purge), false);
            });
        }
        return 1;
    }

    private static int doListArchive(CommandSourceStack source, Collection<GameProfile> profiles) {
        Set ids = profiles.stream().map(GameProfile::getId).collect(Collectors.toSet());
        return ArchiveCommand.doListArchive(source, (ArchivedBaseDetails base) -> ids.contains(base.ownerId()));
    }

    private static int doRestoreArchive(CommandSourceStack source, String archiveName) throws CommandSyntaxException {
        BaseInstanceManager mgr = BaseInstanceManager.get(source.getServer());
        ArchivedBaseDetails archivedBase = mgr.getArchivedBase(archiveName).orElseThrow(() -> CommandUtils.ARCHIVE_NOT_FOUND.create((Object)archiveName));
        mgr.unarchiveBase(source.getServer(), archivedBase);
        source.sendSuccess(() -> Component.translatable((String)"ftbteambases.message.restored", (Object[])new Object[]{archivedBase.archiveId()}), false);
        return 1;
    }

    private static int doPurgeArchive(CommandSourceStack source, int minAgeInDays) {
        source.sendSuccess(() -> Component.literal((String)"not implemented yet!"), false);
        return 0;
    }

    private static int doPurgeArchive(CommandSourceStack source, String baseId) {
        source.sendSuccess(() -> Component.literal((String)"not implemented yet!"), false);
        return 0;
    }
}

