/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.util.lootsummary;

import dev.ftb.mods.ftbstuffnthings.FTBStuffNThings;
import dev.ftb.mods.ftbstuffnthings.util.lootsummary.LootSummary;
import dev.ftb.mods.ftbstuffnthings.util.lootsummary.WrappedLootSummary;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class LootSummaryCollection {
    private static final LootSummaryCollection EMPTY_COLLECTION = new LootSummaryCollection(Map.of(), Map.of());
    private static final Map<Integer, List<WrappedLootSummary>> item2summaryCache = new HashMap<Integer, List<WrappedLootSummary>>();
    private static LootSummaryCollection CLIENT_SUMMARY = EMPTY_COLLECTION;
    private static final StreamCodec<FriendlyByteBuf, ResourceKey<?>> RESOURCE_KEY_STREAM_CODEC = StreamCodec.of((buffer, value) -> {
        buffer.writeResourceLocation(value.registry());
        buffer.writeResourceLocation(value.location());
    }, buffer -> LootSummaryCollection.createKey(buffer.readResourceLocation(), buffer.readResourceLocation()));
    public static final StreamCodec<RegistryFriendlyByteBuf, LootSummaryCollection> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.map(HashMap::new, (StreamCodec)ByteBufCodecs.INT, LootSummary.STREAM_CODEC), v -> v.summaries, (StreamCodec)ByteBufCodecs.map(HashMap::new, (StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.BLOCK), (StreamCodec)ByteBufCodecs.INT), v -> v.item2summary, LootSummaryCollection::new);
    private final Map<Integer, LootSummary> summaries;
    private final Map<ResourceKey<Block>, Integer> item2summary;

    private LootSummaryCollection(Map<Integer, LootSummary> summaries, Map<ResourceKey<Block>, Integer> item2summary) {
        this.summaries = summaries;
        this.item2summary = item2summary;
    }

    public LootSummaryCollection() {
        this(new HashMap<Integer, LootSummary>(), new HashMap<ResourceKey<Block>, Integer>());
    }

    public void addEntry(ResourceKey<Block> key, ResourceLocation tableId, LootParams lootParams) {
        ResourceKey tableKey = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)tableId);
        LootTable lootTable = lootParams.getLevel().getServer().reloadableRegistries().getLootTable(tableKey);
        LootSummary summary = LootSummary.forLootTable(lootTable, lootParams);
        this.summaries.put(summary.hashCode(), summary);
        this.item2summary.put(key, summary.hashCode());
    }

    private static LootParams makeBlockParams(ServerPlayer serverPlayer, BlockState state) {
        return new LootParams.Builder(serverPlayer.serverLevel()).withParameter(LootContextParams.BLOCK_STATE, (Object)state).withParameter(LootContextParams.ORIGIN, (Object)Vec3.ZERO).withParameter(LootContextParams.TOOL, (Object)Items.DIAMOND_PICKAXE.getDefaultInstance()).withOptionalParameter(LootContextParams.THIS_ENTITY, (Object)serverPlayer).create(LootContextParamSets.BLOCK);
    }

    public static void syncFromServer(LootSummaryCollection summary) {
        CLIENT_SUMMARY = summary;
        item2summaryCache.clear();
        FTBStuffNThings.LOGGER.info("received loot summary data from server: {} items, {} unique tables", (Object)LootSummaryCollection.CLIENT_SUMMARY.item2summary.size(), (Object)LootSummaryCollection.CLIENT_SUMMARY.summaries.size());
    }

    public static LootSummaryCollection getClientSummary() {
        return CLIENT_SUMMARY;
    }

    private static <T> ResourceKey<T> createKey(ResourceLocation reg, ResourceLocation loc) {
        ResourceKey key = ResourceKey.createRegistryKey((ResourceLocation)reg);
        return ResourceKey.create((ResourceKey)key, (ResourceLocation)loc);
    }

    public Optional<LootSummary> getLootSummaryForInput(Block block) {
        return BuiltInRegistries.BLOCK.getResourceKey((Object)block).map(this::getLootSummaryForInput);
    }

    private LootSummary getLootSummaryForInput(ResourceKey<Block> key) {
        return this.item2summary.containsKey(key) ? this.summaries.get(this.item2summary.get(key)) : null;
    }

    public List<WrappedLootSummary> getLootSummariesForOutput(ItemStack stack) {
        int hash = ItemStack.hashItemAndComponents((ItemStack)stack);
        return item2summaryCache.computeIfAbsent(hash, k -> {
            ArrayList<WrappedLootSummary> res = new ArrayList<WrappedLootSummary>();
            for (ResourceKey<Block> key : this.item2summary.keySet()) {
                LootSummary summary = this.summaries.get(this.item2summary.get(key));
                for (Map.Entry<String, List<LootSummary.SummaryEntry>> e : summary.entryMap().entrySet()) {
                    for (LootSummary.SummaryEntry entry : e.getValue()) {
                        if (!stack.isEmpty() && !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)entry.stack())) continue;
                        res.add(WrappedLootSummary.create(key, summary));
                    }
                }
            }
            return List.copyOf(res);
        });
    }
}

