/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.integration.wallalike;

import dev.ftb.mods.ftbstuffnthings.FTBStuffNThings;
import dev.ftb.mods.ftbstuffnthings.blocks.hammer.AutoHammerBlockEntity;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;

enum AutoHammerComponentProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;

    private static final ResourceLocation ID;
    private static final Component WAITING;
    private static final Component RUNNING;

    public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
        ITooltip tooltip;
        CompoundTag serverData = blockAccessor.getServerData();
        if (!serverData.contains("progress")) {
            return;
        }
        IElementHelper helper = IElementHelper.get();
        int timeout = serverData.getInt("timeout");
        int maxTimeout = serverData.getInt("maxTimeout");
        if (maxTimeout == 0) {
            progress = (float)serverData.getInt("progress") / (float)serverData.getInt("maxProgress");
            iTooltip.add(helper.progress(progress, RUNNING, helper.progressStyle().color(-1392443648), BoxStyle.getNestedBox(), false));
        } else {
            progress = (float)timeout / (float)maxTimeout;
            iTooltip.add(helper.progress(progress, WAITING, helper.progressStyle().color(-1375797248), BoxStyle.getNestedBox(), true));
        }
        ItemStack processingStack = ItemStack.OPTIONAL_CODEC.parse(blockAccessor.nbtOps(), (Object)serverData.getCompound("processing")).result().orElse(ItemStack.EMPTY);
        ArrayList outputItems = new ArrayList();
        if (serverData.contains("output")) {
            ListTag items = serverData.getList("output", 10);
            items.forEach(tag -> ItemStack.OPTIONAL_CODEC.parse(blockAccessor.nbtOps(), tag).result().ifPresent(outputItems::add));
        }
        if (!processingStack.isEmpty()) {
            iTooltip.add(helper.item(processingStack));
            tooltip = helper.tooltip();
            tooltip.append((IElement)helper.text((Component)Component.translatable((String)"ftbstuff.jade.processing")));
            iTooltip.append(helper.box(tooltip, (BoxStyle)BoxStyle.getTransparent()).align(IElement.Align.RIGHT));
        }
        if (!outputItems.isEmpty()) {
            iTooltip.add(helper.spacer(-5, 0));
            tooltip = helper.tooltip();
            int count = 0;
            float scale = outputItems.size() > 5 ? 0.8f : 1.0f;
            for (ItemStack outputItem : outputItems) {
                if (count != 0 && count % 5 == 0) {
                    tooltip.add(helper.item(outputItem, scale));
                    count = 0;
                    continue;
                }
                tooltip.append(helper.item(outputItem, scale));
                ++count;
            }
            iTooltip.append((IElement)helper.box(tooltip, (BoxStyle)BoxStyle.getTransparent()));
            ITooltip text = helper.tooltip();
            text.append((IElement)helper.text((Component)Component.translatable((String)"ftbstuff.jade.buffer")));
            iTooltip.append(helper.box(text, (BoxStyle)BoxStyle.getTransparent()).align(IElement.Align.RIGHT));
        }
    }

    public void appendServerData(CompoundTag compoundTag, BlockAccessor blockAccessor) {
        BlockEntity blockEntity = blockAccessor.getBlockEntity();
        if (!(blockEntity instanceof AutoHammerBlockEntity)) {
            return;
        }
        AutoHammerBlockEntity autoHammerEntity = (AutoHammerBlockEntity)blockEntity;
        compoundTag.putInt("progress", autoHammerEntity.getProgress());
        compoundTag.putInt("maxProgress", autoHammerEntity.getMaxProgress());
        compoundTag.putInt("timeout", autoHammerEntity.getTimeout());
        compoundTag.putInt("maxTimeout", autoHammerEntity.getMaxTimeout());
        ItemStack.OPTIONAL_CODEC.encodeStart(blockAccessor.nbtOps(), (Object)autoHammerEntity.getProcessingStack()).result().ifPresent(tag -> compoundTag.put("processing", tag));
        ListTag tagItems = new ListTag();
        autoHammerEntity.getOverflow().forEach(stack -> ItemStack.OPTIONAL_CODEC.encodeStart(blockAccessor.nbtOps(), stack).result().ifPresent(arg_0 -> tagItems.add(arg_0)));
        compoundTag.put("output", (Tag)tagItems);
    }

    public ResourceLocation getUid() {
        return ID;
    }

    static {
        ID = FTBStuffNThings.id("autohammer");
        WAITING = Component.literal((String)" ").append((Component)Component.translatable((String)"ftbstuff.autohammer.waiting").withStyle(ChatFormatting.WHITE));
        RUNNING = Component.literal((String)" ").append((Component)Component.translatable((String)"ftbstuff.autohammer.running").withStyle(ChatFormatting.WHITE));
    }
}

