/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.crafting.recipe;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.ftb.mods.ftbstuffnthings.crafting.IHideableRecipe;
import dev.ftb.mods.ftbstuffnthings.crafting.NoInventory;
import dev.ftb.mods.ftbstuffnthings.registry.RecipesRegistry;
import dev.ftb.mods.ftbstuffnthings.temperature.Temperature;
import dev.ftb.mods.ftbstuffnthings.temperature.TemperatureAndEfficiency;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import org.jetbrains.annotations.NotNull;

public class TemperatureSourceRecipe
implements Recipe<NoInventory>,
IHideableRecipe {
    private final String blockStateStr;
    private final BlockState blockState;
    private final TemperatureAndEfficiency temperatureAndEfficiency;
    private final ItemStack stack;
    private final boolean hideFromJEI;
    private final Map<String, String> predicates;

    public TemperatureSourceRecipe(String blockStateStr, Temperature temperature, double efficiency, ItemStack stack, boolean hideFromJEI) {
        this.temperatureAndEfficiency = new TemperatureAndEfficiency(temperature, efficiency);
        this.stack = stack;
        this.hideFromJEI = hideFromJEI;
        this.blockStateStr = blockStateStr;
        try {
            this.blockState = BlockStateParser.parseForBlock((HolderLookup)BuiltInRegistries.BLOCK.asLookup(), (String)blockStateStr, (boolean)false).blockState();
        }
        catch (CommandSyntaxException e) {
            throw new IllegalArgumentException("invalid blockstate: " + blockStateStr);
        }
        this.predicates = TemperatureSourceRecipe.extractPredicates(blockStateStr);
    }

    private static Map<String, String> extractPredicates(String blockStateStr) {
        HashMap<String, String> res = new HashMap<String, String>();
        int l = blockStateStr.indexOf(91);
        if (l > 0) {
            String[] preds;
            for (String pred : preds = blockStateStr.substring(l + 1, blockStateStr.length() - 1).split(",")) {
                String[] parts = pred.split("=");
                res.put(parts[0], parts[1]);
            }
        }
        return res;
    }

    @NotNull
    public static List<TemperatureSourceRecipe> sortRecipes(List<TemperatureSourceRecipe> l) {
        return l.stream().sorted(Comparator.comparing(TemperatureSourceRecipe::getTemperature).thenComparing(TemperatureSourceRecipe::getEfficiency).thenComparing(r -> r.getDisplayStack().getHoverName().getString())).toList();
    }

    public boolean matches(NoInventory input, Level level) {
        return true;
    }

    public ItemStack assemble(NoInventory input, HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return RecipesRegistry.TEMPERATURE_SOURCE_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return RecipesRegistry.TEMPERATURE_SOURCE_TYPE.get();
    }

    public BlockState getBlockState() {
        return this.blockState;
    }

    public Temperature getTemperature() {
        return this.temperatureAndEfficiency.temperature();
    }

    public double getEfficiency() {
        return this.temperatureAndEfficiency.efficiency();
    }

    public ItemStack getDisplayStack() {
        return this.stack.isEmpty() ? new ItemStack((ItemLike)this.blockState.getBlock()) : this.stack;
    }

    public boolean hideFromJEI() {
        return this.hideFromJEI;
    }

    public TemperatureAndEfficiency getTemperatureAndEfficiency() {
        return this.temperatureAndEfficiency;
    }

    @Override
    public boolean shouldShowRecipe() {
        return !this.hideFromJEI;
    }

    private String getBlockStateStr() {
        return this.blockStateStr;
    }

    public boolean test(BlockState state) {
        if (this.blockState.getBlock() == Blocks.AIR || this.blockState.getBlock() != state.getBlock()) {
            return false;
        }
        for (Map.Entry<String, String> entry : this.predicates.entrySet()) {
            Property prop = state.getBlock().getStateDefinition().getProperty(entry.getKey());
            if (prop == null) {
                return false;
            }
            Object val = prop.getValue(entry.getValue()).orElse(null);
            if (val != null && state.getValue(prop) == val) continue;
            return false;
        }
        return true;
    }

    public static class Serializer<T extends TemperatureSourceRecipe>
    implements RecipeSerializer<T> {
        private final MapCodec<T> codec = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.STRING.fieldOf("blockstate").forGetter(TemperatureSourceRecipe::getBlockStateStr), (App)StringRepresentable.fromEnum(Temperature::values).optionalFieldOf("temperature", (Object)Temperature.NORMAL).forGetter(TemperatureSourceRecipe::getTemperature), (App)Codec.DOUBLE.optionalFieldOf("efficiency", (Object)1.0).forGetter(TemperatureSourceRecipe::getEfficiency), (App)ItemStack.OPTIONAL_CODEC.optionalFieldOf("display_item", (Object)ItemStack.EMPTY).forGetter(TemperatureSourceRecipe::getDisplayStack), (App)Codec.BOOL.optionalFieldOf("hide_from_jei", (Object)false).forGetter(TemperatureSourceRecipe::hideFromJEI)).apply((Applicative)builder, factory::create));
        private final StreamCodec<RegistryFriendlyByteBuf, T> streamCodec = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, TemperatureSourceRecipe::getBlockStateStr, (StreamCodec)NeoForgeStreamCodecs.enumCodec(Temperature.class), TemperatureSourceRecipe::getTemperature, (StreamCodec)ByteBufCodecs.DOUBLE, TemperatureSourceRecipe::getEfficiency, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, TemperatureSourceRecipe::getDisplayStack, (StreamCodec)ByteBufCodecs.BOOL, TemperatureSourceRecipe::hideFromJEI, factory::create);

        public Serializer(IFactory<T> factory) {
        }

        public MapCodec<T> codec() {
            return this.codec;
        }

        public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
            return this.streamCodec;
        }
    }

    public static interface IFactory<T extends TemperatureSourceRecipe> {
        public T create(String var1, Temperature var2, double var3, ItemStack var5, boolean var6);
    }
}

