/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexMultiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.joml.Matrix4f;

public class RenderUtil {
    public static void renderFluid3d(FluidBounds fluidBounds, FluidTank tank, MultiBufferSource bufferSource, Matrix4f posMat, int packedLight, int packedOverlay) {
        if (tank.isEmpty()) {
            return;
        }
        FluidStack fluid = tank.getFluid();
        IClientFluidTypeExtensions renderProps = IClientFluidTypeExtensions.of((FluidType)fluid.getFluidType());
        ResourceLocation texture = renderProps.getStillTexture(fluid);
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(texture);
        VertexConsumer builder = bufferSource.getBuffer(RenderType.entityTranslucentCull((ResourceLocation)InventoryMenu.BLOCK_ATLAS));
        int color = renderProps.getTintColor(fluid);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = 1.0f;
        float s0 = fluidBounds.horizontalInset();
        float s1 = 1.0f - s0;
        float y0 = fluidBounds.minY();
        float y1 = y0 + (float)tank.getFluidAmount() / (float)tank.getCapacity() * fluidBounds.yHeight();
        float u0 = sprite.getU(fluidBounds.horizontalInset());
        float v0 = sprite.getV0();
        float u1 = sprite.getU(1.0f - fluidBounds.horizontalInset());
        float v1 = sprite.getV(y1);
        float u0top = sprite.getU(fluidBounds.horizontalInset());
        float v0top = sprite.getV(fluidBounds.horizontalInset());
        float u1top = sprite.getU(1.0f - fluidBounds.horizontalInset());
        float v1top = sprite.getV(1.0f - fluidBounds.horizontalInset());
        builder.addVertex(posMat, s0, y1, s0).setColor(r, g, b, a).setUv(u0top, v0top).setOverlay(packedOverlay).setLight(packedLight).setNormal(0.0f, 1.0f, 0.0f);
        builder.addVertex(posMat, s0, y1, s1).setColor(r, g, b, a).setUv(u0top, v1top).setOverlay(packedOverlay).setLight(packedLight).setNormal(0.0f, 1.0f, 0.0f);
        builder.addVertex(posMat, s1, y1, s1).setColor(r, g, b, a).setUv(u1top, v1top).setOverlay(packedOverlay).setLight(packedLight).setNormal(0.0f, 1.0f, 0.0f);
        builder.addVertex(posMat, s1, y1, s0).setColor(r, g, b, a).setUv(u1top, v0top).setOverlay(packedOverlay).setLight(packedLight).setNormal(0.0f, 1.0f, 0.0f);
        builder.addVertex(posMat, s0, y1, s1).setColor(r, g, b, a).setUv(u0, v0).setOverlay(packedOverlay).setLight(packedLight).setNormal(0.0f, 0.0f, 1.0f);
        builder.addVertex(posMat, s0, y0, s1).setColor(r, g, b, a).setUv(u0, v1).setOverlay(packedOverlay).setLight(packedLight).setNormal(0.0f, 1.0f, 0.0f);
        builder.addVertex(posMat, s1, y0, s1).setColor(r, g, b, a).setUv(u1, v1).setOverlay(packedOverlay).setLight(packedLight).setNormal(0.0f, 0.0f, 1.0f);
        builder.addVertex(posMat, s1, y1, s1).setColor(r, g, b, a).setUv(u1, v0).setOverlay(packedOverlay).setLight(packedLight).setNormal(0.0f, 0.0f, 1.0f);
        builder.addVertex(posMat, s0, y1, s0).setColor(r, g, b, a).setUv(u0, v0).setOverlay(packedOverlay).setLight(packedLight).setNormal(0.0f, 0.0f, -1.0f);
        builder.addVertex(posMat, s1, y1, s0).setColor(r, g, b, a).setUv(u1, v0).setOverlay(packedOverlay).setLight(packedLight).setNormal(0.0f, 0.0f, -1.0f);
        builder.addVertex(posMat, s1, y0, s0).setColor(r, g, b, a).setUv(u1, v1).setOverlay(packedOverlay).setLight(packedLight).setNormal(0.0f, 0.0f, -1.0f);
        builder.addVertex(posMat, s0, y0, s0).setColor(r, g, b, a).setUv(u0, v1).setOverlay(packedOverlay).setLight(packedLight).setNormal(0.0f, 0.0f, -1.0f);
        builder.addVertex(posMat, s0, y1, s0).setColor(r, g, b, a).setUv(u0, v0).setOverlay(packedOverlay).setLight(packedLight).setNormal(-1.0f, 0.0f, 0.0f);
        builder.addVertex(posMat, s0, y0, s0).setColor(r, g, b, a).setUv(u0, v1).setOverlay(packedOverlay).setLight(packedLight).setNormal(1.0f, 0.0f, 0.0f);
        builder.addVertex(posMat, s0, y0, s1).setColor(r, g, b, a).setUv(u1, v1).setOverlay(packedOverlay).setLight(packedLight).setNormal(1.0f, 0.0f, 0.0f);
        builder.addVertex(posMat, s0, y1, s1).setColor(r, g, b, a).setUv(u1, v0).setOverlay(packedOverlay).setLight(packedLight).setNormal(1.0f, 0.0f, 0.0f);
        builder.addVertex(posMat, s1, y1, s0).setColor(r, g, b, a).setUv(u0, v0).setOverlay(packedOverlay).setLight(packedLight).setNormal(1.0f, 0.0f, 0.0f);
        builder.addVertex(posMat, s1, y1, s1).setColor(r, g, b, a).setUv(u1, v0).setOverlay(packedOverlay).setLight(packedLight).setNormal(1.0f, 0.0f, 0.0f);
        builder.addVertex(posMat, s1, y0, s1).setColor(r, g, b, a).setUv(u1, v1).setOverlay(packedOverlay).setLight(packedLight).setNormal(1.0f, 0.0f, 0.0f);
        builder.addVertex(posMat, s1, y0, s0).setColor(r, g, b, a).setUv(u0, v1).setOverlay(packedOverlay).setLight(packedLight).setNormal(1.0f, 0.0f, 0.0f);
    }

    public static void renderBlock(PoseStack poseStack, MultiBufferSource bufferSource, int combinedLightIn, int combinedOverlayIn, ItemStack stack, int breakProgress) {
        Item item;
        if (!stack.isEmpty() && (item = stack.getItem()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            poseStack.scale(0.25f, 0.25f, 0.25f);
            SheetedDecalTextureGenerator vertexconsumer = new SheetedDecalTextureGenerator(bufferSource.getBuffer((RenderType)ModelBakery.DESTROY_TYPES.get(breakProgress)), poseStack.last(), 1.0f);
            MultiBufferSource bufferSource1 = arg_0 -> RenderUtil.lambda$renderBlock$0(bufferSource, (VertexConsumer)vertexconsumer, arg_0);
            BlockState state = blockItem.getBlock().defaultBlockState();
            Minecraft.getInstance().getBlockRenderer().renderSingleBlock(state, poseStack, bufferSource1, combinedLightIn, combinedOverlayIn, ModelData.EMPTY, null);
        }
    }

    private static /* synthetic */ VertexConsumer lambda$renderBlock$0(MultiBufferSource bufferSource, VertexConsumer vertexconsumer, RenderType type) {
        VertexConsumer vc = bufferSource.getBuffer(type);
        return type.affectsCrumbling() ? VertexMultiConsumer.create((VertexConsumer)vertexconsumer, (VertexConsumer)vc) : vc;
    }

    public record FluidBounds(float horizontalInset, float minY, float yHeight) {
    }
}

