/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.blocks.supercooler;

import com.google.common.collect.Sets;
import dev.ftb.mods.ftbstuffnthings.blocks.AbstractMachineBlockEntity;
import dev.ftb.mods.ftbstuffnthings.blocks.FluidEnergyProcessorContainerData;
import dev.ftb.mods.ftbstuffnthings.blocks.FluidEnergyProvider;
import dev.ftb.mods.ftbstuffnthings.blocks.ProgressProvider;
import dev.ftb.mods.ftbstuffnthings.blocks.supercooler.SuperCoolerMenu;
import dev.ftb.mods.ftbstuffnthings.capabilities.EmittingEnergy;
import dev.ftb.mods.ftbstuffnthings.capabilities.EmittingFluidTank;
import dev.ftb.mods.ftbstuffnthings.capabilities.IOStackHandler;
import dev.ftb.mods.ftbstuffnthings.crafting.EnergyRequirement;
import dev.ftb.mods.ftbstuffnthings.crafting.RecipeCaches;
import dev.ftb.mods.ftbstuffnthings.crafting.recipe.SuperCoolerRecipe;
import dev.ftb.mods.ftbstuffnthings.registry.BlockEntitiesRegistry;
import dev.ftb.mods.ftbstuffnthings.registry.ComponentsRegistry;
import dev.ftb.mods.ftbstuffnthings.registry.RecipesRegistry;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.ResourceLocationException;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class SuperCoolerBlockEntity
extends AbstractMachineBlockEntity
implements MenuProvider,
FluidEnergyProvider,
ProgressProvider {
    private final EmittingEnergy energyHandler = new EmittingEnergy(1000000, 10000, 10000, energy -> this.setChanged());
    private final EmittingFluidTank fluidHandler = new EmittingFluidTank(10000, tank -> this.setChanged());
    private final IOStackHandler itemHandler = new IOStackHandler(3, 1, (container, ioType) -> this.itemHandlerChanged((IOStackHandler.IO)((Object)ioType)));
    private final FluidEnergyProcessorContainerData containerData = new FluidEnergyProcessorContainerData(this, this);
    private int progress = 0;
    private int progressRequired = 0;
    private boolean recheckRecipe = false;
    private RecipeHolder<SuperCoolerRecipe> currentRecipe = null;
    private ResourceLocation pendingRecipeId = null;
    boolean tickLock = false;

    public SuperCoolerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntitiesRegistry.SUPER_COOLER.get(), pos, state);
    }

    @Override
    public IOStackHandler getItemHandler(@Nullable Direction side) {
        return this.itemHandler;
    }

    @Override
    public IFluidHandler getFluidHandler(@Nullable Direction side) {
        return this.fluidHandler;
    }

    @Override
    public IEnergyStorage getEnergyHandler(@Nullable Direction side) {
        return this.energyHandler;
    }

    private SuperCoolerRecipe getCurrentRecipe() {
        return (SuperCoolerRecipe)Objects.requireNonNull(this.currentRecipe).value();
    }

    private void itemHandlerChanged(IOStackHandler.IO ioType) {
        if (!this.level.isClientSide) {
            this.setChanged();
            if (ioType == IOStackHandler.IO.INPUT) {
                this.recheckRecipe = true;
            }
        }
    }

    @Override
    public void tickServer(ServerLevel serverLevel) {
        if (this.tickLock) {
            return;
        }
        if (!(this.hasEnoughEnergy() && this.hasAnyFluid() && this.hasItemInAnySlot())) {
            this.setActive(false);
            this.progress = 0;
            return;
        }
        if (this.pendingRecipeId != null) {
            serverLevel.getRecipeManager().byKey(this.pendingRecipeId).ifPresent(r -> {
                Recipe patt0$temp = r.value();
                if (patt0$temp instanceof SuperCoolerRecipe) {
                    SuperCoolerRecipe s = (SuperCoolerRecipe)patt0$temp;
                    this.currentRecipe = new RecipeHolder(r.id(), (Recipe)s);
                }
            });
            this.pendingRecipeId = null;
        }
        if (this.recheckRecipe || this.progress == 0) {
            this.recheckRecipe = false;
            this.currentRecipe = RecipeCaches.SUPER_COOLER.getCachedRecipe(this::findValidRecipe, this::genIngredientHash).orElse(null);
            if (this.currentRecipe == null) {
                this.progress = 0;
                this.setActive(false);
                return;
            }
            this.progress = Math.max(1, this.progress);
            this.progressRequired = this.getCurrentRecipe().getEnergyComponent().ticksToProcess();
        }
        if (this.currentRecipe != null) {
            if (this.progress == this.progressRequired && this.canAcceptOutput(this.getCurrentRecipe())) {
                this.executeRecipe();
            } else if (this.progress < this.progressRequired) {
                if (this.getCurrentRecipe().getFluidInput().test(this.fluidHandler.getFluid())) {
                    this.setActive(true);
                    this.useEnergy();
                    ++this.progress;
                } else {
                    this.setActive(false);
                }
            }
        }
    }

    private Optional<RecipeHolder<SuperCoolerRecipe>> findValidRecipe() {
        return this.level.getRecipeManager().getAllRecipesFor(RecipesRegistry.SUPER_COOLER_TYPE.get()).stream().sorted((a, b) -> ((SuperCoolerRecipe)b.value()).getInputs().size() - ((SuperCoolerRecipe)a.value()).getInputs().size()).filter(r -> ((SuperCoolerRecipe)r.value()).test(this.itemHandler, this.fluidHandler.getFluid())).findFirst();
    }

    private int genIngredientHash() {
        ArrayList<Integer> l = new ArrayList<Integer>();
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (this.itemHandler.getStackInSlot(i).isEmpty()) continue;
            l.add(ItemStack.hashItemAndComponents((ItemStack)this.itemHandler.getStackInSlot(i)));
        }
        l.add(FluidStack.hashFluidAndComponents((FluidStack)this.fluidHandler.getFluid()));
        return l.hashCode();
    }

    public void executeRecipe() {
        if (this.currentRecipe == null) {
            this.resetProgress();
            return;
        }
        if (!this.getCurrentRecipe().getFluidInput().test(this.fluidHandler.getFluid())) {
            this.resetProgress();
            return;
        }
        Set requiredItems = Sets.newIdentityHashSet();
        requiredItems.addAll(this.getCurrentRecipe().getInputs());
        ItemStackHandler inputHandler = this.itemHandler.getInput();
        BitSet extractingSlots = new BitSet(inputHandler.getSlots());
        for (Ingredient ingredient : requiredItems) {
            for (int i = 0; i < inputHandler.getSlots(); ++i) {
                if (extractingSlots.get(i) || !ingredient.test(inputHandler.getStackInSlot(i))) continue;
                if (inputHandler.extractItem(i, 1, true).isEmpty()) {
                    this.resetProgress();
                    this.currentRecipe = null;
                    return;
                }
                extractingSlots.set(i);
            }
        }
        if (extractingSlots.cardinality() == this.getCurrentRecipe().getInputs().size()) {
            this.fluidHandler.drain(this.getCurrentRecipe().getFluidInput().amount(), IFluidHandler.FluidAction.EXECUTE);
            for (int i = 0; i < inputHandler.getSlots(); ++i) {
                if (!extractingSlots.get(i)) continue;
                inputHandler.extractItem(i, 1, false);
            }
            this.itemHandler.getOutput().insertItem(0, this.getCurrentRecipe().getResult().copy(), false);
            this.resetProgress();
        }
    }

    private void useEnergy() {
        if (this.currentRecipe != null) {
            EnergyRequirement energy = this.getCurrentRecipe().getEnergyComponent();
            int result = this.energyHandler.extractEnergy(energy.fePerTick(), true);
            if (result >= energy.fePerTick()) {
                this.energyHandler.extractEnergy(energy.fePerTick(), false);
            } else {
                this.resetProgress();
            }
        }
    }

    private void resetProgress() {
        this.progress = 0;
        this.progressRequired = 0;
        this.currentRecipe = null;
        this.tickLock = false;
    }

    public boolean canAcceptOutput(SuperCoolerRecipe recipe) {
        int nItems;
        ItemStack outputSlot = this.itemHandler.getOutput().getStackInSlot(0);
        if (outputSlot.isEmpty()) {
            return true;
        }
        int n = nItems = this.currentRecipe == null ? 0 : this.getCurrentRecipe().getResult().getCount();
        if (outputSlot.getCount() >= outputSlot.getMaxStackSize() - nItems) {
            return false;
        }
        return ItemStack.isSameItemSameComponents((ItemStack)outputSlot, (ItemStack)recipe.getResult());
    }

    private boolean hasAnyFluid() {
        return !this.fluidHandler.isEmpty();
    }

    private boolean hasEnoughEnergy() {
        return this.energyHandler.getEnergyStored() > (this.currentRecipe == null ? 0 : this.getCurrentRecipe().getEnergyComponent().fePerTick());
    }

    private boolean hasItemInAnySlot() {
        ItemStackHandler input = this.itemHandler.getInput();
        for (int i = 0; i < input.getSlots(); ++i) {
            if (input.getStackInSlot(i).isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Component getDisplayName() {
        return Component.translatable((String)"block.ftbstuff.super_cooler");
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory inventory, Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            this.fluidHandler.needSync(sp);
        }
        return new SuperCoolerMenu(containerId, inventory, this.getBlockPos());
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.itemHandler.getInput().deserializeNBT(provider, tag.getCompound("input"));
        this.itemHandler.getOutput().deserializeNBT(provider, tag.getCompound("output"));
        if (tag.contains("energy")) {
            this.energyHandler.deserializeNBT(provider, tag.get("energy"));
        }
        this.fluidHandler.readFromNBT(provider, tag.getCompound("fluid"));
        this.progress = tag.getInt("progress");
        this.progressRequired = tag.getInt("progressRequired");
        if (tag.contains("recipe")) {
            try {
                this.pendingRecipeId = ResourceLocation.parse((String)tag.getString("recipe"));
            }
            catch (ResourceLocationException e) {
                this.pendingRecipeId = null;
            }
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put("input", (Tag)this.itemHandler.getInput().serializeNBT(provider));
        tag.put("output", (Tag)this.itemHandler.getOutput().serializeNBT(provider));
        tag.put("energy", this.energyHandler.serializeNBT(provider));
        tag.put("fluid", (Tag)this.fluidHandler.writeToNBT(provider, new CompoundTag()));
        tag.putInt("progress", this.progress);
        tag.putInt("progressRequired", this.progressRequired);
        if (this.currentRecipe != null) {
            tag.putString("recipe", this.currentRecipe.id().toString());
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return (CompoundTag)Util.make((Object)new CompoundTag(), t -> this.saveAdditional((CompoundTag)t, provider));
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider provider) {
        this.loadAdditional(tag, provider);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        this.fluidHandler.setFluid(((SimpleFluidContent)componentInput.getOrDefault(ComponentsRegistry.STORED_FLUID, (Object)SimpleFluidContent.EMPTY)).copy());
        this.energyHandler.overrideEnergy((Integer)componentInput.getOrDefault(ComponentsRegistry.STORED_ENERGY, (Object)0));
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set(ComponentsRegistry.STORED_FLUID, (Object)SimpleFluidContent.copyOf((FluidStack)this.fluidHandler.getFluid()));
        components.set(ComponentsRegistry.STORED_ENERGY, (Object)this.energyHandler.getEnergyStored());
    }

    @Override
    public int getEnergy() {
        return this.energyHandler.getEnergyStored();
    }

    @Override
    public int getMaxEnergy() {
        return this.energyHandler.getMaxEnergyStored();
    }

    @Override
    public FluidStack getFluid() {
        return this.fluidHandler.getFluid();
    }

    @Override
    public int getMaxFluid() {
        return this.fluidHandler.getCapacity();
    }

    @Override
    public void setEnergy(int energy) {
        this.energyHandler.overrideEnergy(energy);
    }

    @Override
    public void setFluid(FluidStack fluid) {
        this.fluidHandler.setFluid(fluid);
    }

    @Override
    public int getProgress() {
        return this.progress;
    }

    @Override
    public int getMaxProgress() {
        return this.progressRequired;
    }

    @Override
    public void setProgress(int progress) {
        this.progress = progress;
    }

    @Override
    public void setMaxProgress(int maxProgress) {
        this.progressRequired = maxProgress;
    }

    @Override
    public ContainerData getContainerData() {
        return this.containerData;
    }

    @Override
    public void syncFluidFromServer(FluidStack fluidStack) {
        this.fluidHandler.setFluid(fluidStack);
    }
}

