/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.blocks.jar;

import com.mojang.serialization.DynamicOps;
import dev.ftb.mods.ftbstuffnthings.FTBStuffNThings;
import dev.ftb.mods.ftbstuffnthings.blocks.jar.TemperedJarBlock;
import dev.ftb.mods.ftbstuffnthings.blocks.jar.TemperedJarMenu;
import dev.ftb.mods.ftbstuffnthings.crafting.RecipeCaches;
import dev.ftb.mods.ftbstuffnthings.crafting.recipe.JarRecipe;
import dev.ftb.mods.ftbstuffnthings.items.FluidCapsuleItem;
import dev.ftb.mods.ftbstuffnthings.network.SyncJarContentsPacket;
import dev.ftb.mods.ftbstuffnthings.network.SyncJarRecipePacket;
import dev.ftb.mods.ftbstuffnthings.registry.BlockEntitiesRegistry;
import dev.ftb.mods.ftbstuffnthings.registry.BlocksRegistry;
import dev.ftb.mods.ftbstuffnthings.registry.ComponentsRegistry;
import dev.ftb.mods.ftbstuffnthings.registry.RecipesRegistry;
import dev.ftb.mods.ftbstuffnthings.temperature.TemperatureAndEfficiency;
import dev.ftb.mods.ftbstuffnthings.util.DirectionUtil;
import dev.ftb.mods.ftbstuffnthings.util.MiscUtil;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class TemperedJarBlockEntity
extends BlockEntity
implements MenuProvider {
    public static final int TANK_CAPACITY = 8000;
    private static final ResourceLocation NO_RECIPE = FTBStuffNThings.id("_none_");
    public static final int STOPPED = -1;
    private boolean needRecipeSearch = true;
    private final Lazy<InputResourceLocator> inputResourceLocator = Lazy.of(() -> new InputResourceLocator());
    private String pendingRecipeId = "";
    @Nullable
    private RecipeHolder<JarRecipe> currentRecipe;
    private final Lazy<Boolean> autoProcessing = Lazy.of(this::checkForAutoProcessor);
    private final Lazy<TemperatureAndEfficiency> temperature = Lazy.of(this::checkForTemperature);
    private int remainingTime;
    private int processingTime;
    private final JarItemHandler itemHandler = new JarItemHandler();
    private final JarFluidHandler fluidHandler = new JarFluidHandler();
    private final JarContainerData containerData = new JarContainerData();
    private boolean syncNeeded;
    private long lastItemFluidSync = 0L;
    private final Map<Direction, BlockCapabilityCache<IItemHandler, Direction>> itemOutputs = new EnumMap<Direction, BlockCapabilityCache<IItemHandler, Direction>>(Direction.class);
    private final Map<Direction, BlockCapabilityCache<IFluidHandler, Direction>> fluidOutputs = new EnumMap<Direction, BlockCapabilityCache<IFluidHandler, Direction>>(Direction.class);
    private JarStatus status = JarStatus.NO_RECIPE;
    private final List<ItemStack> itemBacklog = new ArrayList<ItemStack>();
    private final List<FluidStack> fluidBacklog = new ArrayList<FluidStack>();

    public TemperedJarBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)BlockEntitiesRegistry.TEMPERED_JAR.get(), pos, blockState);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("Items", (Tag)this.itemHandler.serializeNBT(registries));
        tag.put("Tanks", this.fluidHandler.serializeNBT(registries));
        tag.putInt("Remaining", this.remainingTime);
        if (!this.itemBacklog.isEmpty()) {
            tag.put("ItemBacklog", (Tag)Util.make((Object)new ListTag(), l -> this.itemBacklog.forEach(stack -> l.add((Object)stack.save(registries)))));
        }
        if (!this.fluidBacklog.isEmpty()) {
            tag.put("FluidBacklog", (Tag)Util.make((Object)new ListTag(), l -> this.fluidBacklog.forEach(stack -> l.add((Object)stack.save(registries)))));
        }
        if (this.currentRecipe != null) {
            tag.putString("Recipe", this.currentRecipe.id().toString());
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.itemHandler.deserializeNBT(registries, tag.getCompound("Items"));
        this.fluidHandler.deserializeNBT(registries, tag.getCompound("Tanks"));
        this.remainingTime = tag.getInt("Remaining");
        this.pendingRecipeId = tag.getString("Recipe");
        if (tag.contains("ItemBacklog", 9)) {
            this.itemBacklog.clear();
            tag.getList("ItemBacklog", 10).forEach(t -> ItemStack.parse((HolderLookup.Provider)registries, (Tag)t).ifPresent(this.itemBacklog::add));
        }
        if (tag.contains("FluidBacklog", 9)) {
            this.fluidBacklog.clear();
            tag.getList("FluidBacklog", 10).forEach(t -> FluidStack.parse((HolderLookup.Provider)registries, (Tag)t).ifPresent(this.fluidBacklog::add));
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return (CompoundTag)Util.make((Object)new CompoundTag(), tag -> this.saveAdditional((CompoundTag)tag, registries));
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.ftbstuff.tempered_jar");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        return new TemperedJarMenu(containerId, playerInventory, this.getBlockPos());
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        List list = (List)componentInput.getOrDefault(ComponentsRegistry.FLUID_TANKS, List.of());
        for (int i = 0; i < list.size() && i < this.fluidHandler.tanks.size(); ++i) {
            this.fluidHandler.tanks.get(i).setFluid(((SimpleFluidContent)list.get(i)).copy());
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        List<SimpleFluidContent> list = this.fluidHandler.tanks.stream().filter(tank -> !tank.isEmpty()).map(tank -> SimpleFluidContent.copyOf((FluidStack)tank.getFluid())).toList();
        if (!list.isEmpty()) {
            components.set(ComponentsRegistry.FLUID_TANKS, list);
        }
    }

    public JarContainerData getContainerData() {
        return this.containerData;
    }

    public void onLoad() {
        super.onLoad();
        if (!this.pendingRecipeId.isEmpty()) {
            this.getLevel().getRecipeManager().byKey(ResourceLocation.parse((String)this.pendingRecipeId)).ifPresent(r -> {
                if (r.value() instanceof JarRecipe) {
                    this.currentRecipe = r;
                }
            });
            this.pendingRecipeId = "";
        }
    }

    public void serverTick(ServerLevel serverLevel) {
        boolean active;
        if (this.syncNeeded && serverLevel.getGameTime() - this.lastItemFluidSync > 10L) {
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)SyncJarContentsPacket.wholeJar(this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.syncNeeded = false;
            this.lastItemFluidSync = serverLevel.getGameTime();
        }
        if (this.needRecipeSearch) {
            ResourceLocation prevId = this.currentRecipe == null ? NO_RECIPE : this.currentRecipe.id();
            this.currentRecipe = this.findSuitableRecipe();
            this.setChanged();
            ResourceLocation newId = this.currentRecipe == null ? NO_RECIPE : this.currentRecipe.id();
            int n = this.processingTime = this.currentRecipe == null ? 0 : this.getTemperature().getRecipeTime((JarRecipe)this.currentRecipe.value());
            if (!prevId.equals((Object)newId)) {
                this.setRemainingTime(this.hasAutoProcessing() && this.processingTime > 0 ? this.processingTime : -1);
                SyncJarRecipePacket packet = new SyncJarRecipePacket(this.getBlockPos(), this.getCurrentRecipeId());
                serverLevel.players().stream().filter(p -> {
                    TemperedJarMenu menu;
                    AbstractContainerMenu patt0$temp = p.containerMenu;
                    return patt0$temp instanceof TemperedJarMenu && (menu = (TemperedJarMenu)patt0$temp).getJar() == this;
                }).forEach(p -> PacketDistributor.sendToPlayer((ServerPlayer)p, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]));
                this.inputResourceLocator.invalidate();
            } else {
                this.setRemainingTime(Math.min(this.remainingTime, this.processingTime));
            }
            this.needRecipeSearch = false;
        }
        if (!this.itemBacklog.isEmpty() || !this.fluidBacklog.isEmpty()) {
            this.status = JarStatus.OUTPUT_FULL;
            if (serverLevel.getGameTime() % 20L == 0L && this.tryProcessBacklog()) {
                this.setRemainingTime(this.hasAutoProcessing() && this.processingTime > 0 ? this.processingTime : -1);
                this.status = JarStatus.READY;
            }
        } else if (this.currentRecipe != null) {
            if (((InputResourceLocator)this.inputResourceLocator.get()).allInputsFound()) {
                if (this.remainingTime == -1) {
                    this.status = JarStatus.READY;
                } else {
                    this.status = JarStatus.CRAFTING;
                    this.runOneCycle(serverLevel, (JarRecipe)this.currentRecipe.value());
                }
            } else {
                this.status = JarStatus.NOT_ENOUGH_RESOURCES;
            }
        } else {
            this.status = JarStatus.NO_RECIPE;
        }
        if ((active = ((Boolean)this.getBlockState().getValue((Property)TemperedJarBlock.ACTIVE)).booleanValue()) && this.status != JarStatus.CRAFTING || !active && this.status == JarStatus.CRAFTING) {
            serverLevel.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)TemperedJarBlock.ACTIVE, (Comparable)Boolean.valueOf(this.status == JarStatus.CRAFTING)), 2);
        }
    }

    private boolean tryProcessBacklog() {
        List<ItemStack> excess;
        if (!this.itemBacklog.isEmpty()) {
            excess = this.distributeOutputItems(this.itemBacklog);
            this.itemBacklog.clear();
            this.itemBacklog.addAll(excess);
            this.setChanged();
        }
        if (!this.fluidBacklog.isEmpty()) {
            excess = this.distributeOutputFluids(this.fluidBacklog);
            this.fluidBacklog.clear();
            this.fluidBacklog.addAll(excess);
            this.setChanged();
        }
        return this.itemBacklog.isEmpty() && this.fluidBacklog.isEmpty();
    }

    public void maybeClearBacklog(Direction dir) {
        boolean cleared = false;
        if (!this.itemBacklog.isEmpty()) {
            this.itemBacklog.forEach(stack -> Block.popResource((Level)this.level, (BlockPos)this.getBlockPos().relative(dir), (ItemStack)stack));
            this.itemBacklog.clear();
            cleared = true;
        }
        if (!this.fluidBacklog.isEmpty()) {
            this.fluidBacklog.forEach(stack -> Block.popResource((Level)this.level, (BlockPos)this.getBlockPos().relative(dir), (ItemStack)FluidCapsuleItem.of(stack)));
            this.fluidBacklog.clear();
            cleared = true;
        }
        if (cleared) {
            this.setRemainingTime(this.hasAutoProcessing() && this.processingTime > 0 ? this.processingTime : -1);
        }
    }

    @Nullable
    private RecipeHolder<JarRecipe> findSuitableRecipe() {
        List<RecipeHolder<JarRecipe>> recipes = RecipeCaches.TEMPERED_JAR.getCachedRecipes(this::searchForRecipe, this::genIngredientHash);
        if (recipes.isEmpty()) {
            return null;
        }
        if (recipes.size() == 1) {
            return recipes.getFirst();
        }
        return recipes.stream().filter(r -> ((JarRecipe)r.value()).test(this.getTemperature().temperature(), (IItemHandler)this.itemHandler, this.fluidHandler, true)).findFirst().orElse(null);
    }

    private void runOneCycle(ServerLevel serverLevel, JarRecipe recipe) {
        if (!this.itemBacklog.isEmpty() || !this.fluidBacklog.isEmpty()) {
            return;
        }
        if (this.remainingTime > 0) {
            this.setRemainingTime(this.remainingTime - 1);
        }
        if (this.remainingTime <= 0) {
            List<FluidStack> excessFluids;
            int i;
            int[] itemSlots = ((InputResourceLocator)this.inputResourceLocator.get()).itemSlots;
            int[] fluidSlots = ((InputResourceLocator)this.inputResourceLocator.get()).fluidSlots;
            for (i = 0; i < recipe.getInputItems().size(); ++i) {
                this.getInputItemHandler().extractItem(itemSlots[i], recipe.getInputItems().get(i).count(), false);
            }
            for (i = 0; i < recipe.getInputFluids().size(); ++i) {
                this.fluidHandler.tanks.get(fluidSlots[i]).drain(recipe.getInputFluids().get(i).amount(), IFluidHandler.FluidAction.EXECUTE);
            }
            this.syncNeeded = true;
            boolean outputsFull = false;
            List<ItemStack> excessItems = this.distributeOutputItems(recipe);
            if (!excessItems.isEmpty()) {
                if (this.hasAutoProcessing()) {
                    this.itemBacklog.addAll(excessItems);
                    this.setChanged();
                } else {
                    excessItems.forEach(itemStack -> Block.popResource((Level)serverLevel, (BlockPos)this.getBlockPos(), (ItemStack)itemStack));
                }
                outputsFull = true;
            }
            if (!(excessFluids = this.distributeOutputFluids(recipe)).isEmpty()) {
                if (this.hasAutoProcessing()) {
                    this.fluidBacklog.addAll(excessFluids);
                    this.setChanged();
                } else {
                    excessFluids.forEach(fluidStack -> Block.popResource((Level)serverLevel, (BlockPos)this.getBlockPos(), (ItemStack)FluidCapsuleItem.of(fluidStack)));
                }
                outputsFull = true;
            }
            if (!this.hasAutoProcessing()) {
                this.level.playSound(null, this.getBlockPos(), SoundEvents.BREWING_STAND_BREW, SoundSource.BLOCKS, 1.0f, 1.2f + this.level.random.nextFloat() * 0.4f);
                Vec3 vec = Vec3.atBottomCenterOf((Vec3i)this.getBlockPos().above());
                ((ServerLevel)this.level).sendParticles((ParticleOptions)ParticleTypes.WHITE_SMOKE, vec.x, vec.y + 0.2, vec.z, 5, 0.0, 0.0, 0.0, 0.01);
            }
            this.setRemainingTime(!outputsFull && this.hasAutoProcessing() && recipe.canRepeat() ? this.processingTime : -1);
        }
    }

    private List<ItemStack> distributeOutputItems(JarRecipe recipe) {
        return this.distributeOutputItems(recipe.getOutputItems().stream().map(ItemStack::copy).toList());
    }

    private List<ItemStack> distributeOutputItems(List<ItemStack> toDistribute) {
        ArrayList<ItemStack> excessList = new ArrayList<ItemStack>();
        for (Direction dir : DirectionUtil.VALUES) {
            IItemHandler handler;
            if (!this.suitableOutputBlock(dir) || (handler = (IItemHandler)this.itemOutputs.computeIfAbsent(dir, k -> BlockCapabilityCache.create((BlockCapability)Capabilities.ItemHandler.BLOCK, (ServerLevel)((ServerLevel)this.getLevel()), (BlockPos)this.getBlockPos().relative(dir), (Object)dir.getOpposite())).getCapability()) == null) continue;
            for (ItemStack stack : toDistribute) {
                ItemStack excess = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)false);
                if (excess.isEmpty()) continue;
                excessList.add(excess);
            }
            toDistribute = List.copyOf(excessList);
            if (toDistribute.isEmpty()) break;
            excessList.clear();
        }
        return List.copyOf(toDistribute);
    }

    private boolean suitableOutputBlock(Direction dir) {
        BlockState state = this.level.getBlockState(this.getBlockPos().relative(dir));
        return state.getBlock() != Blocks.HOPPER || state.getValue((Property)BlockStateProperties.FACING_HOPPER) != dir.getOpposite();
    }

    private List<FluidStack> distributeOutputFluids(JarRecipe recipe) {
        return this.distributeOutputFluids(recipe.getOutputFluids().stream().map(FluidStack::copy).toList());
    }

    private List<FluidStack> distributeOutputFluids(List<FluidStack> toDistribute) {
        ArrayList<FluidStack> excessList = new ArrayList<FluidStack>();
        for (Direction dir : DirectionUtil.VALUES) {
            IFluidHandler dest = (IFluidHandler)this.fluidOutputs.computeIfAbsent(dir, k -> BlockCapabilityCache.create((BlockCapability)Capabilities.FluidHandler.BLOCK, (ServerLevel)((ServerLevel)this.getLevel()), (BlockPos)this.getBlockPos().relative(dir), (Object)dir.getOpposite())).getCapability();
            if (dest == null) continue;
            for (FluidStack stack : toDistribute) {
                int filled = dest.fill(stack, IFluidHandler.FluidAction.EXECUTE);
                if (filled >= stack.getAmount()) continue;
                excessList.add(stack.copyWithAmount(stack.getAmount() - filled));
            }
            toDistribute = List.copyOf(excessList);
            if (toDistribute.isEmpty()) break;
            excessList.clear();
        }
        return List.copyOf(toDistribute);
    }

    private List<RecipeHolder<JarRecipe>> searchForRecipe() {
        return this.getLevel().getRecipeManager().getAllRecipesFor(RecipesRegistry.TEMPERED_JAR_TYPE.get()).stream().filter(r -> ((JarRecipe)r.value()).test(this.getTemperature().temperature(), (IItemHandler)this.itemHandler, this.fluidHandler, false)).sorted(Comparator.comparing(RecipeHolder::value)).toList();
    }

    private int genIngredientHash() {
        int i;
        IntArrayList itemIds = new IntArrayList();
        itemIds.add(this.getTemperature().temperature().ordinal());
        for (i = 0; i < this.getInputItemHandler().getSlots(); ++i) {
            itemIds.add(ItemStack.hashItemAndComponents((ItemStack)this.getInputItemHandler().getStackInSlot(i)));
        }
        for (i = 0; i < this.getFluidHandler().getTanks(); ++i) {
            itemIds.add(FluidStack.hashFluidAndComponents((FluidStack)this.getFluidHandler().getFluidInTank(i)));
        }
        return Objects.hash(itemIds.toArray());
    }

    public TemperatureAndEfficiency getTemperature() {
        return (TemperatureAndEfficiency)this.temperature.get();
    }

    public boolean onRightClick(Player player, InteractionHand hand) {
        boolean res = false;
        if (FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)this.fluidHandler)) {
            this.syncNeeded = true;
            res = true;
        }
        if (!player.level().isClientSide()) {
            ArrayList<MutableComponent> msgs = new ArrayList<MutableComponent>();
            for (int i = 0; i < this.fluidHandler.getTanks(); ++i) {
                FluidStack stack = this.fluidHandler.getFluidInTank(i);
                if (stack.isEmpty()) continue;
                msgs.add(Component.translatable((String)"ftblibrary.mb", (Object[])new Object[]{stack.getAmount(), stack.getHoverName()}));
            }
            if (msgs.isEmpty()) {
                player.displayClientMessage((Component)Component.translatable((String)"ftblibrary.empty"), true);
            } else {
                player.displayClientMessage((Component)msgs.stream().reduce((c1, c2) -> c1.copy().append(" / ").append(c2)).orElse(Component.empty()), true);
            }
        }
        return res;
    }

    public void clearCachedData() {
        this.temperature.invalidate();
        this.autoProcessing.invalidate();
        this.needRecipeSearch = true;
    }

    private boolean hasAutoProcessing() {
        return (Boolean)this.autoProcessing.get();
    }

    private boolean checkForAutoProcessor() {
        return !this.level.isOutsideBuildHeight(this.worldPosition.above()) && this.level.getBlockState(this.worldPosition.above()).is((Block)BlocksRegistry.JAR_AUTOMATER.get());
    }

    private TemperatureAndEfficiency checkForTemperature() {
        return TemperatureAndEfficiency.fromLevel(this.getLevel(), this.getBlockPos().below());
    }

    public IItemHandler getInputItemHandler() {
        return this.itemHandler;
    }

    public IItemHandler getInputItemHandler(Direction ignoredSide) {
        return this.itemHandler;
    }

    public IFluidHandler getFluidHandler() {
        return this.fluidHandler;
    }

    public IFluidHandler getFluidHandler(Direction ignoredSide) {
        return this.fluidHandler;
    }

    public void syncFromServer(List<SyncJarContentsPacket.ResourceSlot> resources) {
        this.itemHandler.clear();
        this.fluidHandler.clear();
        resources.forEach(resource -> resource.resource().ifLeft(item -> this.itemHandler.setStackInSlot(resource.slot(), (ItemStack)item)).ifRight(fluid -> this.fluidHandler.tanks.get(resource.slot()).setFluid((FluidStack)fluid)));
    }

    public Optional<ResourceLocation> getCurrentRecipeId() {
        return this.currentRecipe == null ? Optional.empty() : Optional.of(this.currentRecipe.id());
    }

    public void setCurrentRecipeId(@Nullable ResourceLocation newRecipeId) {
        if (this.level.isClientSide) {
            this.currentRecipe = newRecipeId == null ? null : (RecipeHolder)this.level.getRecipeManager().byKey(newRecipeId).filter(r -> r.value() instanceof JarRecipe).orElse(null);
        }
    }

    public void toggleCrafting() {
        this.setRemainingTime(this.remainingTime < 0 && this.currentRecipe != null ? this.processingTime : -1);
    }

    private void setRemainingTime(int time) {
        if (time != this.remainingTime) {
            this.remainingTime = time;
            this.setChanged();
        }
    }

    public int getRemainingTime() {
        return this.remainingTime;
    }

    public int getProcessingTime() {
        return this.processingTime;
    }

    public JarStatus getStatus() {
        return this.status;
    }

    public Optional<RecipeHolder<JarRecipe>> getCurrentRecipe() {
        return Optional.ofNullable(this.currentRecipe);
    }

    public void dropContentsOnBreak() {
        Containers.dropContents((Level)this.getLevel(), (BlockPos)this.getBlockPos(), MiscUtil.getItemsInHandler(this.getInputItemHandler()));
    }

    private class JarItemHandler
    extends ItemStackHandler {
        private final ItemStack[] prevStack;

        public JarItemHandler() {
            super(3);
            this.prevStack = new ItemStack[3];
            Arrays.fill(this.prevStack, ItemStack.EMPTY);
        }

        protected void onContentsChanged(int slot) {
            if (!((TemperedJarBlockEntity)TemperedJarBlockEntity.this).level.isClientSide) {
                TemperedJarBlockEntity.this.setChanged();
                TemperedJarBlockEntity.this.syncNeeded = true;
                if (!ItemStack.isSameItemSameComponents((ItemStack)this.prevStack[slot], (ItemStack)this.getStackInSlot(slot))) {
                    TemperedJarBlockEntity.this.needRecipeSearch = true;
                }
                TemperedJarBlockEntity.this.inputResourceLocator.invalidate();
                this.prevStack[slot] = this.getStackInSlot(slot).copy();
            }
        }

        protected void onLoad() {
            for (int i = 0; i < this.getSlots(); ++i) {
                this.prevStack[i] = this.getStackInSlot(i).copy();
            }
        }

        public void clear() {
            this.setSize(this.getSlots());
        }
    }

    private class JarFluidHandler
    implements IFluidHandler {
        private final List<JarTank> tanks;

        private JarFluidHandler() {
            this.tanks = List.of(new JarTank(), new JarTank(), new JarTank());
        }

        public int getTanks() {
            return this.tanks.size();
        }

        public FluidStack getFluidInTank(int tank) {
            return this.tanks.get(tank).getFluid().copy();
        }

        public int getTankCapacity(int tank) {
            return this.tanks.get(tank).getCapacity();
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            return this.getFluidInTank(tank).isEmpty() || FluidStack.isSameFluidSameComponents((FluidStack)this.getFluidInTank(tank), (FluidStack)stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            int firstEmpty = -1;
            int filled = 0;
            for (int i = 0; i < this.getTanks(); ++i) {
                FluidStack current = this.getFluidInTank(i);
                if (FluidStack.isSameFluidSameComponents((FluidStack)current, (FluidStack)resource)) {
                    filled = this.tanks.get(i).fill(resource, action);
                    break;
                }
                if (firstEmpty >= 0 || !current.isEmpty()) continue;
                firstEmpty = i;
            }
            if (firstEmpty >= 0) {
                filled = this.tanks.get(firstEmpty).fill(resource, action);
            }
            if (filled > 0 && action.execute()) {
                TemperedJarBlockEntity.this.setChanged();
                TemperedJarBlockEntity.this.syncNeeded = true;
            }
            return filled;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return this.doDrain(t -> FluidStack.isSameFluidSameComponents((FluidStack)t.getFluid(), (FluidStack)resource), resource.getAmount(), action);
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return this.doDrain(t -> !t.isEmpty(), maxDrain, action);
        }

        private FluidStack doDrain(Predicate<FluidTank> tankPredicate, int amount, IFluidHandler.FluidAction action) {
            return this.tanks.stream().filter(tankPredicate).findFirst().map(tank -> tank.drain(amount, action)).orElse(FluidStack.EMPTY);
        }

        public Tag serializeNBT(HolderLookup.Provider provider) {
            RegistryOps ops = provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
            return (Tag)Util.make((Object)new CompoundTag(), tag -> {
                for (int i = 0; i < this.getTanks(); ++i) {
                    if (this.getFluidInTank(i).isEmpty()) continue;
                    tag.put("Tank" + i, (Tag)FluidStack.CODEC.encodeStart((DynamicOps)ops, (Object)this.getFluidInTank(i)).result().orElseThrow());
                }
            });
        }

        private void deserializeNBT(HolderLookup.Provider provider, CompoundTag tag) {
            RegistryOps ops = provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
            for (int i = 0; i < this.tanks.size(); ++i) {
                if (tag.contains("Tank" + i)) {
                    FluidStack stack = (FluidStack)FluidStack.CODEC.parse((DynamicOps)ops, (Object)tag.get("Tank" + i)).getOrThrow();
                    this.tanks.get(i).setFluid(stack);
                    continue;
                }
                this.tanks.get(i).setFluid(FluidStack.EMPTY);
            }
        }

        public void clear() {
            this.tanks.forEach(tank -> tank.setFluid(FluidStack.EMPTY));
        }
    }

    public class JarContainerData
    implements ContainerData {
        public int get(int index) {
            return switch (index) {
                case 0 -> TemperedJarBlockEntity.this.processingTime;
                case 1 -> TemperedJarBlockEntity.this.remainingTime;
                case 2 -> TemperedJarBlockEntity.this.status.ordinal();
                default -> throw new IllegalArgumentException("invalid index: " + index);
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    TemperedJarBlockEntity.this.processingTime = value;
                    break;
                }
                case 1: {
                    TemperedJarBlockEntity.this.setRemainingTime(value);
                    break;
                }
                case 2: {
                    TemperedJarBlockEntity.this.status = JarStatus.values()[value];
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid index: " + index);
                }
            }
        }

        public int getCount() {
            return 3;
        }
    }

    public static enum JarStatus {
        READY("ready", ChatFormatting.DARK_GREEN),
        CRAFTING("crafting", ChatFormatting.GREEN),
        NO_RECIPE("no_recipe", ChatFormatting.GOLD),
        NOT_ENOUGH_RESOURCES("not_enough_resources", ChatFormatting.YELLOW),
        OUTPUT_FULL("output_full", ChatFormatting.YELLOW);

        private final String id;
        private final ChatFormatting color;

        private JarStatus(String id, ChatFormatting color) {
            this.id = id;
            this.color = color;
        }

        public Component displayString() {
            return Component.translatable((String)("ftbstuff.jar_status." + this.id)).withStyle(this.color);
        }
    }

    private class JarTank
    extends FluidTank {
        FluidStack prevFluid;

        public JarTank() {
            super(8000);
            this.prevFluid = FluidStack.EMPTY;
        }

        protected void onContentsChanged() {
            if (!((TemperedJarBlockEntity)TemperedJarBlockEntity.this).level.isClientSide) {
                TemperedJarBlockEntity.this.setChanged();
                TemperedJarBlockEntity.this.syncNeeded = true;
                if (!FluidStack.isSameFluidSameComponents((FluidStack)this.prevFluid, (FluidStack)this.getFluid())) {
                    TemperedJarBlockEntity.this.needRecipeSearch = true;
                }
                TemperedJarBlockEntity.this.inputResourceLocator.invalidate();
                this.prevFluid = this.getFluid().copy();
            }
        }

        public void setFluid(FluidStack stack) {
            this.prevFluid = this.getFluid().copy();
            super.setFluid(stack);
        }
    }

    private class InputResourceLocator {
        private int[] itemSlots = new int[]{-1};
        private int[] fluidSlots = new int[]{-1};

        public InputResourceLocator() {
            this.locateInputResources();
        }

        private void locateInputResources() {
            if (TemperedJarBlockEntity.this.currentRecipe != null) {
                JarRecipe recipe = (JarRecipe)TemperedJarBlockEntity.this.currentRecipe.value();
                this.itemSlots = (int[])Util.make((Object)new int[recipe.getInputItems().size()], a -> Arrays.fill(a, -1));
                BitSet itemSlotsChecked = new BitSet(this.itemSlots.length);
                List<SizedIngredient> inputItems = recipe.getInputItems();
                for (int ingrIdx = 0; ingrIdx < inputItems.size(); ++ingrIdx) {
                    SizedIngredient ingr = inputItems.get(ingrIdx);
                    for (int slotIdx = 0; slotIdx < TemperedJarBlockEntity.this.itemHandler.getSlots(); ++slotIdx) {
                        if (itemSlotsChecked.get(slotIdx) || !ingr.test(TemperedJarBlockEntity.this.itemHandler.getStackInSlot(slotIdx))) continue;
                        itemSlotsChecked.set(slotIdx);
                        this.itemSlots[ingrIdx] = slotIdx;
                    }
                }
                this.fluidSlots = (int[])Util.make((Object)new int[recipe.getInputFluids().size()], a -> Arrays.fill(a, -1));
                BitSet fluidSlotsChecked = new BitSet(this.fluidSlots.length);
                List<SizedFluidIngredient> inputFluids = recipe.getInputFluids();
                for (int ingrIdx = 0; ingrIdx < inputFluids.size(); ++ingrIdx) {
                    SizedFluidIngredient ingr = inputFluids.get(ingrIdx);
                    for (int slotIdx = 0; slotIdx < TemperedJarBlockEntity.this.fluidHandler.getTanks(); ++slotIdx) {
                        if (fluidSlotsChecked.get(slotIdx) || !ingr.test(TemperedJarBlockEntity.this.fluidHandler.getFluidInTank(slotIdx))) continue;
                        fluidSlotsChecked.set(slotIdx);
                        this.fluidSlots[ingrIdx] = slotIdx;
                    }
                }
            } else {
                this.itemSlots = new int[]{-1};
                this.fluidSlots = new int[]{-1};
            }
        }

        private boolean allInputsFound() {
            return Arrays.stream(this.itemSlots).noneMatch(itemSlot -> itemSlot < 0) && Arrays.stream(this.fluidSlots).noneMatch(fluidSlot -> fluidSlot < 0);
        }
    }
}

