/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.blocks.jar;

import dev.ftb.mods.ftbstuffnthings.blocks.tube.ITubeConnectable;
import dev.ftb.mods.ftbstuffnthings.registry.BlockEntitiesRegistry;
import dev.ftb.mods.ftbstuffnthings.registry.ComponentsRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class JarBlockEntity
extends BlockEntity
implements ITubeConnectable {
    private final FluidTank tank = new JarFluidTank();

    public JarBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)BlockEntitiesRegistry.JAR.get(), blockPos, blockState);
    }

    @Override
    public boolean isSideTubeConnectable(Direction side) {
        return side == Direction.UP;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("Tank", (Tag)this.tank.writeToNBT(registries, new CompoundTag()));
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.tank.readFromNBT(registries, tag.getCompound("Tank"));
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        this.saveAdditional(tag, registries);
        return tag;
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public IFluidHandler getFluidHandler() {
        return this.tank;
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public int getComparatorSignal() {
        return this.tank.getFluidAmount() * 15 / this.tank.getCapacity();
    }

    public void onRightClick(Player player, InteractionHand hand, ItemStack item) {
        FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)this.tank);
        if (!this.level.isClientSide()) {
            if (this.tank.isEmpty()) {
                player.displayClientMessage((Component)Component.translatable((String)"ftblibrary.empty"), true);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"ftblibrary.mb", (Object[])new Object[]{this.tank.getFluidAmount(), this.tank.getFluid().getHoverName()}), true);
            }
        }
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        this.tank.setFluid(((SimpleFluidContent)componentInput.getOrDefault(ComponentsRegistry.STORED_FLUID, (Object)SimpleFluidContent.EMPTY)).copy());
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set(ComponentsRegistry.STORED_FLUID, (Object)SimpleFluidContent.copyOf((FluidStack)this.tank.getFluid()));
    }

    private class JarFluidTank
    extends FluidTank {
        public JarFluidTank() {
            super(8000);
        }

        protected void onContentsChanged() {
            JarBlockEntity.this.setChanged();
            JarBlockEntity.this.level.sendBlockUpdated(JarBlockEntity.this.worldPosition, JarBlockEntity.this.getBlockState(), JarBlockEntity.this.getBlockState(), 11);
        }
    }
}

