/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings;

import dev.ftb.mods.ftblibrary.snbt.config.BooleanValue;
import dev.ftb.mods.ftblibrary.snbt.config.DoubleValue;
import dev.ftb.mods.ftblibrary.snbt.config.IntValue;
import dev.ftb.mods.ftblibrary.snbt.config.SNBTConfig;
import dev.ftb.mods.ftblibrary.snbt.config.StringValue;
import dev.ftb.mods.ftbstuffnthings.blocks.sluice.SluiceProperties;
import dev.ftb.mods.ftbstuffnthings.blocks.sluice.SluiceType;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.util.Lazy;

public interface Config {
    public static final SNBTConfig CONFIG = SNBTConfig.create((String)"ftbstuff");
    public static final SNBTConfig GENERAL_CONFIG = CONFIG.addGroup("general");
    public static final BooleanValue INCLUDE_DEV_RECIPES = (BooleanValue)GENERAL_CONFIG.addBoolean("include_dev_recipes", false).comment(new String[]{"If true, dev/testing recipes will be available outside a development environment", "Leave this false unless actually testing the mod."});
    public static final BooleanValue HIDE_TEMPERATURE_INGREDIENTS = (BooleanValue)GENERAL_CONFIG.addBoolean("hide_temperature_ingredients", false).comment(new String[]{"If true, the custom temperature ingredients will not be displayed"});
    public static final SNBTConfig SLUICE_CONFIG = CONFIG.addGroup("sluice");
    public static final Map<SluiceType, SluiceProperties> SLUICE_PROPERTIES = (Map)Util.make(new EnumMap(SluiceType.class), map -> {
        for (SluiceType type : SluiceType.values()) {
            SNBTConfig config = SLUICE_CONFIG.addGroup(type.getSerializedName());
            map.put(type, new SluiceProperties((DoubleValue)config.addDouble("timeMultiplier", type.defTimeMod).comment(new String[]{"How long it takes to process a resource in this Sluice (multiplier for recipe base tick time)"}), (DoubleValue)config.addDouble("fluidMultiplier", type.defFluidMod).comment(new String[]{"How much fluid is used per recipe (multiplier for recipe's fluid consumption rate)"}), (IntValue)config.addInt("tankCapacity", type.defCapacity).comment(new String[]{"How much fluid this sluice's tank can carry (in mB)"}), (BooleanValue)config.addBoolean("allowsIO", type.defItemIO).comment(new String[]{"Can items be piped in? False = items only clicked in manually"}), (BooleanValue)config.addBoolean("allowsTank", type.defFluidIO).comment(new String[]{"Can fluid be piped in? False = need to use adjacent Pump"}), (BooleanValue)config.addBoolean("upgradeable", type.defUpgradeable).comment(new String[]{"Can sluice be upgraded?"}), (IntValue)config.addInt("energyUsage", type.defEnergyUsage).comment(new String[]{"FE cost per use"})));
        }
    });
    public static final SNBTConfig AUTOHAMMER_CONFIG = CONFIG.addGroup("autohammer");
    public static final IntValue IRON_HAMMER_SPEED = (IntValue)AUTOHAMMER_CONFIG.addInt("stone_hammer_speed", 50, 1, 100000).comment(new String[]{"Speed of the iron auto-hammer as ticks taken to process a block"});
    public static final IntValue GOLD_HAMMER_SPEED = (IntValue)AUTOHAMMER_CONFIG.addInt("gold_hammer_speed", 40, 1, 100000).comment(new String[]{"Speed of the gold auto-hammer as ticks taken to process a block"});
    public static final IntValue DIAMOND_HAMMER_SPEED = (IntValue)AUTOHAMMER_CONFIG.addInt("diamond_hammer_speed", 30, 1, 100000).comment(new String[]{"Speed of the diamond auto-hammer as ticks taken to process a block"});
    public static final IntValue NETHERITE_HAMMER_SPEED = (IntValue)AUTOHAMMER_CONFIG.addInt("netherite_hammer_speed", 15, 1, 100000).comment(new String[]{"Speed of the netherite auto-hammer as ticks taken to process a block"});
    public static final SNBTConfig COBBLEGEN_CONFIG = CONFIG.addGroup("cobblegen");
    public static final IntValue COBBLEGEN_TICK_RATE = (IntValue)COBBLEGEN_CONFIG.addInt("cobblegen_tick_rate", 20, 1, Integer.MAX_VALUE).comment(new String[]{"The delay between each cobble generation in ticks"});
    public static final IntValue STONE_COBBLEGEN_AMOUNT = (IntValue)COBBLEGEN_CONFIG.addInt("stone_cobblegen_amount", 1, 1, 1000).comment(new String[]{"Amount of cobble the stone cobblegen produces per tick"});
    public static final IntValue IRON_COBBLEGEN_AMOUNT = (IntValue)COBBLEGEN_CONFIG.addInt("iron_cobblegen_amount", 8, 1, 1000).comment(new String[]{"Amount of cobble the iron cobblegen produces per tick"});
    public static final IntValue GOLD_COBBLEGEN_AMOUNT = (IntValue)COBBLEGEN_CONFIG.addInt("gold_cobblegen_amount", 16, 1, 1000).comment(new String[]{"Amount of cobble the gold cobblegen produces per tick"});
    public static final IntValue DIAMOND_COBBLEGEN_AMOUNT = (IntValue)COBBLEGEN_CONFIG.addInt("diamond_cobblegen_amount", 32, 1, 1000).comment(new String[]{"Amount of cobble the diamond cobblegen produces per tick"});
    public static final IntValue NETHERITE_COBBLEGEN_AMOUNT = (IntValue)COBBLEGEN_CONFIG.addInt("netherite_cobblegen_amount", 64, 1, 1000).comment(new String[]{"Amount of cobble the netherite cobblegen produces per tick"});
    public static final SNBTConfig BASALTGEN_CONFIG = CONFIG.addGroup("basaltgen");
    public static final IntValue BASALTGEN_TICK_RATE = (IntValue)BASALTGEN_CONFIG.addInt("basaltgen_tick_rate", 20, 1, Integer.MAX_VALUE).comment(new String[]{"The delay between each cobble generation in ticks"});
    public static final IntValue STONE_BASALTGEN_AMOUNT = (IntValue)BASALTGEN_CONFIG.addInt("stone_basaltgen_amount", 1, 1, 1000).comment(new String[]{"Amount of cobble the stone basaltgen produces per tick"});
    public static final IntValue IRON_BASALTGEN_AMOUNT = (IntValue)BASALTGEN_CONFIG.addInt("iron_basaltgen_amount", 8, 1, 1000).comment(new String[]{"Amount of cobble the iron basaltgen produces per tick"});
    public static final IntValue GOLD_BASALTGEN_AMOUNT = (IntValue)BASALTGEN_CONFIG.addInt("gold_basaltgen_amount", 16, 1, 1000).comment(new String[]{"Amount of cobble the gold basaltgen produces per tick"});
    public static final IntValue DIAMOND_BASALTGEN_AMOUNT = (IntValue)BASALTGEN_CONFIG.addInt("diamond_basaltgen_amount", 32, 1, 1000).comment(new String[]{"Amount of cobble the diamond basaltgen produces per tick"});
    public static final IntValue NETHERITE_BASALTGEN_AMOUNT = (IntValue)BASALTGEN_CONFIG.addInt("netherite_basaltgen_amount", 64, 1, 1000).comment(new String[]{"Amount of cobble the netherite basaltgen produces per tick"});
    public static final SNBTConfig WATER_STRAINER_CONFIG = CONFIG.addGroup("water_strainer");
    public static final IntValue STRAINER_TICK_RATE = (IntValue)WATER_STRAINER_CONFIG.addInt("strainer_tick_rate", 20, 1, Integer.MAX_VALUE).comment(new String[]{"The delay between each strainer generation in ticks"});
    public static final StringValue STRAINER_LOOT_TABLE = (StringValue)WATER_STRAINER_CONFIG.addString("strainer_loot_table", "ftbstuff:custom/water_strainer_test").comment(new String[]{"Location of the loot table used to generate strainer loot from"});
    public static final SNBTConfig PUMP_CONFIG = CONFIG.addGroup("pump");
    public static final IntValue PUMP_MAX_CHARGE = (IntValue)PUMP_CONFIG.addInt("pump_max_charge", 6000, 1000, Integer.MAX_VALUE).comment(new String[]{"Maximum charge the Pump can have. 20 charge is consumed for every 1000mB of water pumped"});
    public static final IntValue PUMP_CHARGEUP_AMOUNT = (IntValue)PUMP_CONFIG.addInt("pump_chargeup_amount", 14, 1, Integer.MAX_VALUE).comment(new String[]{"Amount of charge to add each time the Pump is right-clicked by a player. 20 charge is consumed for every 1000mB of water pumped"});
    public static final IntValue PUMP_FLUID_TRANSFER = (IntValue)PUMP_CONFIG.addInt("pump_fluid_transfer", 1000, 1, Integer.MAX_VALUE).comment(new String[]{"Amount of water to transfer to each valid neighbouring fluid tank on each work cycle (every 20 ticks)."});

    public static Lazy<SluiceProperties> makeSluiceProperties(SluiceType type) {
        return Lazy.of(() -> SLUICE_PROPERTIES.get((Object)type));
    }

    public static Optional<ResourceLocation> getStrainerLootTable() {
        return Optional.ofNullable(ResourceLocation.tryParse((String)((String)STRAINER_LOOT_TABLE.get())));
    }
}

