/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.packcompanion.features.actionpad.client;

import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.ui.misc.AbstractButtonListScreen;
import dev.ftb.mods.ftblibrary.ui.misc.SimpleToast;
import dev.ftb.packcompanion.core.utils.NameAndUuid;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;

public class ActionTPAScreen
extends AbstractButtonListScreen {
    private final List<NameAndUuid> users;

    public ActionTPAScreen(List<NameAndUuid> users) {
        this.showBottomPanel(false);
        this.setHasSearchBox(true);
        this.setTitle((Component)Component.translatable((String)"ftbpackcompanion.tpa"));
        this.users = users;
    }

    public boolean onInit() {
        int max = this.getTheme().getStringWidth((FormattedText)this.getTitle());
        for (NameAndUuid user : this.users) {
            max = Math.max(max, this.getTheme().getStringWidth((FormattedText)Component.translatable((String)user.name())) + 20);
        }
        this.setSize(Mth.clamp((int)max, (int)150, (int)(this.getWindow().getGuiScaledWidth() * 3 / 4)), Mth.clamp((int)(20 + this.getTopPanelHeight() + this.users.size() * 20), (int)50, (int)(this.getWindow().getGuiScaledHeight() * 3 / 4)));
        return true;
    }

    public void addButtons(Panel panel) {
        for (final NameAndUuid user : this.users) {
            panel.add((Widget)new SimpleTextButton(this, panel, (Component)Component.translatable((String)user.name()), (Icon)Icon.empty()){

                public void onClicked(MouseButton mouseButton) {
                    LocalPlayer player = Minecraft.getInstance().player;
                    if (player != null) {
                        player.connection.sendCommand("tpa " + user.name());
                        SimpleToast.info((Component)Component.translatable((String)"ftbpackcompanion.actionpad.tpa.request_sent"), (Component)Component.literal((String)user.name()));
                    }
                    this.closeGui();
                }
            });
        }
    }

    protected void doCancel() {
    }

    protected void doAccept() {
    }
}

