/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.packcompanion.core.utils;

import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import java.util.function.Function;

public record CustomYConfig(String dimension, DimensionEqualityCheck equalityCheck, int x, int z, int range, int minY, boolean asRadius) {
    public SNBTCompoundTag asCompound() {
        SNBTCompoundTag compound = new SNBTCompoundTag();
        compound.putString("dimension", this.dimension);
        compound.putString("equalityCheck", this.equalityCheck.toString());
        compound.putInt("x", this.x);
        compound.putInt("z", this.z);
        compound.putInt("minY", this.minY);
        compound.putInt("range", this.range);
        compound.putBoolean("asRadius", this.asRadius);
        return compound;
    }

    public static CustomYConfig fromCompound(SNBTCompoundTag compound) {
        String dimension = compound.getString("dimension");
        int x = compound.getInt("x");
        int z = compound.getInt("z");
        int range = compound.getInt("range");
        if (range <= 0) {
            throw new RuntimeException("Invalid range for custom_y_level_chunk_positions");
        }
        int minY = compound.getInt("minY");
        boolean asRadius = CustomYConfig.getOrDefault(compound, tag -> tag.getBoolean("asRadius"), false);
        DimensionEqualityCheck equalityCheck = DimensionEqualityCheck.fromString(CustomYConfig.getOrDefault(compound, tag -> tag.getString("equalityCheck"), "starts_with"));
        return new CustomYConfig(dimension, equalityCheck, x, z, range, minY, asRadius);
    }

    private static <T> T getOrDefault(SNBTCompoundTag compoundTag, Function<SNBTCompoundTag, T> reader, T defaultValue) {
        try {
            return reader.apply(compoundTag);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static enum DimensionEqualityCheck {
        STARTS_WITH,
        EXACT_MATCH,
        ENDS_WITH;


        public static DimensionEqualityCheck fromString(String str) {
            try {
                return DimensionEqualityCheck.valueOf(str.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return STARTS_WITH;
            }
        }

        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

