/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbfiltersystem.client.gui;

import dev.ftb.mods.ftbfiltersystem.api.client.gui.AbstractFilterConfigScreen;
import dev.ftb.mods.ftbfiltersystem.api.client.gui.AbstractFilterScreen;
import dev.ftb.mods.ftbfiltersystem.client.GuiUtil;
import dev.ftb.mods.ftbfiltersystem.client.gui.GhostDropReceiver;
import dev.ftb.mods.ftbfiltersystem.client.gui.widget.ItemWidget;
import dev.ftb.mods.ftbfiltersystem.filter.ItemFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.HolderLookup;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ItemConfigScreen
extends AbstractFilterConfigScreen<ItemFilter>
implements GhostDropReceiver {
    private static final int SEARCH_ROWS = 4;
    private static final int SEARCH_COLS = 9;
    private static ItemSource itemSource = ItemSource.CREATIVE;
    private static String lastSearch = "";
    private static List<SearchEntry> cachedCreativeEntries;
    private static List<SearchEntry> cachedInventoryEntries;
    private final List<ItemStack> currentStacks = new ArrayList<ItemStack>();
    private Rect2i scrollArea;
    private double currentScroll;
    private boolean isScrolling;
    private EditBox searchField;
    private final List<SearchItemWidget> itemWidgets = new ArrayList<SearchItemWidget>();
    private ItemWidget selectedWidget;

    public ItemConfigScreen(ItemFilter filter, AbstractFilterScreen parentScreen) {
        super(filter, parentScreen, 194, 117);
        cachedInventoryEntries = null;
    }

    @Override
    protected void init() {
        super.init();
        this.searchField = this.makeSearchEditBox(this.leftPos + 8, this.topPos + 38, () -> lastSearch, s -> {
            lastSearch = s;
        });
        this.addRenderableWidget((GuiEventListener)this.searchField);
        this.setFocused((GuiEventListener)this.searchField);
        this.selectedWidget = (ItemWidget)this.addRenderableWidget((GuiEventListener)new ItemWidget(this.leftPos + 8, this.topPos + 17, 18, 18, ItemStack.EMPTY));
        int btnWidth = Arrays.stream(ItemSource.values()).map(val -> this.font.width((FormattedText)val.getDisplayName())).max(Integer::compareTo).orElse(50) + 10;
        this.addRenderableWidget((GuiEventListener)CycleButton.builder(ItemSource::getDisplayName).withValues((Object[])ItemSource.values()).displayOnlyValue().withInitialValue((Object)itemSource).create(this.leftPos + this.guiWidth - btnWidth - 21, this.topPos + 5, btnWidth, 16, (Component)Component.empty(), (btn, val) -> {
            itemSource = val;
            this.updateSearchEntries();
        }));
        this.itemWidgets.clear();
        for (int row = 0; row < 4; ++row) {
            for (int col = 0; col < 9; ++col) {
                SearchItemWidget w = new SearchItemWidget(row, col);
                this.itemWidgets.add(w);
                this.addRenderableWidget((GuiEventListener)w);
            }
        }
        this.scrollArea = new Rect2i(this.leftPos + 174, this.topPos + 55, 14, 70);
        this.setSelectedStack(new ItemStack((ItemLike)((ItemFilter)this.filter).getMatchItem()));
        this.updateSearchEntries();
    }

    private void setSelectedStack(ItemStack stack) {
        this.selectedWidget.setStack(stack.copy());
    }

    @Override
    protected void doScheduledUpdate() {
        this.updateSearchEntries();
    }

    @Override
    public void render(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.render(guiGraphics, pMouseX, pMouseY, pPartialTick);
        int sx = this.scrollArea.getX();
        int sy1 = this.scrollArea.getY();
        int sy2 = sy1 + this.scrollArea.getHeight();
        FormattedText txt = GuiUtil.ellipsize(this.font, (FormattedText)this.selectedWidget.getStack().getItem().getDescription(), this.leftPos + this.guiWidth - (this.selectedWidget.getX() + this.selectedWidget.getWidth() + 6));
        guiGraphics.drawString(this.font, Language.getInstance().getVisualOrder(txt), this.selectedWidget.getX() + this.selectedWidget.getWidth() + 3, this.selectedWidget.getY() + 8, 0x404040, false);
        guiGraphics.fill(this.scrollArea.getX() - 2, this.scrollArea.getY() - 2, this.scrollArea.getX() + this.scrollArea.getWidth(), this.scrollArea.getY() + this.scrollArea.getHeight(), -8355712);
        guiGraphics.fill(this.scrollArea.getX() - 1, this.scrollArea.getY() - 1, this.scrollArea.getX() + this.scrollArea.getWidth() - 1, this.scrollArea.getY() + this.scrollArea.getHeight() - 1, -6250336);
        guiGraphics.blitSprite(ResourceLocation.withDefaultNamespace((String)"container/creative_inventory/scroller"), sx, sy1 + (int)((double)(sy2 - sy1 - 17) * this.currentScroll), 12, 15);
    }

    public boolean mouseScrolled(double x, double y, double dirX, double dirY) {
        if (dirY != 0.0 && this.needsScrollBars()) {
            int j = this.currentStacks.size() / 10 - 3 + 1;
            float i = dirY > 0.0 ? 1.0f : -1.0f;
            this.scrollTo(Mth.clamp((double)(this.currentScroll - (double)(i / (float)j)), (double)0.0, (double)1.0));
            return true;
        }
        return super.mouseScrolled(x, y, dirX, dirY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean bl = this.isScrolling = button == 0 && this.needsScrollBars() && this.scrollArea.contains((int)mouseX, (int)mouseY);
        if (this.isScrolling) {
            this.scrollToMouse(mouseY);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isScrolling) {
            this.scrollToMouse(mouseY);
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.isScrolling = false;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    protected ItemFilter makeNewFilter() {
        return new ItemFilter(((ItemFilter)this.filter).getParent(), this.selectedWidget.getStack().getItem());
    }

    private boolean needsScrollBars() {
        return this.currentStacks.size() > 36;
    }

    private void scrollToMouse(double mouseY) {
        this.scrollTo(Mth.clamp((double)((mouseY - (double)this.scrollArea.getY()) / (double)this.scrollArea.getHeight()), (double)0.0, (double)1.0));
    }

    private void scrollTo(double scrollPos) {
        this.currentScroll = scrollPos;
        int i = this.currentStacks.size() / 9 - 4 + 1;
        int j = Math.max(0, (int)(this.currentScroll * (double)i + 0.5));
        for (int row = 0; row < 4; ++row) {
            for (int col = 0; col < 9; ++col) {
                int idx = col + (row + j) * 9;
                ItemStack stack = idx >= 0 && idx < this.currentStacks.size() ? this.currentStacks.get(idx) : ItemStack.EMPTY;
                this.itemWidgets.get(row * 9 + col).setStack(stack);
            }
        }
    }

    private void updateSearchEntries() {
        this.currentStacks.clear();
        String srch = this.searchField.getValue().toLowerCase();
        List<ItemStack> applicableEntries = itemSource.get().stream().filter(entry -> entry.test(srch)).map(entry -> entry.stack).toList();
        this.currentStacks.addAll(applicableEntries);
        this.scrollTo(0.0);
    }

    @Override
    public Rect2i getGhostDropRegion() {
        return new Rect2i(this.selectedWidget.getX(), this.selectedWidget.getY(), this.selectedWidget.getWidth(), this.selectedWidget.getHeight());
    }

    @Override
    public void receiveGhostDrop(ItemStack stack) {
        this.selectedWidget.setStack(stack);
    }

    static enum ItemSource {
        CREATIVE(ItemSource::getCreativeItems, "creative"),
        INV(ItemSource::getInventoryItems, "inventory");

        private final Supplier<List<SearchEntry>> itemSupplier;
        private final Component name;

        private ItemSource(Supplier<List<SearchEntry>> itemSupplier, String name) {
            this.itemSupplier = itemSupplier;
            this.name = Component.translatable((String)("ftbfiltersystem.gui.item_source." + name));
        }

        List<SearchEntry> get() {
            return this.itemSupplier.get();
        }

        public Component getDisplayName() {
            return this.name;
        }

        private static List<SearchEntry> getCreativeItems() {
            if (cachedCreativeEntries == null) {
                CreativeModeTabs.tryRebuildTabContents((FeatureFlagSet)FeatureFlags.DEFAULT_FLAGS, (boolean)false, (HolderLookup.Provider)Minecraft.getInstance().level.registryAccess());
                cachedCreativeEntries = CreativeModeTabs.searchTab().getDisplayItems().stream().map(SearchEntry::new).toList();
            }
            return cachedCreativeEntries;
        }

        private static List<SearchEntry> getInventoryItems() {
            if (cachedInventoryEntries == null) {
                int i;
                Inventory inv = Minecraft.getInstance().player.getInventory();
                cachedInventoryEntries = new ArrayList<SearchEntry>();
                for (i = 9; i < 36; ++i) {
                    cachedInventoryEntries.add(new SearchEntry((ItemStack)inv.items.get(i)));
                }
                for (i = 0; i < 9; ++i) {
                    cachedInventoryEntries.add(new SearchEntry((ItemStack)inv.items.get(i)));
                }
            }
            return cachedInventoryEntries;
        }
    }

    private class SearchItemWidget
    extends ItemWidget {
        public SearchItemWidget(int row, int col) {
            super(ItemConfigScreen.this.leftPos + 8 + 18 * col, ItemConfigScreen.this.topPos + 53 + 18 * row, 18, 18, ItemStack.EMPTY);
        }

        @Override
        protected void handleClick(boolean doubleClick) {
            if (doubleClick) {
                ItemConfigScreen.this.applyChanges();
            } else {
                ItemConfigScreen.this.setSelectedStack(this.getStack());
            }
        }

        @Nullable
        public Tooltip getTooltip() {
            return super.getTooltip();
        }
    }

    static class SearchEntry
    implements Predicate<String> {
        public final ItemStack stack;
        private final String tooltip;

        SearchEntry(ItemStack stack) {
            List l;
            this.stack = stack;
            try {
                Minecraft mc = Minecraft.getInstance();
                l = stack.getTooltipLines(Item.TooltipContext.of((Level)mc.level), (Player)mc.player, (TooltipFlag)(mc.options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL)).stream().map(Component::getString).collect(Collectors.toList());
            }
            catch (Exception ignored) {
                l = Collections.emptyList();
            }
            this.tooltip = String.join((CharSequence)"\n", l).toLowerCase();
        }

        @Override
        public boolean test(String searchString) {
            return this.tooltip.contains(searchString);
        }
    }
}

