/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.commands.impl.teleporting;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import dev.ftb.mods.ftbessentials.commands.FTBCommand;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.phys.Vec3;

public class OfflineTeleportCommand
implements FTBCommand {
    @Override
    public boolean enabled() {
        return FTBEConfig.TP_OFFLINE.isEnabled();
    }

    @Override
    public List<LiteralArgumentBuilder<CommandSourceStack>> register() {
        LiteralArgumentBuilder tpOffline = Commands.literal((String)"tp_offline");
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)tpOffline.requires(FTBEConfig.TP_OFFLINE.enabledAndOp())).then(Commands.literal((String)"name").then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).then(Commands.argument((String)"pos", (ArgumentType)Vec3Argument.vec3()).executes(ctx -> this.tpOffline((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"player"), ((CommandSourceStack)ctx.getSource()).getLevel(), Vec3Argument.getCoordinates((CommandContext)ctx, (String)"pos"))))))).then(Commands.literal((String)"id").then(Commands.argument((String)"player_id", (ArgumentType)UuidArgument.uuid()).then(Commands.argument((String)"pos", (ArgumentType)Vec3Argument.vec3()).executes(ctx -> this.tpOffline((CommandSourceStack)ctx.getSource(), UuidArgument.getUuid((CommandContext)ctx, (String)"player_id"), ((CommandSourceStack)ctx.getSource()).getLevel(), Vec3Argument.getCoordinates((CommandContext)ctx, (String)"pos"))))));
        LiteralArgumentBuilder alias = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tpo").requires(FTBEConfig.TP_OFFLINE.enabledAndOp())).redirect((CommandNode)tpOffline.build());
        return List.of(tpOffline, alias);
    }

    private int tpOffline(CommandSourceStack source, String playerName, ServerLevel level, Coordinates dest) {
        source.getServer().getProfileCache().getAsync(playerName).whenComplete((profileOpt, throwable) -> source.getServer().executeIfPossible(() -> profileOpt.ifPresentOrElse(profile -> this.tpOffline(source, profile.getId(), level, dest), () -> source.sendFailure((Component)Component.translatable((String)"ftbessentials.unknown_player", (Object[])new Object[]{playerName})))));
        return 1;
    }

    private int tpOffline(CommandSourceStack source, UUID playerId, ServerLevel level, Coordinates dest) {
        MinecraftServer server = source.getServer();
        Path playerDir = server.getWorldPath(LevelResource.PLAYER_DATA_DIR);
        Path datFile = playerDir.resolve(String.valueOf(playerId) + ".dat");
        if (server.getPlayerList().getPlayer(playerId) != null) {
            source.sendFailure((Component)Component.translatable((String)"ftbessentials.tp_offline.player_is_online"));
            return 0;
        }
        try {
            CompoundTag tag = NbtIo.readCompressed((Path)datFile, (NbtAccounter)NbtAccounter.unlimitedHeap());
            Vec3 vec = dest.getPosition(source);
            ListTag newPos = new ListTag();
            newPos.add((Object)DoubleTag.valueOf((double)vec.x));
            newPos.add((Object)DoubleTag.valueOf((double)vec.y));
            newPos.add((Object)DoubleTag.valueOf((double)vec.z));
            tag.put("Pos", (Tag)newPos);
            tag.putString("Dimension", level.dimension().location().toString());
            Path tempFile = File.createTempFile(String.valueOf(playerId) + "-", ".dat", playerDir.toFile()).toPath();
            NbtIo.writeCompressed((CompoundTag)tag, (Path)tempFile);
            Path backupFile = playerDir.resolve(String.valueOf(playerId) + ".dat_old");
            Util.safeReplaceFile((Path)datFile, (Path)tempFile, (Path)backupFile);
            String pos = String.format("[%.2f,%.2f,%.2f]", vec.x, vec.y, vec.z);
            source.sendSuccess(() -> Component.translatable((String)"ftbessentials.tp_offline.moved", (Object[])new Object[]{playerId, pos, source.getLevel().dimension().location()}), false);
            return 1;
        }
        catch (IOException e) {
            source.sendFailure((Component)Component.translatable((String)"ftbessentials.tp_offline.cant_update", (Object[])new Object[]{e.getMessage()}).withStyle(ChatFormatting.RED));
            return 0;
        }
    }
}

