/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbechoes.util;

import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class TeamStages {
    private static final String ECHOES_TEAMSTAGES = "ftbechoes:team_stages";

    public static boolean addTeamStage(UUID teamId, String stage) {
        return FTBTeamsAPI.api().getManager().getTeamByID(teamId).map(team -> TeamStages.addTeamStage(team, stage)).orElse(false);
    }

    public static boolean removeTeamStage(UUID teamId, String stage) {
        return FTBTeamsAPI.api().getManager().getTeamByID(teamId).map(team -> TeamStages.removeTeamStage(team, stage)).orElse(false);
    }

    public static boolean hasTeamStage(UUID teamId, String stage) {
        return FTBTeamsAPI.api().getManager().getTeamByID(teamId).map(team -> TeamStages.hasTeamStage(team, stage)).orElse(false);
    }

    public static boolean addTeamStage(Team team, String stage) {
        return TeamStages.updateStage(team, stage, true);
    }

    public static boolean removeTeamStage(Team team, String stage) {
        return TeamStages.updateStage(team, stage, false);
    }

    public static boolean hasTeamStage(Team team, String stage) {
        return team.getExtraData().getCompound(ECHOES_TEAMSTAGES).contains(stage, 8);
    }

    private static boolean updateStage(Team team, String stage, boolean adding) {
        if (adding == TeamStages.hasTeamStage(team, stage)) {
            return false;
        }
        CompoundTag root = team.getExtraData();
        if (!root.contains(ECHOES_TEAMSTAGES, 10)) {
            root.put(ECHOES_TEAMSTAGES, (Tag)new CompoundTag());
        }
        CompoundTag stages = root.getCompound(ECHOES_TEAMSTAGES);
        if (adding) {
            stages.putBoolean(stage, true);
        } else {
            stages.remove(stage);
        }
        team.markDirty();
        return true;
    }
}

