/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbechoes.shopping;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.ftb.mods.ftbechoes.echo.CommandInfo;
import dev.ftb.mods.ftbechoes.echo.progress.TeamProgressManager;
import dev.ftb.mods.ftbechoes.shopping.ShoppingKey;
import dev.ftb.mods.ftbechoes.util.EchoCodecs;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.util.NetworkHelper;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public record ShopData(String name, List<ItemStack> stacks, int cost, List<Component> description, Optional<Icon> icon, Optional<CommandInfo> command, Optional<Integer> maxClaims, boolean perPlayerMax, int maxStage) {
    private static final Codec<ShopData> RAW_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.STRING.fieldOf("name").forGetter(ShopData::name), (App)EchoCodecs.ITEM_OR_ITEMS_CODEC.optionalFieldOf("item", List.of()).forGetter(ShopData::stacks), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("cost", (Object)1).forGetter(ShopData::cost), (App)EchoCodecs.COMPONENT_OR_LIST.optionalFieldOf("description", List.of()).forGetter(ShopData::description), (App)Icon.STRING_CODEC.optionalFieldOf("icon").forGetter(ShopData::icon), (App)CommandInfo.CODEC.optionalFieldOf("command").forGetter(ShopData::command), (App)Codec.INT.optionalFieldOf("max_claims").forGetter(ShopData::maxClaims), (App)Codec.BOOL.optionalFieldOf("per_player_max_claims", (Object)false).forGetter(ShopData::perPlayerMax), (App)Codec.INT.optionalFieldOf("max_stage", (Object)Integer.MAX_VALUE).forGetter(ShopData::maxStage)).apply((Applicative)builder, ShopData::new));
    public static final Codec<ShopData> CODEC = RAW_CODEC.validate(ShopData::validate);
    public static final StreamCodec<RegistryFriendlyByteBuf, ShopData> STREAM_CODEC = NetworkHelper.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, ShopData::name, (StreamCodec)ItemStack.STREAM_CODEC.apply(ByteBufCodecs.list()), ShopData::stacks, (StreamCodec)ByteBufCodecs.VAR_INT, ShopData::cost, (StreamCodec)ComponentSerialization.STREAM_CODEC.apply(ByteBufCodecs.list()), ShopData::description, (StreamCodec)ByteBufCodecs.optional((StreamCodec)Icon.STREAM_CODEC), ShopData::icon, (StreamCodec)ByteBufCodecs.optional(CommandInfo.STREAM_CODEC), ShopData::command, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.VAR_INT), ShopData::maxClaims, (StreamCodec)ByteBufCodecs.BOOL, ShopData::perPlayerMax, (StreamCodec)ByteBufCodecs.VAR_INT, ShopData::maxStage, ShopData::new);

    private DataResult<ShopData> validate() {
        if (this.stacks.isEmpty() && (this.icon.isEmpty() || this.command.isEmpty())) {
            return DataResult.error(() -> "when item is empty, icon, description and command must all be specified");
        }
        if (!this.stacks.isEmpty() && this.command.isPresent()) {
            return DataResult.error(() -> "when item is not empty, icon, command must not be specified");
        }
        return DataResult.success((Object)this);
    }

    public void giveTo(ShoppingKey key, ServerPlayer player, int nOrders) {
        for (ItemStack stack : this.stacks()) {
            ItemStack toGive;
            for (int total = stack.getCount() * nOrders; total > 0; total -= toGive.getCount()) {
                toGive = stack.copyWithCount(Math.min(total, stack.getMaxStackSize()));
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)toGive);
            }
        }
        this.command.ifPresent(cmdInfo -> cmdInfo.runForPlayer(player));
        if (this.maxClaims().isPresent()) {
            TeamProgressManager.get().consumeLimitedShopPurchase(player, key, nOrders, this);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShopData data = (ShopData)o;
        return Objects.equals(this.name, data.name);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.name);
    }
}

