/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbechoes.net;

import dev.ftb.mods.ftbechoes.FTBEchoes;
import dev.ftb.mods.ftbechoes.echo.EchoManager;
import dev.ftb.mods.ftbechoes.echo.progress.TeamProgress;
import dev.ftb.mods.ftbechoes.echo.progress.TeamProgressManager;
import dev.ftb.mods.ftbechoes.net.ClaimRewardResponseMessage;
import dev.ftb.mods.ftbechoes.net.SyncProgressMessage;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ClaimRewardMessage(ResourceLocation echoId, int stageIdx) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ClaimRewardMessage> TYPE = new CustomPacketPayload.Type(FTBEchoes.id("claim_reward"));
    public static final StreamCodec<FriendlyByteBuf, ClaimRewardMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, ClaimRewardMessage::echoId, (StreamCodec)ByteBufCodecs.VAR_INT, ClaimRewardMessage::stageIdx, ClaimRewardMessage::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handleData(ClaimRewardMessage message, IPayloadContext context) {
        ServerPlayer player;
        boolean claimedOK = false;
        Player player2 = context.player();
        if (player2 instanceof ServerPlayer && (player = (ServerPlayer)player2).getServer() != null) {
            MutableComponent detail = Component.literal((String)" ");
            if (EchoManager.getServerInstance().isKnownEcho(message.echoId)) {
                TeamProgressManager mgr = TeamProgressManager.get(player.getServer());
                TeamProgress progress = mgr.getProgress(player).orElse(TeamProgress.NONE);
                if (progress.isStageCompleted(message.echoId, message.stageIdx) && (claimedOK = mgr.claimReward(player, message.echoId, message.stageIdx))) {
                    detail = ClaimRewardMessage.getRewardDetail(message.echoId, message.stageIdx);
                }
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)SyncProgressMessage.forPlayer(progress, player), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ClaimRewardResponseMessage(claimedOK, Optional.ofNullable(detail)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private static Component getRewardDetail(ResourceLocation id, int stageIdx) {
        return EchoManager.getServerInstance().getEcho(id).orElseThrow().stages().get(stageIdx).completionRewardSummary();
    }
}

