/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbechoes.echo.progress;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.ftb.mods.ftbechoes.echo.Echo;
import dev.ftb.mods.ftbechoes.echo.EchoManager;
import dev.ftb.mods.ftbechoes.echo.progress.PerEchoProgress;
import dev.ftb.mods.ftbechoes.shopping.ShopData;
import dev.ftb.mods.ftbechoes.shopping.ShoppingKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.NotNull;

public record TeamProgress(Map<ResourceLocation, PerEchoProgress> perEcho, Map<ShoppingKey, Integer> stockLimit, Map<UUID, Map<ShoppingKey, Integer>> playerStockLimit) {
    private final Map<ResourceLocation, PerEchoProgress> perEcho;
    public static final TeamProgress NONE = new TeamProgress(Map.of(), Map.of(), Map.of());
    private static final Codec<Map<ResourceLocation, PerEchoProgress>> ECHO_STAGE = Codec.unboundedMap((Codec)ResourceLocation.CODEC, PerEchoProgress.CODEC).xmap(HashMap::new, Map::copyOf);
    private static final Codec<Map<ShoppingKey, Integer>> LIMITED_PURCHASE_CODEC = Codec.list((Codec)Codec.pair((Codec)ShoppingKey.CODEC.fieldOf("key").codec(), (Codec)Codec.INT.fieldOf("count").codec())).xmap(TeamProgress::toMap, TeamProgress::toList);
    public static final StreamCodec<FriendlyByteBuf, Map<ShoppingKey, Integer>> LIMITED_PURCHASE_STREAM_CODEC = ByteBufCodecs.map(HashMap::new, ShoppingKey.STREAM_CODEC, (StreamCodec)ByteBufCodecs.VAR_INT);
    public static final Codec<TeamProgress> RAW_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ECHO_STAGE.fieldOf("per_echo").forGetter(TeamProgress::perEcho), (App)LIMITED_PURCHASE_CODEC.optionalFieldOf("limited_shop_purchases", new HashMap()).forGetter(TeamProgress::stockLimit), (App)Codec.unboundedMap((Codec)UUIDUtil.STRING_CODEC, LIMITED_PURCHASE_CODEC).optionalFieldOf("limited_per_player", new HashMap()).forGetter(TeamProgress::playerStockLimit)).apply((Applicative)builder, TeamProgress::new));
    public static final Codec<TeamProgress> CODEC = RAW_CODEC.xmap(in -> new TeamProgress(new HashMap<ResourceLocation, PerEchoProgress>(in.perEcho), new HashMap<ShoppingKey, Integer>(in.stockLimit), new HashMap<UUID, Map<ShoppingKey, Integer>>(in.playerStockLimit)), Function.identity());
    public static final StreamCodec<FriendlyByteBuf, TeamProgress> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.map(HashMap::new, (StreamCodec)ResourceLocation.STREAM_CODEC, PerEchoProgress.STREAM_CODEC), TeamProgress::perEcho, (StreamCodec)ByteBufCodecs.map(HashMap::new, ShoppingKey.STREAM_CODEC, (StreamCodec)ByteBufCodecs.INT), p -> p.stockLimit, (StreamCodec)ByteBufCodecs.map(HashMap::new, (StreamCodec)UUIDUtil.STREAM_CODEC, LIMITED_PURCHASE_STREAM_CODEC), p -> p.playerStockLimit, TeamProgress::new);

    private static <K, V> Map<K, V> toMap(List<Pair<K, V>> list) {
        return (Map)Util.make(new HashMap(), map -> list.forEach(pair -> map.put(pair.getFirst(), pair.getSecond())));
    }

    private static <K, V> List<Pair<K, V>> toList(Map<K, V> map) {
        return (List)Util.make(new ArrayList(), list -> map.forEach((k, v) -> list.add(Pair.of((Object)k, (Object)v))));
    }

    public static TeamProgress createNew() {
        return new TeamProgress(new HashMap<ResourceLocation, PerEchoProgress>(), new HashMap<ShoppingKey, Integer>(), new HashMap<UUID, Map<ShoppingKey, Integer>>());
    }

    public TeamProgress forSyncTo(ServerPlayer player) {
        Map map = (Map)Util.make(new HashMap(), m -> this.perEcho.forEach((id, rec) -> m.put(id, rec.forSyncToPlayer(player))));
        Map playerLimit = (Map)Util.make(new HashMap(), m -> m.put(player.getUUID(), (Map)this.playerStockLimit.getOrDefault(player.getUUID(), new HashMap())));
        return new TeamProgress(map, this.stockLimit, playerLimit);
    }

    public Map<ResourceLocation, PerEchoProgress> perEcho() {
        return Collections.unmodifiableMap(this.perEcho);
    }

    public boolean isRewardClaimed(ResourceLocation echoId, Player player, int stage) {
        return this.getPerEchoProgress(echoId).isRewardClaimed(player, stage);
    }

    public int getCurrentStage(ResourceLocation echoId) {
        return this.getPerEchoProgress(echoId).getCurrentStage();
    }

    public boolean isStageCompleted(ResourceLocation id, int stageIdx) {
        return stageIdx < this.getCurrentStage(id);
    }

    public int getRemainingShopStock(Player player, ShoppingKey key, ShopData data) {
        return data.maxClaims().map(max -> max - this.getLimitMap(player, data).getOrDefault(key, 0)).orElse(Integer.MAX_VALUE);
    }

    public List<Pair<Echo, Integer>> checkForAutoclaim(ServerPlayer sp) {
        ArrayList<Pair<Echo, Integer>> res = new ArrayList<Pair<Echo, Integer>>();
        this.perEcho.forEach((id, per) -> EchoManager.getServerInstance().getEcho((ResourceLocation)id).ifPresent(echo -> {
            for (int stage = 0; stage < echo.stages().size(); ++stage) {
                if (!echo.stages().get(stage).isAutoclaimReward() || !this.isStageCompleted(echo.id(), stage) || !this.claimReward((ResourceLocation)id, sp, stage)) continue;
                res.add(Pair.of((Object)echo, (Object)stage));
            }
        }));
        return res;
    }

    void consumeShopStock(Player player, ShoppingKey key, int count, ShopData data) {
        this.getLimitMap(player, data).merge(key, count, Integer::sum);
    }

    boolean resetShopStock(ResourceLocation echoId) {
        MutableBoolean removed = new MutableBoolean(this.stockLimit.entrySet().removeIf(e -> ((ShoppingKey)e.getKey()).echoId().equals((Object)echoId)));
        this.playerStockLimit.forEach((id, map) -> {
            if (map.entrySet().removeIf(e -> ((ShoppingKey)e.getKey()).echoId().equals((Object)echoId))) {
                removed.setTrue();
            }
        });
        return removed.getValue();
    }

    boolean resetAllRewards(ResourceLocation echoId, UUID playerId) {
        return this.getPerEchoProgress(echoId).clearRewards(playerId);
    }

    boolean resetReward(ResourceLocation echoId, UUID playerId, int stageIdx) {
        return this.getPerEchoProgress(echoId).setRewardClaimed(playerId, stageIdx, false);
    }

    boolean claimReward(ResourceLocation echoId, ServerPlayer player, int stage) {
        if (this.isRewardClaimed(echoId, (Player)player, stage)) {
            return false;
        }
        return EchoManager.getServerInstance().getEcho(echoId).map(echo -> {
            if (stage >= 0 && stage < echo.stages().size()) {
                echo.stages().get(stage).completionReward().ifPresent(c -> c.giveToPlayer(player));
                return this.getPerEchoProgress(echoId).setRewardClaimed(player.getUUID(), stage, true);
            }
            return false;
        }).orElse(false);
    }

    boolean completeStage(Echo echo) {
        PerEchoProgress per = this.getPerEchoProgress(echo.id());
        if (per.getCurrentStage() < echo.stages().size()) {
            per.completeStage();
            return true;
        }
        return false;
    }

    boolean setStage(ResourceLocation echoId, int stageIdx) {
        PerEchoProgress per = this.getPerEchoProgress(echoId);
        Echo echo = EchoManager.getServerInstance().getEcho(echoId).orElseThrow();
        per.setCurrentStage(Mth.clamp((int)stageIdx, (int)0, (int)(echo.stages().size() - 1)));
        return true;
    }

    @NotNull
    private PerEchoProgress getPerEchoProgress(ResourceLocation echoId) {
        return this.perEcho.computeIfAbsent(echoId, k -> PerEchoProgress.createEmptyProgress());
    }

    private Map<ShoppingKey, Integer> getLimitMap(Player player, ShopData data) {
        return data.perPlayerMax() ? this.playerStockLimit.computeIfAbsent(player.getUUID(), k -> new HashMap()) : this.stockLimit;
    }
}

