/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbechoes.echo;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.ftb.mods.ftbechoes.util.EchoCodecs;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ExtraCodecs;

public record CommandInfo(String cmd, int permission, boolean silent, List<Component> description) {
    public static final Codec<CommandInfo> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.STRING.fieldOf("run").forGetter(CommandInfo::cmd), (App)ExtraCodecs.intRange((int)0, (int)4).optionalFieldOf("permission", (Object)0).forGetter(CommandInfo::permission), (App)Codec.BOOL.optionalFieldOf("silent", (Object)true).forGetter(CommandInfo::silent), (App)EchoCodecs.COMPONENT_OR_LIST.optionalFieldOf("description", List.of()).forGetter(CommandInfo::description)).apply((Applicative)builder, CommandInfo::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, CommandInfo> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, CommandInfo::cmd, (StreamCodec)ByteBufCodecs.VAR_INT, CommandInfo::permission, (StreamCodec)ByteBufCodecs.BOOL, CommandInfo::silent, (StreamCodec)ComponentSerialization.STREAM_CODEC.apply(ByteBufCodecs.list()), CommandInfo::description, CommandInfo::new);

    public void runForPlayer(ServerPlayer sp) {
        if (sp.getServer() != null) {
            CommandSourceStack stack = sp.createCommandSourceStack().withPermission(this.permission);
            sp.getServer().getCommands().performPrefixedCommand(this.silent ? stack.withSuppressedOutput() : stack, this.cmd);
        }
    }
}

