/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbechoes.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import org.jetbrains.annotations.Nullable;

public enum EchoSoundClipHandler {
    INSTANCE;

    private SoundInstance playingSoundInstance = null;

    public void startPlayingSound(SoundEvent soundEvent) {
        if (this.playingSoundInstance != null) {
            Minecraft.getInstance().getSoundManager().stop(this.playingSoundInstance);
        }
        this.playingSoundInstance = EchoSoundClipHandler.createSoundInstance(soundEvent);
        if (this.playingSoundInstance != null) {
            Minecraft.getInstance().getSoundManager().play(this.playingSoundInstance);
        }
    }

    public void stopPlayingSound() {
        this.startPlayingSound(null);
    }

    public boolean isPlayingSound() {
        return this.playingSoundInstance != null && Minecraft.getInstance().getSoundManager().isActive(this.playingSoundInstance);
    }

    public boolean isPlayingSound(SoundEvent soundEvent) {
        return this.isPlayingSound() && this.playingSoundInstance.getLocation().equals((Object)soundEvent.getLocation());
    }

    @Nullable
    private static SimpleSoundInstance createSoundInstance(SoundEvent sound) {
        if (sound == null) {
            return null;
        }
        return new SimpleSoundInstance(sound.getLocation(), SoundSource.VOICE, 1.0f, 1.0f, SoundInstance.createUnseededRandom(), false, 0, SoundInstance.Attenuation.NONE, 0.0, 0.0, 0.0, true);
    }
}

