/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbbackups.api;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.ftb.mods.ftbbackups.Backups;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.io.FileUtils;

public record Backup(long time, ResourceLocation archivalPlugin, String fileId, String worldName, int index, boolean success, long size, int fileCount) implements Comparable<Backup>
{
    public static final Codec<Backup> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.LONG.fieldOf("time").forGetter(Backup::time), (App)ResourceLocation.CODEC.fieldOf("archival_plugin").forGetter(Backup::archivalPlugin), (App)Codec.STRING.fieldOf("file").forGetter(Backup::fileId), (App)Codec.STRING.optionalFieldOf("world_name", (Object)"<not known>").forGetter(Backup::worldName), (App)Codec.INT.fieldOf("index").forGetter(Backup::index), (App)Codec.BOOL.fieldOf("success").forGetter(Backup::success), (App)Codec.LONG.fieldOf("size").forGetter(Backup::size), (App)Codec.INT.fieldOf("file_count").forGetter(Backup::fileCount)).apply((Applicative)builder, Backup::new));
    public static final Codec<List<Backup>> LIST_CODEC = Codec.list(CODEC);

    @Override
    public int hashCode() {
        return Long.hashCode(this.time);
    }

    @Override
    public String toString() {
        return this.fileId;
    }

    @Override
    public boolean equals(Object o) {
        return o == this || o instanceof Backup && ((Backup)o).time == this.time;
    }

    public boolean deleteFiles(Path backupsFolder) {
        Path path = backupsFolder.resolve(this.fileId);
        try {
            if (Files.isRegularFile(path, new LinkOption[0])) {
                Files.delete(path);
            } else if (Files.isDirectory(path, new LinkOption[0])) {
                FileUtils.deleteDirectory((File)path.toFile());
            }
        }
        catch (IOException e) {
            Backups.LOGGER.error("Can't delete backup {}: {} / {}", new Object[]{this.fileId(), e.getClass(), e.getMessage()});
            return false;
        }
        Backups.LOGGER.info("Deleted backup: {}", (Object)this.fileId());
        return true;
    }

    @Override
    public int compareTo(Backup o) {
        return Long.compare(this.time, o.time);
    }
}

